/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.GuiSettings;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SortedTreeModel;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.TreeCellEditor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.TreeCellRenderer;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.UserGroupTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionListener;

public abstract class UsersPanel
extends JPanel {
    protected JTree users = null;
    protected JScrollPane usersTreeScrollPane = null;
    protected UserGroupTreeNode root = null;
    protected SortedTreeModel usersModel = null;
    protected TitledBorder titledBorder = null;
    protected boolean isEditable = false;
    protected Hashtable directUsers = new Hashtable();
    protected Hashtable directGroups = new Hashtable();
    protected Hashtable userTreePaths = new Hashtable();
    protected Hashtable groupTreePaths = new Hashtable();
    protected Hashtable groupNodes = new Hashtable();
    protected Hashtable clonedGroupNodes = new Hashtable();
    protected Hashtable clonedDirectUsers = new Hashtable();

    public UsersPanel(boolean isEditable) {
        this.isEditable = isEditable;
        try {
            this.init();
        }
        catch (Exception e) {
            ConnectorServiceFrame.logException(e);
        }
    }

    public UsersPanel() {
        this(false);
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        this.root = new UserGroupTreeNode("VIRTUAL_ROOT", false);
        this.usersModel = new SortedTreeModel(this.root);
        this.users = new JTree(this.usersModel);
        this.usersModel.fireTreeStructureChanged(this.usersModel, this.usersModel.getPathToRoot(this.root), null, null);
        TreeCellEditor cellEditor = null;
        if (this.isEditable) {
            this.users.setEditable(true);
            cellEditor = new TreeCellEditor();
            this.users.setCellEditor(cellEditor);
        } else {
            this.users.setEditable(false);
        }
        TreeCellRenderer renderer = new TreeCellRenderer(false, this.isEditable, false, false, "VIRTUAL_ROOT");
        this.users.setRowHeight((int)renderer.getPreferredSize().getHeight());
        this.users.setCellRenderer(renderer);
        this.usersTreeScrollPane = new JScrollPane(this.users, 20, 30);
        this.users.getSelectionModel().setSelectionMode(1);
        this.users.setRootVisible(true);
        this.titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), GuiSettings.getResourceString("Existing Users", "Existing Users"));
        this.setBorder(this.titledBorder);
        this.add((Component)this.usersTreeScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
    }

    public void clear() {
        this.users.clearSelection();
    }

    public void clearAll() {
        this.users.clearSelection();
        this.usersModel.removeAllChildrenFromParent((UserGroupTreeNode)this.usersModel.getRoot());
        this.directUsers.clear();
        this.directGroups.clear();
        this.userTreePaths.clear();
        this.groupTreePaths.clear();
        this.groupNodes.clear();
    }

    public void commitChange() {
    }

    public boolean isCorrect() {
        return true;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.users.addTreeSelectionListener(listener);
    }
}

