/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.UserGroupTreeNode;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SortedTreeModel
implements Serializable,
TreeModel {
    static final long serialVersionUID = 1720204392949479622L;
    protected UserGroupTreeNode emptyRoot = new UserGroupTreeNode("EMPTY_ROOT", false);
    protected UserGroupTreeNode notEmptyRoot = null;
    protected UserGroupTreeNode root = null;
    protected Vector listenerList = new Vector();

    public SortedTreeModel(UserGroupTreeNode root) {
        this.root = root;
        this.notEmptyRoot = root;
        this.fireTreeStructureChanged(this, this.getPathToRoot(root), null, null);
    }

    public void setRoot(UserGroupTreeNode root) {
        this.root = root;
        if (this.notEmptyRoot == null) {
            this.notEmptyRoot = root;
        }
        this.fireTreeStructureChanged(this, this.getPathToRoot(root), null, null);
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.setRoot(this.notEmptyRoot);
        } else {
            this.setRoot(this.emptyRoot);
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        return ((UserGroupTreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((UserGroupTreeNode)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return ((UserGroupTreeNode)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        UserGroupTreeNode aNode = (UserGroupTreeNode)path.getLastPathComponent();
        aNode.setUserObject(newValue);
        this.nodeChanged(aNode);
    }

    public void nodeChanged(TreeNode node) {
        if (this.listenerList != null && node != null) {
            TreeNode parent = node.getParent();
            if (parent != null) {
                int anIndex = parent.getIndex(node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void nodesChanged(TreeNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    int counter = 0;
                    while (counter < cCount) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                        ++counter;
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent e = null;
        int i = 0;
        while (i < this.listenerList.size()) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)this.listenerList.elementAt(i)).treeNodesChanged(e);
            ++i;
        }
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(l);
    }

    public void insertNodeInto(TreeNode newChild, TreeNode parent) {
        ((UserGroupTreeNode)parent).add((UserGroupTreeNode)newChild);
        int[] newIndexs = new int[]{parent.getIndex(newChild)};
        this.nodesWereInserted(parent, newIndexs);
    }

    public void removeNodeFromParent(UserGroupTreeNode node) {
        UserGroupTreeNode parent = (UserGroupTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    public void removeAllChildrenFromParent(UserGroupTreeNode parent) {
        int[] childIndex = new int[parent.getChildCount()];
        Object[] removedArray = new Object[parent.getChildCount()];
        int i = childIndex.length - 1;
        while (i >= 0) {
            childIndex[i] = i;
            removedArray[i] = parent.getChildAt(i);
            --i;
        }
        parent.removeAllChildren();
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            int counter = 0;
            while (counter < cCount) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
                this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
                ++counter;
            }
        }
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent e = null;
        int i = 0;
        while (i < this.listenerList.size()) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)this.listenerList.elementAt(i)).treeNodesInserted(e);
            ++i;
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent e = null;
        int i = 0;
        while (i < this.listenerList.size()) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)this.listenerList.elementAt(i)).treeStructureChanged(e);
            ++i;
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        int i = 0;
        while (i < this.listenerList.size()) {
            ((TreeModelListener)this.listenerList.elementAt(i)).treeStructureChanged(e);
            ++i;
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent e = null;
        int i = 0;
        while (i < this.listenerList.size()) {
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)this.listenerList.elementAt(i)).treeNodesRemoved(e);
            ++i;
        }
    }

    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }
}

