/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.AdditionalSettingsPanelLogical;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.AuthenticationPanelLogical;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.ConfigPropertiesPanelLogical;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.GeneralPanelLogical;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.GuiSettings;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.ObjectValues;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.PrincipalMappingPanelLogical;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SecurityPermissionsPanelLogical;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RarPanel
extends JPanel
implements ChangeListener,
ListSelectionListener {
    protected Frame mainFrame = null;
    protected JCDescriptor[] descrs = null;
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected JSplitPane mainSplitPane = new JSplitPane();
    protected TitledBorder titledBorder1 = null;
    protected GridBagLayout gridBagLayout2 = new GridBagLayout();
    protected JPanel connectorsPanel = new JPanel();
    protected JScrollPane connectorsScrollPane = new JScrollPane();
    protected JList connectorsList = new JList();
    protected SortedListModel connectorsModel = new SortedListModel();
    protected JTabbedPane mainTabPane = new JTabbedPane();
    protected GeneralPanelLogical generalPanel = new GeneralPanelLogical();
    protected ConfigPropertiesPanelLogical configPanel = new ConfigPropertiesPanelLogical();
    protected JTabbedPane securityTabPane = new JTabbedPane();
    protected AuthenticationPanelLogical authPanel = new AuthenticationPanelLogical();
    protected SecurityPermissionsPanelLogical securityPermPanel = new SecurityPermissionsPanelLogical();
    protected JTabbedPane identitiesTabPane = new JTabbedPane();
    protected PrincipalMappingPanelLogical principalMappingPanel = new PrincipalMappingPanelLogical();
    protected JTabbedPane additionalTabPane = new JTabbedPane();
    protected AdditionalSettingsPanelLogical addPanel = new AdditionalSettingsPanelLogical();
    private final String sep = File.separator;
    private final String tempDir = "." + this.sep + "temp";

    public RarPanel(Frame mainFrame, JCDescriptor[] descrs) {
        try {
            this.setFrame(mainFrame);
            this.setDescriptors(descrs);
            this.init();
        }
        catch (Exception ex) {
            ConnectorServiceFrame.logException(ex);
        }
    }

    public void setFrame(Frame frame) {
        this.mainFrame = this.mainFrame;
        this.generalPanel.setFrame(frame);
        this.configPanel.setFrame(frame);
        this.authPanel.setFrame(frame);
        this.securityPermPanel.setFrame(frame);
        this.principalMappingPanel.setFrame(frame);
        this.addPanel.setFrame(frame);
    }

    public void setDescriptors(JCDescriptor[] _descrs) {
        if (_descrs == null) {
            this.descrs = null;
            return;
        }
        this.descrs = new JCDescriptor[_descrs.length];
        int i = 0;
        while (i < _descrs.length) {
            this.descrs[i] = (JCDescriptor)_descrs[i].clone();
            this.connectorsModel.add(new ObjectValues(this.descrs[i], 0));
            ++i;
        }
    }

    private void init() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.titledBorder1 = BorderFactory.createTitledBorder(GuiSettings.getResourceString("Connectors", "Connectors"));
        this.connectorsScrollPane.setBorder(this.titledBorder1);
        this.connectorsList.getSelectionModel().setSelectionMode(0);
        this.connectorsList.setModel(this.connectorsModel);
        this.connectorsScrollPane.getViewport().add(this.connectorsList);
        this.connectorsPanel.setLayout(this.gridBagLayout2);
        this.connectorsPanel.add((Component)this.connectorsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.mainTabPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.generalPanel = new GeneralPanelLogical();
        this.configPanel = new ConfigPropertiesPanelLogical();
        this.securityTabPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.authPanel = new AuthenticationPanelLogical();
        this.securityPermPanel = new SecurityPermissionsPanelLogical();
        this.securityTabPane.add((Component)this.authPanel, GuiSettings.getResourceString("Auth Mechanisms", "Auth Mechanisms"));
        this.securityTabPane.add((Component)this.securityPermPanel, GuiSettings.getResourceString("Security Perms", "Security Perms"));
        this.principalMappingPanel = new PrincipalMappingPanelLogical();
        this.addPanel = new AdditionalSettingsPanelLogical();
        this.mainTabPane.add((Component)this.generalPanel, GuiSettings.getResourceString("MCF Properties", "MCF Properties"));
        this.mainTabPane.add((Component)this.configPanel, GuiSettings.getResourceString("CF Properties", "CF Properties"));
        this.mainTabPane.add((Component)this.securityTabPane, GuiSettings.getResourceString("Security", "Security"));
        this.mainTabPane.add((Component)this.principalMappingPanel, GuiSettings.getResourceString("Identity Subjects", "Identity Subjects"));
        this.mainTabPane.add((Component)this.addPanel, GuiSettings.getResourceString("Additional Settings", "Additional Settings"));
        this.mainSplitPane.setOrientation(1);
        this.mainSplitPane.setLeftComponent(this.connectorsPanel);
        this.mainSplitPane.setRightComponent(this.mainTabPane);
        this.mainSplitPane.setDividerLocation(150);
        this.add((Component)this.mainSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.initListeners();
    }

    private void initListeners() {
        this.connectorsList.addListSelectionListener(this);
        this.mainTabPane.addChangeListener(this);
        this.securityTabPane.addChangeListener(this);
    }

    public void valueChanged(ListSelectionEvent e) {
        ObjectValues value = (ObjectValues)this.connectorsList.getSelectedValue();
        JCDescriptor descr = null;
        if (value != null) {
            descr = value.getJCDescriptor();
        }
        this.generalPanel.setDescriptor(descr);
        this.configPanel.setConfigProperties(descr.getManagedFactoryProperty().getConfigProperties());
        try {
            this.principalMappingPanel.setDescriptor(descr);
        }
        catch (RemoteException re) {
            ConnectorServiceFrame.logException(re);
        }
    }

    public void stateChanged(ChangeEvent e) {
        System.out.println("STATE CHANGED");
    }

    public void clear() {
    }

    public boolean isCorrect() {
        return true;
    }

    public void commitChange() {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("myFrame");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        RarPanel gp = new RarPanel(frame, new JCDescriptor[]{new JCDescriptor()});
        frame.getContentPane().add((Component)gp, "Center");
        ((Component)frame).setSize(850, 650);
        ((Component)frame).setVisible(true);
    }
}

