/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.PropertyEditorView;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SortedTableModel;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class PropertyEditor
extends PropertyEditorView {
    protected Border border;
    protected SortedTableModel tableModel;
    protected DefaultListSelectionModel selectionModel;
    protected Properties props;
    protected ChangeListener listener;
    protected Frame mainFrame;

    public PropertyEditor() {
        this.initEditor("Key", "Value");
    }

    public PropertyEditor(String keyColumnName, String valueColumnName) {
        this.keyLabel.setText(keyColumnName + ":");
        this.valueLabel.setText(valueColumnName + ":");
        this.initEditor(keyColumnName, valueColumnName);
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    public void setEditorBorder(Border border) {
        this.border = border;
        this.setBorder(border);
    }

    private void initEditor(String keyColumnName, String valueColumnName) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(keyColumnName);
        names.add(valueColumnName);
        this.selectionModel = (DefaultListSelectionModel)this.table.getSelectionModel();
        this.tableModel = new SortedTableModel(this.table);
        this.table.setModel(this.tableModel);
        this.tableModel.setColumnNames(names);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.keyTextField.addKeyListener(this);
        this.valueTextField.addKeyListener(this);
        this.keyTextField.getDocument().addDocumentListener(this);
        this.valueTextField.getDocument().addDocumentListener(this);
    }

    public void setFrame(Frame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
        }
        if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
        }
        if (cmd.equals("MODIFY_CMD")) {
            this.modifyBtnAction();
        }
        if (cmd.equals("CLEAR_CMD")) {
            this.clearBtnAction();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent(e);
    }

    private void processDocumentEvent(DocumentEvent de) {
        String key = this.keyTextField.getText().trim();
        String value = this.valueTextField.getText().trim();
        int index = this.table.getSelectedRow();
        if (!key.equals("") || !value.equals("")) {
            this.clearButton.setEnabled(true);
        } else {
            this.clearButton.setEnabled(false);
        }
        if (index != -1) {
            if (!((String)((ArrayList)this.tableModel.getRows().get(index)).get(0)).equals(key) && !key.equals("")) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
            } else if (!((String)((ArrayList)this.tableModel.getRows().get(index)).get(1)).equals(value)) {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(false);
            }
        } else {
            if (key.equals("")) {
                this.addButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(true);
            }
            this.modifyButton.setEnabled(false);
        }
    }

    private void addBtnAction() {
        int index;
        if (this.keyTextField.getText().trim().length() == 0) {
            return;
        }
        ArrayList rows = this.tableModel.getRows();
        String key = this.keyTextField.getText().trim();
        String value = this.valueTextField.getText().trim();
        boolean changed = false;
        int i = 0;
        while (i < rows.size()) {
            ArrayList row = (ArrayList)rows.get(i);
            if (((String)row.get(0)).equals(key)) {
                changed = true;
                if (!((String)row.get(1)).equals(value)) {
                    int answer = -1;
                    answer = JOptionPane.showConfirmDialog(this.mainFrame, "Key <" + key + "> already exists.\n Would you like to save the changes and modify value for this key?", "Warning", 1, 2);
                    if (answer == 0) {
                        this.tableModel.setValueAt(value, i, 1);
                    } else if (answer == 2) {
                        this.addButton.setEnabled(false);
                        return;
                    }
                }
                index = this.tableModel.getRows().indexOf(row);
                this.selectionModel.setSelectionInterval(index, index);
                this.scrollToSelected(index);
            }
            ++i;
        }
        if (!changed) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(key);
            list.add(value);
            this.tableModel.addRow(list);
            index = this.tableModel.getRows().indexOf(list);
            this.selectionModel.setSelectionInterval(index, index);
            this.scrollToSelected(index);
        }
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.removeRow(selRow);
        if (selRow - 1 >= 0) {
            this.table.setRowSelectionInterval(selRow - 1, selRow - 1);
            this.scrollToSelected(selRow - 1);
        } else if (selRow < this.table.getRowCount()) {
            this.table.setRowSelectionInterval(selRow, selRow);
            this.scrollToSelected(selRow);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    private void modifyBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.tableModel.setValueAt(this.valueTextField.getText().trim(), selRow, 1);
        this.selectionModel.setSelectionInterval(selRow, selRow);
        this.scrollToSelected(selRow);
        this.table_valueChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
        this.modifyButton.setEnabled(false);
    }

    private void clearBtnAction() {
        if (this.table.getSelectedRow() != -1) {
            this.table.clearSelection();
        } else {
            this.table_valueChanged();
        }
    }

    private void scrollToSelected(int selectedRow) {
        Rectangle rec = this.table.getCellRect(selectedRow, 0, true);
        rec.y = selectedRow * rec.height;
        this.table.scrollRectToVisible(rec);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.selectionModel.clearSelection();
            this.keyTextField.setText("");
            this.valueTextField.setText("");
            this.removeButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.keyTextField.requestFocus();
            return;
        }
        this.removeButton.setEnabled(true);
        this.keyTextField.requestFocus();
        this.keyTextField.setText((String)this.tableModel.getValueAt(row, 0));
        this.valueTextField.setText((String)this.tableModel.getValueAt(row, 1));
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.addButton.doClick();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setProperties(Properties properties) {
        this.tableModel.clearAll();
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.table.getSelectionModel().clearSelection();
        if (properties == null) {
            return;
        }
        this.props = properties;
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            ArrayList<String> list = new ArrayList<String>();
            list.add(key);
            list.add(properties.getProperty(key));
            this.tableModel.addRow(list);
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            properties.setProperty((String)this.tableModel.getValueAt(i, 0), (String)this.tableModel.getValueAt(i, 1));
            ++i;
        }
        return properties;
    }

    public boolean isChanged() {
        Properties properties = this.getProperties();
        if (this.props == null && properties == null) {
            return false;
        }
        if (this.props == null || properties == null || ((Hashtable)this.props).size() != ((Hashtable)properties).size()) {
            return true;
        }
        return !((Hashtable)this.props).equals(properties);
    }
}

