/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.GuiSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public abstract class PrincipalsPanel
extends JPanel {
    protected JTree principals = null;
    protected JScrollPane principalsScrollPane = null;
    protected DefaultMutableTreeNode root = null;
    protected DefaultTreeModel principalsModel = null;
    protected Border titledBorder = null;

    public PrincipalsPanel() {
        try {
            this.init();
        }
        catch (Exception e) {
            ConnectorServiceFrame.logException(e);
        }
    }

    public PrincipalsPanel(String[] groups, String[][] users) {
        this();
        this.setUsers(groups, users);
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        this.principals = new JTree();
        this.principalsScrollPane = new JScrollPane(this.principals, 20, 30);
        this.principals.getSelectionModel().setSelectionMode(1);
        this.principalsModel = (DefaultTreeModel)this.principals.getModel();
        this.root = new DefaultMutableTreeNode("root");
        this.principalsModel.setRoot(this.root);
        this.add((Component)this.principalsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    public void setTitle(String title) {
        this.titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), GuiSettings.getResourceString(title, title));
        this.setBorder(this.titledBorder);
    }

    public void clear() {
        this.principals.removeAll();
    }

    public void commitChange() {
    }

    public boolean isCorrect() {
        return true;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.principals.addTreeSelectionListener(listener);
    }

    protected abstract void setUsers(String[] var1, String[][] var2);
}

