/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.impl0.SortedListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NameSpacePanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String EDIT_CMD = "EDIT_CMD";
    JScrollPane jScrollPane1 = new JScrollPane();
    JList theList = new JList();
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JButton editButton = new JButton();
    Border border1 = new EtchedBorder(1, Color.white, new Color(134, 134, 134));
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    String title = "Aliases";
    String newText = "Enter new alias:";
    String editText = "Edit current alias:";
    Frame frame = null;
    SortedListModel componentsVector = new SortedListModel();
    protected ChangeListener listener;

    public NameSpacePanel() {
        try {
            this.init();
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
        }
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        this.addButton.setMaximumSize(this.addButton.getPreferredSize());
        this.addButton.setText("Add");
        this.addButton.setActionCommand(ADD_CMD);
        this.addButton.addActionListener(this);
        this.removeButton.setText("Remove");
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.editButton.setText("Edit");
        this.editButton.setActionCommand(EDIT_CMD);
        this.editButton.addActionListener(this);
        this.editButton.setEnabled(false);
        this.titledBorder1 = new TitledBorder(this.border1, this.title);
        this.titledBorder2 = BorderFactory.createTitledBorder("Name Space");
        this.setBorder(this.titledBorder2);
        this.jScrollPane1.setBorder(this.titledBorder1);
        JLabel jndiNameLabel = new JLabel("JNDI Name:");
        JTextField jndiNameField = new JTextField();
        this.add((Component)jndiNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 8, 0, 5), 0, 0));
        this.add((Component)jndiNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 7), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 2, 5, 1.0, 1.0, 10, 1, new Insets(3, 5, 8, 5), 0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.2, 12, 2, new Insets(3, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.removeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.2, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.editButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.2, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(2, 1, 1, 4, 0.0, 0.1, 10, 1, new Insets(8, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.theList, null);
        this.theList.addListSelectionListener(this);
        this.theList.setSelectionMode(0);
        this.theList.setModel(this.componentsVector);
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setEnabled(boolean flag) {
        this.addButton.setEnabled(flag);
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.theList.setEnabled(flag);
    }

    public void initList(String[] names) {
        this.componentsVector.clear();
        int i = 0;
        while (i < names.length) {
            this.componentsVector.add(names[i]);
            ++i;
        }
    }

    public String[] getListDataArray() {
        return (String[])this.componentsVector.toArray(new String[this.componentsVector.size()]);
    }

    public ArrayList getListData() {
        return this.componentsVector.getData();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(ADD_CMD)) {
            this.addButtonAction();
        } else if (cmd.equals(REMOVE_CMD)) {
            this.removeButtonAction();
        } else if (cmd.equals(EDIT_CMD)) {
            this.editButtonAction();
        }
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    private void addButtonAction() {
        String component = JOptionPane.showInputDialog(this.frame, this.newText, "Enter a name for new component", -1);
        if (component == null) {
            return;
        }
        if ((component = component.trim()).length() == 0) {
            return;
        }
        this.componentsVector.addUnique(component);
        int index = this.componentsVector.getData().indexOf(component);
        this.theList.setSelectedIndex(index);
        this.scrollToSelected(index);
    }

    private void removeButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            this.componentsVector.remove(index);
            if (index - 1 >= 0) {
                this.theList.setSelectedIndex(index - 1);
                this.scrollToSelected(index - 1);
            } else if (index < this.componentsVector.getData().size()) {
                this.theList.setSelectedIndex(index);
                this.scrollToSelected(index);
            }
        }
    }

    private void editButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            JOptionPane pane = new JOptionPane();
            String value = (String)this.componentsVector.get(index);
            String name = (String)JOptionPane.showInputDialog(this.frame, this.editText, "Edit the name of the component", -1, null, null, value);
            if (name == null) {
                return;
            }
            if ((name = name.trim()).length() == 0) {
                return;
            }
            this.componentsVector.remove(index);
            this.componentsVector.addUnique(name);
            index = this.componentsVector.getData().indexOf(name);
            this.theList.setSelectedIndex(index);
            this.scrollToSelected(index);
        }
    }

    private void scrollToSelected(int selectedIndex) {
        Rectangle rec = this.theList.getCellBounds(0, 0);
        rec.y = selectedIndex * rec.height;
        this.theList.scrollRectToVisible(rec);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.theList.isSelectionEmpty()) {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }
}

