/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.services.connector.jca.deploy.descriptor.gui.SortedListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleListPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    JScrollPane jScrollPane1 = new JScrollPane();
    JList theList = new JList();
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JButton editButton = new JButton();
    Border border1 = new EtchedBorder(1, Color.white, new Color(134, 134, 134));
    TitledBorder titledBorder1;
    String title = "Title";
    String newText = "Enter name:";
    String editText = "Edit name:";
    Frame frame = null;
    SortedListModel componentsVector = new SortedListModel();
    protected ChangeListener listener;

    public SimpleListPanel() {
        this.init();
    }

    public SimpleListPanel(String title, String newText, String editText) {
        this.title = title;
        this.newText = newText;
        this.editText = editText;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.addButton.setText("Add");
        this.addButton.addActionListener(this);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        this.editButton.setText("Edit");
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(this);
        this.titledBorder1 = new TitledBorder(this.border1, this.title);
        this.jScrollPane1.setBorder(this.titledBorder1);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 3, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 5, 5), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.theList, null);
        this.theList.addListSelectionListener(this);
        this.theList.setSelectionMode(0);
        this.theList.setModel(this.componentsVector);
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void initList(String[] names) {
        this.componentsVector.clear();
        int i = 0;
        while (i < names.length) {
            this.componentsVector.add(names[i]);
            ++i;
        }
    }

    public String[] getListDataArray() {
        return (String[])this.componentsVector.toArray(new String[this.componentsVector.size()]);
    }

    public ArrayList getListData() {
        return this.componentsVector.getData();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addButtonAction();
        } else if (e.getSource() == this.removeButton) {
            this.removeButtonAction();
        } else if (e.getSource() == this.editButton) {
            this.editButtonAction();
        }
        this.valueChanged(null);
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    private void addButtonAction() {
        String component = JOptionPane.showInputDialog(this.frame, this.newText, "Enter a name for new component", -1);
        if (component == null) {
            return;
        }
        if ((component = component.trim()).length() == 0) {
            return;
        }
        this.componentsVector.addUnique(component);
    }

    private void removeButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            this.componentsVector.remove(index);
        }
    }

    public void editButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            String value = (String)this.componentsVector.get(index);
            String name = (String)JOptionPane.showInputDialog(this.frame, this.editText, "Edit the name of the component", -1, null, null, value);
            if (name == null) {
                return;
            }
            if ((name = name.trim()).length() == 0) {
                return;
            }
            this.componentsVector.remove(index);
            this.componentsVector.addUnique(name);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.theList.isSelectionEmpty()) {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    public void setListRenderer(ListCellRenderer renderer) {
        this.theList.setCellRenderer(renderer);
    }
}

