/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.DefineUsersPanel;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.additional.ListRenderer;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;

public abstract class PrincipalMappingPanel
extends BasicPanelView
implements ActionListener,
ListSelectionListener,
TreeSelectionListener,
DocumentListener {
    public static final String SELECT_CMD = "SELECT_CMD";
    public static final String DESELECT_CMD = "DESELECT_CMD";
    public static final int NAME = 1;
    public static final int PASSWORD = 2;
    public static final int CALLERS = 4;
    protected DefaultListModel model = new DefaultListModel();
    private ListRenderer renderer = new ListRenderer();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected JPanel resourcePanel = new JPanel();
    protected JLabel userLabel = new JLabel();
    protected JTextField userTextField = new JTextField();
    protected JLabel passwordLabel = new JLabel();
    protected JPasswordField passwordField = new JPasswordField();
    protected JPanel mappingPanel = new JPanel();
    protected GridBagLayout gridBagLayout2 = new GridBagLayout();
    protected JPanel selectedPanel = new JPanel();
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected Border etchedBorder = BorderFactory.createEtchedBorder();
    protected TitledBorder titledBorder = BorderFactory.createTitledBorder(this.etchedBorder, "Caller Principals");
    protected JScrollPane scrollPane = new JScrollPane();
    protected JList usersList = new JList(this.model);
    protected JPanel buttonsPanel = new JPanel();
    protected GridBagLayout gridBagLayout3 = new GridBagLayout();
    protected JButton selectButton = new JButton();
    protected JButton deselectButton = new JButton();
    protected JPanel principalsPanel = new JPanel();
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected UserTreePanel availablePanel = new UserTreePanel();
    protected DefineUsersPanel definePanel = new DefineUsersPanel();
    private Vector listeners = new Vector();

    public PrincipalMappingPanel() {
        try {
            this.init();
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
        }
    }

    private void init() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.resourcePanel.setLayout(new GridBagLayout());
        this.resourcePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Resource Principal"));
        this.userLabel.setText("Principal Name:");
        this.passwordLabel.setText("Principal Password:");
        this.resourcePanel.add((Component)this.userLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.resourcePanel.add((Component)this.userTextField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.resourcePanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.resourcePanel.add((Component)this.passwordField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mappingPanel.setLayout(this.gridBagLayout2);
        this.selectedPanel.setLayout(this.borderLayout1);
        this.selectedPanel.setBorder(this.titledBorder);
        this.selectedPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.usersList, null);
        this.usersList.setSelectionMode(0);
        this.usersList.setCellRenderer(this.renderer);
        this.buttonsPanel.setLayout(this.gridBagLayout3);
        this.selectButton.setText("<<");
        this.deselectButton.setText(">>");
        this.principalsPanel.setLayout(new BorderLayout());
        this.principalsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Principals On Server"));
        this.principalsPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.add((Component)this.availablePanel, "Existing Users");
        this.tabbedPane.add((Component)this.definePanel, "Define Users");
        this.tabbedPane.setEnabledAt(0, false);
        this.tabbedPane.setSelectedIndex(1);
        this.add((Component)this.resourcePanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.mappingPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mappingPanel.add((Component)this.selectedPanel, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mappingPanel.add((Component)this.buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.1, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.mappingPanel.add((Component)this.principalsPanel, new GridBagConstraints(2, 0, 1, 1, 0.2, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.selectButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.deselectButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.initListeners();
        this.clearFields();
    }

    protected void clearFields() {
        this.userTextField.setText("");
        ((JTextComponent)this.passwordField).setText("");
        this.model.clear();
        this.selectButton.setEnabled(false);
        this.deselectButton.setEnabled(false);
        this.definePanel.clear();
        this.availablePanel.clearSelection();
    }

    private void initListeners() {
        this.selectButton.setActionCommand(SELECT_CMD);
        this.deselectButton.setActionCommand(DESELECT_CMD);
        this.selectButton.addActionListener(this);
        this.deselectButton.addActionListener(this);
        this.usersList.addListSelectionListener(this);
        this.availablePanel.addTreeSelectionListener((TreeSelectionListener)this);
        this.availablePanel.addListSelectionListener((ListSelectionListener)this);
        this.userTextField.getDocument().addDocumentListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
        this.definePanel.addDocumentListener(this);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners.add(documentListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    protected void fireActionPerformed(ActionEvent e) {
        ActionListener temp = null;
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.elementAt(i) instanceof ActionListener) {
                temp = (ActionListener)this.listeners.elementAt(i);
                temp.actionPerformed(e);
            }
            ++i;
        }
    }

    protected void fireInsertUpdate(DocumentEvent e) {
        DocumentListener temp = null;
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.elementAt(i) instanceof DocumentListener) {
                temp = (DocumentListener)this.listeners.elementAt(i);
                temp.insertUpdate(e);
            }
            ++i;
        }
    }

    protected void fireChangedUpdate(DocumentEvent e) {
        DocumentListener temp = null;
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.elementAt(i) instanceof DocumentListener) {
                temp = (DocumentListener)this.listeners.elementAt(i);
                temp.changedUpdate(e);
            }
            ++i;
        }
    }

    protected void fireRemoveUpdate(DocumentEvent e) {
        DocumentListener temp = null;
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.elementAt(i) instanceof DocumentListener) {
                temp = (DocumentListener)this.listeners.elementAt(i);
                temp.removeUpdate(e);
            }
            ++i;
        }
    }

    protected void setEnabled(int level) {
        if ((level & 1) != 1) {
            this.userTextField.setText("");
        }
        this.userTextField.setEnabled((level & 1) == 1);
        if ((level & 2) != 2) {
            ((JTextComponent)this.passwordField).setText("");
        }
        this.passwordField.setEnabled((level & 2) == 2);
        if ((level & 4) != 4) {
            this.model.clear();
        }
        this.availablePanel.setEnabled((level & 4) == 4);
        this.definePanel.setEnabled((level & 4) == 4);
    }

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void valueChanged(ListSelectionEvent var1);

    public abstract void valueChanged(TreeSelectionEvent var1);

    public abstract void changedUpdate(DocumentEvent var1);

    public abstract void removeUpdate(DocumentEvent var1);

    public abstract void insertUpdate(DocumentEvent var1);
}

