/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.services.connector.jca.deploy.descriptor.AuthMechanism;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.SecurityPermissionWrapper;

public class ListValues {
    public static final byte SEC_PERMISSION = 0;
    public static final byte AUTH_MECHANISM = 1;
    public static final byte CONFIG_PROPERTY = 2;
    public static final byte IDENTITY_SUBJECT = 3;
    private String name = null;
    private byte type = (byte)-1;
    private SecurityPermissionWrapper secPerm = null;
    private AuthMechanism authMech = null;
    private ConfigProperty configProp = null;
    private IdentitySubject identSubject = null;

    public ListValues(SecurityPermissionWrapper permission, byte _type) {
        this.secPerm = permission;
        this.type = _type;
        this.name = this.secPerm != null && this.secPerm.getName() != null ? this.secPerm.getName() : "Unknown Security Permission";
    }

    public ListValues(AuthMechanism auth, byte _type) {
        this.authMech = auth;
        this.type = _type;
        this.name = this.authMech != null && this.authMech.getAuthMechType() != null ? this.authMech.getAuthMechType() : "Unknown Authentication Mechanism";
    }

    public ListValues(ConfigProperty prop, byte _type) {
        this.configProp = prop;
        this.type = _type;
        this.name = this.configProp != null && this.configProp.getConfigPropertyName() != null ? this.configProp.getConfigPropertyName() : "Unknown Config Property";
    }

    public ListValues(IdentitySubject ident, byte _type) {
        this.identSubject = ident;
        this.type = _type;
        this.name = this.identSubject != null && this.identSubject.getResourcePrincipal() != null && this.identSubject.getResourcePrincipal().getUserName() != null ? this.identSubject.getResourcePrincipal().getUserName() : "Unknown Identity Subject";
    }

    public void setIdentitySubject(IdentitySubject ident) {
        this.identSubject = ident;
    }

    public SecurityPermissionWrapper getSecurityPermission() {
        return this.secPerm;
    }

    public AuthMechanism getAuthMechanism() {
        return this.authMech;
    }

    public ConfigProperty getConfigProperty() {
        return this.configProp;
    }

    public IdentitySubject getIdentitySubject() {
        return this.identSubject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public void changeIndex(int index) {
        if (index < 1 || this.name == null) {
            return;
        }
        if (this.type != 0) {
            return;
        }
        this.name = "permission_" + index;
        this.secPerm.changeIndex(index);
    }

    public byte getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }
}

