/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.connector.jca.deploy.descriptor.AuthMechanism;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.AuthenticationPanel;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.ListValues;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class AuthenticationPanelLogical
extends AuthenticationPanel
implements MadeFromConstants {
    private AuthMechanism[] auths = null;
    private boolean reauth = false;
    private int lastSelected = -1;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;

    public AuthenticationPanelLogical(Frame mainFrame, int madeFromConstant) {
        this.setFrame(mainFrame);
        this.madeFrom = madeFromConstant;
        this.init(this.madeFrom);
    }

    private void initList(AuthMechanism[] values) {
        this.model.clear();
        this.lastSelected = -1;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if (values[i] != null && values[i].getAuthMechType() != null && !values[i].getAuthMechType().equals("")) {
                    if (values[i].getAuthMechType().equals("BasicPassword")) {
                        values[i].setCredentialInterface("javax.resource.spi.security.PasswordCredential");
                    } else if (values[i].getAuthMechType().equals("Kerbv5")) {
                        values[i].setCredentialInterface("javax.resource.spi.security.GenericCredential");
                    }
                    this.model.addElement(new ListValues(values[i], 1));
                }
                ++i;
            }
        }
    }

    private void addAuth(String type, String interf, String descr) {
        if (type == null || type.equals("")) {
            return;
        }
        ListValues value = null;
        AuthMechanism auth = null;
        AuthMechanism temp = new AuthMechanism(type, interf, descr);
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            value = (ListValues)en.nextElement();
            auth = value.getAuthMechanism();
            if (!type.equals(auth.getAuthMechType())) continue;
            if (this.compareAuths(temp, auth)) {
                return;
            }
            if (interf != null) {
                if (!interf.equals(auth.getCredentialInterface())) {
                    changed = true;
                }
            } else if (auth.getCredentialInterface() != null && !auth.getCredentialInterface().equals("")) {
                changed = true;
            }
            if (descr != null) {
                if (descr.equals(auth.getDescription())) break;
                changed = true;
                break;
            }
            if (auth.getDescription() == null || auth.getDescription().equals("")) break;
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Authentication Mechanism <" + type + "> already exists.\n Would you like to save the changes and modify this Authentication Mechanism?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyAuth(value, interf, descr);
            }
            this.clearFields();
            return;
        }
        this.model.addElement(new ListValues(temp, 1));
    }

    private boolean compareAuths(AuthMechanism auth1, AuthMechanism auth2) {
        if (auth1 == auth2) {
            return true;
        }
        if (!auth1.getAuthMechType().equals(auth2.getAuthMechType())) {
            return false;
        }
        if (!auth1.getCredentialInterface().equals(auth2.getCredentialInterface())) {
            return false;
        }
        return !(auth1.getDescription() != null ? (auth2.getDescription() != null ? !auth1.getDescription().equals(auth2.getDescription()) : !auth1.getDescription().equals("")) : auth2.getDescription() != null && !auth2.getDescription().equals(""));
    }

    private void modifyAuth(ListValues auth, String interf, String descr) {
        if (auth == null) {
            return;
        }
        if (interf == null || interf.equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Can not modify Authentication Mechanism because Credential Interface is not specified.", "Warning", 2);
            return;
        }
        auth.getAuthMechanism().setCredentialInterface(interf);
        auth.getAuthMechanism().setDescription(descr);
    }

    private void removeAuth(ListValues auth) {
        if (auth == null) {
            return;
        }
        this.authList.clearSelection();
        this.clearFields();
        this.model.removeElement(auth);
    }

    public void setReauthSupport(boolean reauthSupport) {
        this.reauth = reauthSupport;
        this.reauthCheckBox.setSelected(reauthSupport);
    }

    public boolean getReauthSupport() {
        return this.reauth;
    }

    public void setAuthMechanisms(AuthMechanism[] mech) {
        this.auths = mech;
        this.clearFields();
        this.initList(this.auths);
    }

    public AuthMechanism[] getAuthMechanisms() {
        return this.auths;
    }

    private void showAuth(ListValues auth) {
        if (auth == null || auth.getAuthMechanism() == null || auth.getAuthMechanism().getAuthMechType() == null || auth.getAuthMechanism().getAuthMechType().equals("") || auth.getAuthMechanism().getCredentialInterface() == null || auth.getAuthMechanism().getCredentialInterface().equals("")) {
            return;
        }
        AuthMechanism authMech = auth.getAuthMechanism();
        this.typeComboBox.setSelectedItem(authMech.getAuthMechType());
        this.interfaceComboBox.setSelectedItem(authMech.getCredentialInterface());
        if (authMech.getDescription() == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(authMech.getDescription());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (!this.model.isEmpty()) {
            this.checkPanel();
            this.clearFields();
            if (!this.authList.isSelectionEmpty()) {
                selected = this.authList.getSelectedIndex();
                this.showAuth((ListValues)this.model.get(selected));
                if (this.madeFrom == 1 || this.madeFrom == 0) {
                    this.modifyButton.setEnabled(true);
                    this.removeButton.setEnabled(true);
                }
            }
            this.lastSelected = selected;
        }
    }

    private void checkPanel() {
        String type = null;
        String interf = null;
        String descr = null;
        if (!((String)this.typeComboBox.getSelectedItem()).trim().equals("")) {
            type = ((String)this.typeComboBox.getSelectedItem()).trim();
        }
        if (!((String)this.interfaceComboBox.getSelectedItem()).trim().equals("")) {
            interf = ((String)this.interfaceComboBox.getSelectedItem()).trim();
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            descr = this.descrPanel.getText().trim();
        }
        if (type == null || interf == null) {
            return;
        }
        ListValues value = null;
        AuthMechanism auth = null;
        AuthMechanism temp = new AuthMechanism(type, interf, descr);
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            value = (ListValues)en.nextElement();
            auth = value.getAuthMechanism();
            if (!type.equals(auth.getAuthMechType())) continue;
            if (this.compareAuths(temp, auth)) {
                return;
            }
            if (!interf.equals(auth.getCredentialInterface())) {
                changed = true;
            }
            if (descr != null) {
                if (descr.equals(auth.getDescription())) break;
                changed = true;
                break;
            }
            if (auth.getDescription() == null || auth.getDescription().equals("")) break;
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Credential Interface or Description of Authentication Mechanism <" + type + "> was changed.\n Would you like to save the changes and modify this Authentication Mechanism?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyAuth(value, interf, descr);
            }
            this.clearFields();
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Authentication Mechanism?", "Warning", 0, 2);
        if (answer == 0) {
            this.addAuth(type, interf, descr);
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String type = (String)this.typeComboBox.getSelectedItem();
        String interf = (String)this.interfaceComboBox.getSelectedItem();
        String descr = this.descrPanel.getText().trim();
        int typeIndex = this.typeComboBox.getSelectedIndex();
        int interfIndex = this.interfaceComboBox.getSelectedIndex();
        if (cmd.equals("comboBoxChanged")) {
            Object src = e.getSource();
            if (src.equals(this.typeComboBox)) {
                this.interfaceComboBox.setSelectedIndex(typeIndex);
            } else if (src.equals(this.interfaceComboBox)) {
                this.typeComboBox.setSelectedIndex(interfIndex);
            }
            typeIndex = this.typeComboBox.getSelectedIndex();
            if (typeIndex > 0) {
                if (this.madeFrom == 1 || this.madeFrom == 0) {
                    this.addButton.setEnabled(true);
                }
                this.clearButton.setEnabled(true);
            } else {
                this.addButton.setEnabled(false);
                if (descr.equals("") && this.authList.isSelectionEmpty()) {
                    this.clearButton.setEnabled(false);
                }
            }
        } else if (cmd.equals("ADD_CMD")) {
            this.addAuth(type, interf, descr);
            this.authList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyAuth((ListValues)this.authList.getSelectedValue(), interf, descr);
            this.authList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeAuth((ListValues)this.authList.getSelectedValue());
            this.clearFields();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.authList.clearSelection();
            this.clearFields();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    private void processDocumentEvent() {
        if (!this.descrPanel.getText().trim().equals("")) {
            this.clearButton.setEnabled(true);
        } else if ((this.typeComboBox.getSelectedItem() == null || this.typeComboBox.getSelectedItem().equals("")) && this.authList.isSelectionEmpty()) {
            this.clearButton.setEnabled(false);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        if (this.madeFrom == 0 || this.madeFrom == 1) {
            this.typeComboBox.setEnabled(true);
            this.interfaceComboBox.setEnabled(true);
            this.descrPanel.setEnabled(true);
            this.reauthCheckBox.setEnabled(true);
        } else {
            this.typeComboBox.setEnabled(false);
            this.interfaceComboBox.setEnabled(false);
            this.descrPanel.setEnabled(false);
            this.reauthCheckBox.setEnabled(false);
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.auths = new AuthMechanism[this.model.size()];
        int i = 0;
        while (i < this.model.size()) {
            this.auths[i] = ((ListValues)this.model.get(i)).getAuthMechanism();
            ++i;
        }
        this.reauth = this.reauthCheckBox.isSelected();
    }

    public void clear() {
        this.model.clear();
        this.auths = null;
        this.setReauthSupport(false);
        this.clearFields();
    }

    public void setLoader(ClassLoader loader) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

