/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor;

import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.jca.deploy.descriptor.CallerPrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResourcePrincipal;
import java.io.Serializable;
import java.util.Vector;

public class IdentitySubject
implements Serializable {
    static final long serialVersionUID = 1628355163204523360L;
    private ResourcePrincipal resourcePrincipal;
    private CallerPrincipal callerPrincipal;
    private Vector warnings;

    public IdentitySubject() {
    }

    public IdentitySubject(ResourcePrincipal resourcePrincipal, CallerPrincipal callerPrincipal) {
        this.resourcePrincipal = resourcePrincipal;
        this.callerPrincipal = callerPrincipal;
    }

    public void setCallerPrincipal(CallerPrincipal caller) {
        if (caller != null && (caller.getGroups() != null || caller.getUserNames() != null)) {
            this.callerPrincipal = caller;
        } else {
            if (this.warnings != null) {
                this.warnings.add("Warning : trying to set invalid or null caller principal");
            }
            ConnectorResourceAccessor.location.logT(300, "Warning : trying to set invalid or null caller principal");
        }
    }

    public CallerPrincipal getCallerPrincipal() {
        return this.callerPrincipal;
    }

    public void setResourcePrincipal(ResourcePrincipal resourcePrincipal) {
        if (resourcePrincipal == null || resourcePrincipal.getUserName() == null) {
            if (this.warnings != null) {
                this.warnings.add("Warning : trying to add invalid or null resource principal.");
            }
            ConnectorResourceAccessor.location.logT(300, "Warning : trying to add invalid or null resource principal.");
            return;
        }
        this.resourcePrincipal = resourcePrincipal;
    }

    public ResourcePrincipal getResourcePrincipal() {
        return this.resourcePrincipal;
    }

    public void setWarnings(Vector warnings) {
        this.warnings = warnings;
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public Object clone() {
        IdentitySubject cloning = new IdentitySubject();
        if (this.resourcePrincipal != null) {
            cloning.resourcePrincipal = (ResourcePrincipal)this.resourcePrincipal.clone();
        }
        if (this.callerPrincipal != null) {
            cloning.callerPrincipal = (CallerPrincipal)this.callerPrincipal.clone();
        }
        return cloning;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IdentitySubject)) {
            return false;
        }
        CallerPrincipal otherCallerPrincipal = ((IdentitySubject)object).callerPrincipal;
        if (this.callerPrincipal != null ? !this.callerPrincipal.equals(otherCallerPrincipal) : otherCallerPrincipal != null) {
            return false;
        }
        ResourcePrincipal otherResourcePrincipal = ((IdentitySubject)object).resourcePrincipal;
        return !(this.resourcePrincipal != null ? !this.resourcePrincipal.equals(otherResourcePrincipal) : otherResourcePrincipal != null);
    }
}

