/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class DriverInfo
implements Serializable {
    static final long serialVersionUID = -1423228431587913611L;
    private String driverClassName;
    private HashSet jars;
    private String driverName;
    private Vector warnings = null;

    public void setDriverName(String driverName) {
        this.driverName = driverName;
        if (driverName == null && this.warnings != null) {
            this.warnings.add("Warning : trying to set null driver name.");
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverClassName(String driverClassName) {
        if (driverClassName != null) {
            this.driverClassName = driverClassName;
        } else if (this.warnings != null) {
            this.warnings.add("Warning : trying to add null driver class name.");
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void addJar(String jar) {
        if (jar != null) {
            if (this.jars == null) {
                this.jars = new HashSet();
            }
            this.jars.add(jar);
        } else if (this.warnings != null) {
            this.warnings.add("Warning : trying to add null jar name.");
        }
    }

    public void removeJar(String jar) {
        if (this.jars != null && jar != null) {
            this.jars.remove(jar);
            if (this.jars.size() == 0) {
                this.jars = null;
            }
        }
    }

    public void setJars(HashSet jars) {
        this.jars = jars;
    }

    public HashSet getJars() {
        return this.jars;
    }

    public void setWarnings(Vector warnings) {
        this.warnings = warnings;
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public Object clone() {
        DriverInfo cloning = new DriverInfo();
        if (this.driverName != null) {
            cloning.driverName = new String(this.driverName);
        }
        if (this.driverClassName != null) {
            cloning.driverClassName = new String(this.driverClassName);
        }
        if (this.jars != null) {
            HashSet<String> newJars = new HashSet<String>();
            Iterator iterator = this.jars.iterator();
            while (iterator.hasNext()) {
                newJars.add(new String((String)iterator.next()));
            }
            cloning.jars = newJars;
        }
        return cloning;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DriverInfo)) {
            return false;
        }
        String otherDriverName = ((DriverInfo)object).driverName;
        if (this.driverName == null && otherDriverName != null || this.driverName != null && otherDriverName == null) {
            return false;
        }
        if (this.driverName != null && !this.driverName.equals(otherDriverName)) {
            return false;
        }
        String otherDriverClassName = ((DriverInfo)object).driverClassName;
        if (this.driverClassName == null && otherDriverClassName != null || this.driverClassName != null && otherDriverClassName == null) {
            return false;
        }
        if (this.driverClassName != null && !this.driverClassName.equals(otherDriverClassName)) {
            return false;
        }
        HashSet otherJars = ((DriverInfo)object).jars;
        if (this.jars == null && otherJars != null || this.jars != null && otherJars == null) {
            return false;
        }
        return this.jars == null || this.jars.equals(otherJars);
    }

    public String toString() {
        return this.driverName;
    }
}

