/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor;

import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;

public class AuthMechanism
implements Serializable {
    static final long serialVersionUID = -2201844578870932710L;
    public static final String BASIC_PASSWORD = "BasicPassword";
    public static final String KERBV_5 = "Kerbv5";
    private static final String SAP_ASSERTION_TICKET_OID = "1.3.6.1.4.1.694.2.1.3.1";
    private static final String SAP_ASSERTION_TICKET_NAME = "SAPAssertionTicket";
    public static final String PASSWORD_CREDENTIAL = "javax.resource.spi.security.PasswordCredential";
    public static final String GENERIC_CREDENTIAL = "javax.resource.spi.security.GenericCredential";
    public static final String GSS_CREDENTIAL = "org.ietf.jgss.GSSCredential";
    private String description = null;
    private String authMechType = null;
    private String credentialInterface = null;
    private Vector warnings = null;
    private static Vector sapAssertionTicketNames = null;
    public static final HashSet SAP_ASSERTION_TICKET_SET;

    public AuthMechanism() {
    }

    public AuthMechanism(String type, String interf, String descr) {
        this.setAuthMechType(type);
        this.setCredentialInterface(interf);
        this.setDescription(descr);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthMechType() {
        return this.authMechType;
    }

    public void setAuthMechType(String type) throws IllegalArgumentException {
        if (type == null || !type.equals(BASIC_PASSWORD) && !type.equals(KERBV_5) && !SAP_ASSERTION_TICKET_SET.contains(type)) {
            if (this.warnings != null) {
                this.warnings.add("Warning : value for authentication-mechanism-type not from type BasicPassword, Kerbv5, SAPAssertionTicket or 1.3.6.1.4.1.694.2.1.3.1");
            }
            ConnectorResourceAccessor.location.logT(300, "Warning : value for authentication-mechanism-type not from type BasicPassword, Kerbv5, SAPAssertionTicket or 1.3.6.1.4.1.694.2.1.3.1");
        }
        if (type != null) {
            if (SAP_ASSERTION_TICKET_SET.contains(type)) {
                if (this.credentialInterface != null && !this.credentialInterface.equals(GENERIC_CREDENTIAL)) {
                    throw new BaseIllegalArgumentException("connector_0303", new String[]{"credential-interface", GENERIC_CREDENTIAL});
                }
                this.credentialInterface = GENERIC_CREDENTIAL;
            } else if (this.credentialInterface != null) {
                if (!this.credentialInterface.equals(PASSWORD_CREDENTIAL)) {
                    if (this.warnings != null) {
                        this.warnings.add("Warning : value specified for credential-interface is not from type javax.resource.spi.security.PasswordCredential and will be ignored.");
                    }
                    ConnectorResourceAccessor.location.logT(300, "Warning : value specified for credential-interface is not from type javax.resource.spi.security.PasswordCredential and will be ignored.");
                }
            } else {
                this.credentialInterface = PASSWORD_CREDENTIAL;
            }
            this.authMechType = type;
        } else {
            if (this.warnings != null) {
                this.warnings.add("Warning : trying to add null authentication mechanism type");
            }
            ConnectorResourceAccessor.location.logT(300, "Warning : trying to add null authentication mechanism type");
        }
    }

    public void setCredentialInterface(String credential) throws IllegalArgumentException {
        if (credential == null || !credential.equals(PASSWORD_CREDENTIAL) && !credential.equals(GENERIC_CREDENTIAL) && !credential.equals(GSS_CREDENTIAL)) {
            if (this.warnings != null) {
                this.warnings.add("Warning : incorect value for credential-interface. Value must be javax.resource.spi.security.PasswordCredential or javax.resource.spi.security.GenericCredential.");
            }
            ConnectorResourceAccessor.location.logT(300, "Warning : incorect value for credential-interface. Value must be javax.resource.spi.security.PasswordCredential or javax.resource.spi.security.GenericCredential.");
        }
        if (credential != null) {
            if (credential.equals(GENERIC_CREDENTIAL)) {
                if (this.authMechType != null && !SAP_ASSERTION_TICKET_SET.contains(this.authMechType)) {
                    if (this.warnings != null) {
                        this.warnings.add("Warning : value specified for credential-interface doesn't conform to authentication type " + this.authMechType + " and will be ignored.");
                    }
                    ConnectorResourceAccessor.location.logT(300, "Warning : value specified for credential-interface doesn't conform to authentication type " + this.authMechType + " and will be ignored.");
                }
            } else if (this.authMechType != null && SAP_ASSERTION_TICKET_SET.contains(this.authMechType)) {
                throw new BaseIllegalArgumentException("connector_0303", new String[]{"credential-interface", GENERIC_CREDENTIAL});
            }
            this.credentialInterface = credential;
        }
    }

    public String getCredentialInterface() {
        return this.credentialInterface;
    }

    public void setWarnings(Vector warnings) {
        this.warnings = warnings;
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public Object clone() {
        AuthMechanism cloning = new AuthMechanism();
        cloning.authMechType = this.authMechType == null ? null : new String(this.authMechType);
        cloning.credentialInterface = this.credentialInterface == null ? null : new String(this.credentialInterface);
        cloning.description = this.description == null ? null : new String(this.description);
        return cloning;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthMechanism)) {
            return false;
        }
        AuthMechanism auth = (AuthMechanism)obj;
        if (auth.authMechType != null ? !auth.authMechType.equals(this.authMechType) : this.authMechType != null) {
            return false;
        }
        if (auth.credentialInterface != null ? !auth.credentialInterface.equals(this.credentialInterface) : this.credentialInterface != null) {
            return false;
        }
        return !(auth.description != null ? !auth.description.equals(this.description) : this.description != null);
    }

    static {
        sapAssertionTicketNames = new Vector();
        sapAssertionTicketNames.add(SAP_ASSERTION_TICKET_OID);
        sapAssertionTicketNames.add(SAP_ASSERTION_TICKET_NAME);
        SAP_ASSERTION_TICKET_SET = new HashSet(sapAssertionTicketNames);
    }
}

