/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class VersionChecker {
    public static final String SYSTEM_ID_10 = "http://java.sun.com/dtd/connector_1_0.dtd";
    public static final String SYSTEM_ID_15 = "http://java.sun.com/dtd/connector_1_5.dtd";
    private Document document = null;

    public VersionChecker(Document document) {
        this.document = document;
    }

    public String getConnectorVersion() {
        String version = "unknown";
        DocumentType docType = this.document.getDoctype();
        if (docType != null) {
            String systemID = docType.getSystemId();
            if (systemID.equals(SYSTEM_ID_10)) {
                version = "1.0";
            } else if (systemID.equals(SYSTEM_ID_15)) {
                version = "1.5";
            }
        } else {
            Element root = this.document.getDocumentElement();
            String vers = root.getAttribute("version");
            if (vers != null) {
                version = vers.equals("1.5") ? "1.5" : "1.0";
            }
        }
        return version;
    }
}

