/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy;

import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.resource.spi.ManagedConnectionFactory;

public class ApplicationInfo {
    private String appName = null;
    private String connectorGroup = null;
    private JCDescriptor[] descrs = null;
    private transient Vector mcfs = new Vector();
    private String[][] mapping = null;
    private HashSet registeredReferences = new HashSet();
    private String classLoaderName = null;
    private String[] loaderJars = null;
    private boolean isRealApp = false;
    private Properties props = null;

    public ApplicationInfo(String _appName, boolean _isRealApp) {
        this.appName = _appName;
        this.isRealApp = _isRealApp;
    }

    public void setConnectorGroup(String connector_group) {
        this.connectorGroup = connector_group;
    }

    public String getConnectorGroup() {
        return this.connectorGroup;
    }

    public void addJCDescriptor(JCDescriptor descr) {
        if (this.descrs == null) {
            this.descrs = new JCDescriptor[1];
            this.descrs[0] = descr;
        } else {
            JCDescriptor[] oldData = this.descrs;
            this.descrs = new JCDescriptor[this.descrs.length + 1];
            System.arraycopy(oldData, 0, this.descrs, 0, oldData.length);
            this.descrs[this.descrs.length - 1] = descr;
        }
    }

    public void addMCF(ManagedConnectionFactory mcf) {
        this.mcfs.add(mcf);
    }

    public Vector getMCFs() {
        return this.mcfs;
    }

    public void setJCDescriptors(JCDescriptor[] descrs) {
        this.descrs = descrs;
    }

    public JCDescriptor[] getJCDescriptors() {
        return this.descrs;
    }

    public void addLoaderReference(String loaderReference) {
        this.registeredReferences.add(loaderReference);
    }

    public boolean removeLoaderReference(String loaderReference) {
        return this.registeredReferences.remove(loaderReference);
    }

    public void addMapping(String jndiName, String[] aliases) {
        String[] data = null;
        if (aliases != null) {
            data = new String[aliases.length + 1];
            System.arraycopy(aliases, 0, data, 1, aliases.length);
        } else {
            data = new String[]{jndiName};
        }
        if (this.mapping == null) {
            this.mapping = new String[1][];
            this.mapping[0] = data;
        } else {
            String[][] newData = new String[this.mapping.length + 1][];
            System.arraycopy(this.mapping, 0, newData, 0, this.mapping.length);
            newData[newData.length - 1] = data;
            this.mapping = newData;
        }
    }

    public void setMapping(String[][] mapping) {
        this.mapping = mapping;
    }

    public String[][] getMapping() {
        return this.mapping;
    }

    public boolean isRealApp() {
        return this.isRealApp;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public void setClassLoaderName(String classLoaderName) {
        this.classLoaderName = classLoaderName;
    }

    public String getClassLoaderName() {
        return this.classLoaderName;
    }

    public void addFilesForClassLoader(String[] _loaderJars) {
        if (this.loaderJars == null) {
            this.loaderJars = new String[_loaderJars.length];
            System.arraycopy(_loaderJars, 0, this.loaderJars, 0, _loaderJars.length);
        } else {
            String[] newData = new String[this.loaderJars.length + _loaderJars.length];
            System.arraycopy(this.loaderJars, 0, newData, 0, this.loaderJars.length);
            System.arraycopy(_loaderJars, 0, newData, this.loaderJars.length, _loaderJars.length);
            this.loaderJars = newData;
        }
    }

    public String[] getFilesForClassLoader() {
        return this.loaderJars;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public Properties getProperties() {
        return this.props;
    }

    public Object clone() {
        String key;
        ApplicationInfo result = null;
        result = new ApplicationInfo(new String(this.appName), this.isRealApp);
        if (this.connectorGroup != null) {
            result.setConnectorGroup(new String(this.connectorGroup));
        }
        if (this.descrs == null) {
            result.descrs = null;
        } else {
            result.descrs = new JCDescriptor[this.descrs.length];
            int i = 0;
            while (i < this.descrs.length) {
                result.descrs[i] = this.descrs[i] == null ? null : (JCDescriptor)this.descrs[i].clone();
                ++i;
            }
        }
        if (this.registeredReferences == null) {
            result.registeredReferences = null;
        } else {
            HashSet<String> newRegisteredReferences = new HashSet<String>();
            Iterator iter = this.registeredReferences.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                newRegisteredReferences.add(new String(key));
            }
            result.registeredReferences = newRegisteredReferences;
        }
        if (this.mapping == null) {
            result.mapping = null;
        } else {
            String[][] newMapping = new String[this.mapping.length][];
            int i = 0;
            while (i < this.mapping.length) {
                String[] currentMapping = this.mapping[i];
                String[] newCurrentMapping = null;
                if (currentMapping == null) {
                    newMapping[i] = null;
                } else {
                    newCurrentMapping = new String[currentMapping.length];
                    int j = 0;
                    while (j < currentMapping.length) {
                        newCurrentMapping[j] = new String(currentMapping[j]);
                        ++j;
                    }
                    newMapping[i] = newCurrentMapping;
                }
                ++i;
            }
            result.mapping = newMapping;
        }
        result.classLoaderName = this.classLoaderName == null ? null : new String(this.classLoaderName);
        if (this.loaderJars == null) {
            result.loaderJars = null;
        } else {
            String[] newLoaderJars = new String[this.loaderJars.length];
            int i = 0;
            while (i < this.loaderJars.length) {
                newLoaderJars[i] = this.loaderJars[i];
                ++i;
            }
            result.loaderJars = newLoaderJars;
        }
        if (this.props == null) {
            result.props = null;
        } else {
            Properties newProps = new Properties();
            Enumeration enumeration = ((Hashtable)this.props).keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                ((Hashtable)newProps).put(new String(key), new String(this.props.getProperty(key)));
            }
            result.props = newProps;
        }
        return result;
    }
}

