/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca;

import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.exceptions.BaseRuntimeException;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.connector.resource.impl.ResourceSetImpl;
import com.sap.engine.services.connector.resource.impl.ResourceSetRecord;
import java.util.EmptyStackException;
import java.util.Stack;

public class ResourceSetContextObject
implements ContextObject {
    private ResourceSet resourceSet = null;
    private Stack resourceRecordStack = null;
    public static final String NAME = "RESOURCE_SET_CONTEXT_OBJECT";
    private static int CONTEXT_OBJECT_ID = -1;

    public ResourceSetContextObject(ResourceSet _resourceSet) {
        this.resourceSet = _resourceSet;
        this.resourceRecordStack = new Stack();
    }

    public ContextObject childValue(ContextObject parent, ContextObject child) {
        ResourceSet parent_rs;
        ResourceSetImpl r_set = null;
        if (parent != null && (parent_rs = ((ResourceSetContextObject)parent).resourceSet) != null) {
            r_set = new ResourceSetImpl(parent_rs.getApplicationName(), parent_rs.getComponentName());
        }
        if (child == null) {
            child = new ResourceSetContextObject(r_set);
        } else {
            ((ResourceSetContextObject)child).resourceSet = r_set;
            ((ResourceSetContextObject)child).resourceRecordStack = new Stack();
        }
        return child;
    }

    public ContextObject getInitialValue() {
        return new ResourceSetContextObject(null);
    }

    public void empty() {
        this.resourceSet = null;
        this.resourceRecordStack.clear();
    }

    public static ResourceSet getCurrentResourceSet() {
        ResourceSetContextObject.initContextObjectID();
        ThreadContext threadContext = ConnectorServiceFrame.threadSystem.getThreadContext();
        if (threadContext == null) {
            throw new BaseRuntimeException("connector_0518");
        }
        ResourceSetContextObject ctxObject = (ResourceSetContextObject)threadContext.getContextObject(CONTEXT_OBJECT_ID);
        if (ctxObject == null) {
            return null;
        }
        return ctxObject.resourceSet;
    }

    public static ResourceSet replaceCurrentResourceSet(ResourceSet resource_set) {
        ResourceSetContextObject.initContextObjectID();
        ThreadContext threadContext = ConnectorServiceFrame.threadSystem.getThreadContext();
        if (threadContext == null) {
            throw new BaseRuntimeException("connector_0518");
        }
        ResourceSetContextObject resultCtxObject = (ResourceSetContextObject)threadContext.getContextObject(CONTEXT_OBJECT_ID);
        ResourceSet oldResourceSet = resultCtxObject.resourceSet;
        resultCtxObject.resourceSet = resource_set;
        return oldResourceSet;
    }

    public static ResourceSetRecord popRecord() throws EmptyStackException {
        ResourceSetContextObject.initContextObjectID();
        ThreadContext threadContext = ConnectorServiceFrame.threadSystem.getThreadContext();
        if (threadContext == null) {
            throw new BaseRuntimeException("connector_0518");
        }
        ResourceSetContextObject resultCtxObject = (ResourceSetContextObject)threadContext.getContextObject(CONTEXT_OBJECT_ID);
        return (ResourceSetRecord)resultCtxObject.resourceRecordStack.pop();
    }

    public static void pushRecord(ResourceSetRecord rsRecord) {
        ResourceSetContextObject.initContextObjectID();
        ThreadContext threadContext = ConnectorServiceFrame.threadSystem.getThreadContext();
        if (threadContext == null) {
            throw new BaseRuntimeException("connector_0518");
        }
        ResourceSetContextObject resultCtxObject = (ResourceSetContextObject)threadContext.getContextObject(CONTEXT_OBJECT_ID);
        resultCtxObject.resourceRecordStack.push(rsRecord);
    }

    private static final void initContextObjectID() {
        if (CONTEXT_OBJECT_ID == -1) {
            ThreadContext tc = ConnectorServiceFrame.threadSystem.getThreadContext();
            CONTEXT_OBJECT_ID = tc.getContextObjectId(NAME);
        }
    }

    public static int getContextObjectID() {
        return CONTEXT_OBJECT_ID;
    }
}

