/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca.deploy.ContainerImpl;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class SwitchDebugMode
implements Command {
    private ContainerImpl runtime;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$connector$command$SwitchDebugMode == null ? (class$com$sap$engine$services$connector$command$SwitchDebugMode = SwitchDebugMode.class$("com.sap.engine.services.connector.command.SwitchDebugMode")) : class$com$sap$engine$services$connector$command$SwitchDebugMode));
    static /* synthetic */ Class class$com$sap$engine$services$connector$command$SwitchDebugMode;

    public SwitchDebugMode(ContainerImpl runtime) {
        this.runtime = runtime;
    }

    public String getName() {
        return "switch_debug_mode";
    }

    public String getGroup() {
        return "connector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        boolean debugMode = false;
        if (params.length == 1 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
            out.println(this.getHelpMessage());
            return;
        }
        if (params.length > 2 || params.length < 1) {
            out.println(this.getHelpMessage());
            return;
        }
        if (params.length == 2) {
            if (params[1].equalsIgnoreCase("-debug")) {
                debugMode = true;
            } else {
                out.println(this.getHelpMessage());
                return;
            }
        }
        try {
            this.runtime.switchDebugMode(params[0], debugMode);
            if (debugMode) {
                out.println("\nRuntime debug mode was successfully enabled.");
            } else {
                out.println("\nRuntime debug mode was successfully disabled.");
            }
        }
        catch (Exception exc) {
            if (debugMode) {
                out.println("\nCannot turn on runtime debug mode. For more details see connector service logs.");
            } else {
                out.println("\nCannot turn off runtime debug mode. For more details see connector service logs.");
            }
            ConnectorResourceAccessor.location.logT(500, "switch_debug_mode(), Error: " + Log.getStackTrace(exc));
        }
        if (debugMode) {
            out.println("\nService debug mode couldn't be enabled. In order to enable it use Log Configurator service.\n");
        } else {
            out.println("\nService debug mode couldn't be disabled. In order to disable it use Log Configurator service.\n");
        }
    }

    public String getHelpMessage() {
        return "\nSwitch debug mode status for used physical(managed) connections,\ncreated using the specified connector.\n\nUsage: SWITCH_DEBUG_MODE <connectorJNDIName> [-debug]\nParameters:\n\t<connectorName> - the jndi name of the connection factory for which the\n\t                  used and free ManagedConnection-s info will be observed\n\t<-debug>        - if specified, enable debug mode for the given connection factory\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

