/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.admin.ConfigEntryWrapper;
import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.gui.images.ImageHolder;
import com.sap.engine.services.configuration.exception.SAPConfigurationUnsupportedOperationException;
import com.sap.engine.services.configuration.gui.BaseTreeCellRenderer;
import com.sap.engine.services.configuration.gui.BaseTreeNode;
import com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel;
import com.sap.engine.services.configuration.gui.ValueEntryPanel;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ValueEntryTreeNode
extends BaseTreeNode {
    private static final Category CATEGORY = Category.getCategory((String)"/System/Server");
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$configuration$gui$ValueEntryTreeNode == null ? (class$com$sap$engine$services$configuration$gui$ValueEntryTreeNode = ValueEntryTreeNode.class$("com.sap.engine.services.configuration.gui.ValueEntryTreeNode")) : class$com$sap$engine$services$configuration$gui$ValueEntryTreeNode));
    private boolean _loaded = false;
    private Object _value;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$ValueEntryTreeNode;

    public ValueEntryTreeNode(DisplayAllConfigurationsPanel editor, String fullParentName, String name) {
        super(editor, fullParentName, name);
        this.initialize();
    }

    public ValueEntryTreeNode(DisplayAllConfigurationsPanel editor, String fullParentName, String name, Object initialValue) {
        super(editor, fullParentName, name);
        this.setValue(initialValue);
        this._loaded = true;
        this.initialize();
    }

    private void initialize() {
        this.setAllowsChildren(false);
        this.loadDisplayException(false);
    }

    protected void load(boolean forceReload) throws Exception {
        if (this._loaded && !forceReload) {
            return;
        }
        this._loaded = true;
        ConfigurationHandlerExtension handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandlerExtension();
                ConfigurationExtension configuration = handler.openConfigurationExtension(this.getFullParentName(), 0);
                this.setValue(configuration.getConfigEntryWrapper(this.getName()));
            }
            catch (Exception e) {
                if (this.getParent() != null && this.getParent() instanceof BaseTreeNode) {
                    ((BaseTreeNode)this.getParent()).refreshNode();
                }
                throw e;
            }
            Object var5_5 = null;
            this.closeAllConfigsInHandler(handler);
            if (forceReload && this.getModel() != null) {
                this.getModel().nodeChanged(this);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeAllConfigsInHandler(handler);
            if (forceReload && this.getModel() != null) {
                this.getModel().nodeChanged(this);
            }
            throw throwable;
        }
    }

    protected void loadChildren(boolean forceReload) throws Exception {
    }

    protected Object getValue() {
        return this._value;
    }

    private void setValue(Object value) {
        this._value = value;
        this.setUserObject(this.getDescription());
    }

    private String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append("=");
        if (this._value == null) {
            buf.append("<null>");
        } else if (this._value instanceof byte[]) {
            buf.append("<byte[" + ((byte[])this._value).length + "]> ");
        } else if (this._value instanceof String) {
            buf.append('\"').append(this._value).append('\"');
        } else if (this._value instanceof ConfigEntryWrapper) {
            ConfigEntryWrapper wrapper = (ConfigEntryWrapper)this._value;
            buf.append('<').append(wrapper.getOriginalClassName()).append('[').append(wrapper.getOriginalObjectToString()).append(']').append('>');
        } else {
            buf.append(this._value);
        }
        return buf.toString();
    }

    protected void deleteNode() {
        ConfigurationHandler handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandler();
                Configuration config = handler.openConfiguration(this.getFullParentName(), 1);
                config.deleteConfigEntry(this.getName());
                handler.commit();
                CATEGORY.infoT(LOCATION, "Deleted config entry " + this.getFullName());
                ((BaseTreeNode)this.getParent()).refreshNode();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var4_5 = null;
                this.closeAllConfigsInHandler(handler);
            }
            Object var4_4 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void changeNode() {
        ConfigurationHandler handler;
        block17: {
            block16: {
                block15: {
                    if (this._value == null) {
                        this.getEditor().displayMessage("Not possible", "Changing of null-values is not possible");
                        return;
                    }
                    if (this._value instanceof ConfigEntryWrapper) {
                        String className = ((ConfigEntryWrapper)this._value).getOriginalClassName();
                        this.getEditor().displayMessage("Not supported", "Changing of Objects of class " + className + " is not supported");
                        return;
                    }
                    handler = null;
                    try {
                        try {
                            handler = this.getFactory().getConfigurationHandler();
                            Configuration config = handler.openConfiguration(this.getFullParentName(), 1);
                            Object beforeRefreshValue = this._value;
                            this.refreshNode();
                            boolean changed = false;
                            if (!beforeRefreshValue.getClass().equals(this._value.getClass())) {
                                changed = true;
                            } else if (this._value instanceof byte[]) {
                                changed = !new String((byte[])this._value).equals(new String((byte[])beforeRefreshValue));
                            } else {
                                boolean bl = changed = !beforeRefreshValue.equals(this._value);
                            }
                            if (changed) {
                                this.getEditor().displayMessage("Data changed", "The data was changed meanwhile,\n but you can change the new value");
                            }
                            ValueEntryPanel valueEntryPanel = new ValueEntryPanel(this._value, true);
                            JOptionPane jOptionPane = new JOptionPane(valueEntryPanel, -1, 2);
                            JDialog jDialog = jOptionPane.createDialog(this.getEditor(), "Change value");
                            jDialog.setResizable(true);
                            jDialog.show();
                            Object obj = jOptionPane.getValue();
                            if (jOptionPane.getValue() == null) {
                                Object var12_11 = null;
                                this.closeAllConfigsInHandler(handler);
                                return;
                            }
                            int result = (Integer)obj;
                            if (result != 0) {
                                break block15;
                            }
                            Object newValue = valueEntryPanel.getValue();
                            if (newValue == null) {
                                break block16;
                            }
                            config.modifyConfigEntry(this.getName(), newValue);
                            handler.commit();
                            CATEGORY.infoT(LOCATION, "Changed config entry " + this.getFullName());
                            ((BaseTreeNode)this.getParent()).refreshNode();
                            break block17;
                        }
                        catch (Exception e) {
                            this.getEditor().displayException(e);
                            this.refreshAsGoodAsPossible();
                            Object var12_15 = null;
                            this.closeAllConfigsInHandler(handler);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        this.closeAllConfigsInHandler(handler);
                        throw throwable;
                    }
                }
                Object var12_12 = null;
                this.closeAllConfigsInHandler(handler);
                return;
            }
            Object var12_13 = null;
            this.closeAllConfigsInHandler(handler);
            return;
        }
        Object var12_14 = null;
        this.closeAllConfigsInHandler(handler);
    }

    protected void showDetailsNode() {
        if (this._value == null) {
            this.getEditor().displayMessage("Not possible", "Value is null");
            return;
        }
        if (this._value instanceof ConfigEntryWrapper) {
            String className = ((ConfigEntryWrapper)this._value).getOriginalClassName();
            this.getEditor().displayMessage("Not supported", "Displaying of Objects of class " + className + " is not supported");
            return;
        }
        ConfigurationHandler handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandler();
                Configuration config = handler.openConfiguration(this.getFullParentName(), 0);
                Object beforeRefreshValue = this._value;
                this.refreshNode();
                boolean changed = false;
                if (!beforeRefreshValue.getClass().equals(this._value.getClass())) {
                    changed = true;
                } else if (this._value instanceof byte[]) {
                    changed = !new String((byte[])this._value).equals(new String((byte[])beforeRefreshValue));
                } else {
                    boolean bl = changed = !beforeRefreshValue.equals(this._value);
                }
                if (changed) {
                    this.getEditor().displayMessage("Data changed", "The data was changed meanwhile,\n the new value is displayed");
                }
                ValueEntryPanel valueEntryPanel = new ValueEntryPanel(this._value, false);
                JOptionPane jOptionPane = new JOptionPane(valueEntryPanel, -1);
                JDialog jDialog = jOptionPane.createDialog(this.getEditor(), "Display value");
                jDialog.setResizable(true);
                jDialog.show();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var9_11 = null;
                this.closeAllConfigsInHandler(handler);
            }
            Object var9_10 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    protected void createConfigurationNode(String name, Integer cacheMode, int type) {
        throw new SAPConfigurationUnsupportedOperationException("configuration_1100");
    }

    protected void setIcons(BaseTreeCellRenderer renderer) {
        renderer.setLeafIcon(ImageHolder.fileIcon);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

