/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationInfo;
import com.sap.engine.services.configuration.exception.SAPConfigurationUnsupportedOperationException;
import com.sap.engine.services.configuration.gui.BaseTreeCellRenderer;
import com.sap.engine.services.configuration.gui.BaseTreeNode;
import com.sap.engine.services.configuration.gui.ConfigurationTreeNode;
import com.sap.engine.services.configuration.gui.Constants;
import com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel;
import java.util.Arrays;

public class RootTreeNode
extends BaseTreeNode
implements Constants {
    public static final String DISPLAY_NAME = "Configurations";
    private boolean _loaded = false;

    public RootTreeNode(DisplayAllConfigurationsPanel editor) {
        super(editor, null, null);
        this.initialize();
    }

    protected void initialize() {
        this.setAllowsChildren(true);
        this.loadDisplayException(false);
        this.setUserObject(DISPLAY_NAME);
    }

    protected void load(boolean forceReload) throws Exception {
        if (this._loaded && !forceReload) {
            return;
        }
        this._loaded = true;
        this.removeAllChildren();
        ConfigurationHandlerExtension handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandlerExtension();
                Object[] configInfo = handler.getAllRootConfigsInfos();
                Arrays.sort(configInfo);
                int i = 0;
                while (i < configInfo.length) {
                    this.add(new ConfigurationTreeNode(this.getEditor(), this.getFullName(), ((ConfigurationInfo)configInfo[i]).getName(), ((ConfigurationInfo)configInfo[i]).getCacheMode()));
                    ++i;
                }
            }
            catch (Exception e) {
                this.removeAllChildren();
                throw e;
            }
            Object var6_6 = null;
            this.closeAllConfigsInHandler(handler);
            if (forceReload && this.getModel() != null) {
                this.getModel().nodeStructureChanged(this);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeAllConfigsInHandler(handler);
            if (forceReload && this.getModel() != null) {
                this.getModel().nodeStructureChanged(this);
            }
            throw throwable;
        }
    }

    protected void loadChildren(boolean forceReload) throws Exception {
    }

    protected void deleteNode() {
        throw new SAPConfigurationUnsupportedOperationException("configuration_1101");
    }

    protected void changeNode() {
        throw new SAPConfigurationUnsupportedOperationException("configuration_1102");
    }

    protected void showDetailsNode() {
    }

    protected void createConfigurationNode(String name, Integer cacheMode, int type) {
        ConfigurationHandler handler = null;
        try {
            try {
                if (type != 0) {
                    throw new SAPConfigurationUnsupportedOperationException("configuration_1103", new Object[]{new Integer(type)});
                }
                handler = this.getFactory().getConfigurationHandler();
                Configuration subConfig = handler.createRootConfiguration(name);
                if (cacheMode != null) {
                    subConfig.setCacheMode(cacheMode);
                }
                handler.commit();
                this.refreshNode();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var7_8 = null;
                this.closeAllConfigsInHandler(handler);
            }
            Object var7_7 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    protected void setIcons(BaseTreeCellRenderer renderer) {
    }
}

