/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.admin.PropertySheetEntry;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.services.configuration.gui.PropertySheetPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class PropertySheetTableModel
extends AbstractTableModel {
    public static final String[] COLUMN_NAMES = new String[]{"name", "value", "custom"};
    private static final Util UTIL = new Util();
    private PropertySheetPanel _panel;
    private PropertySheetEntry[] _entry;
    private TableColumnModel _columnModel;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public PropertySheetTableModel(PropertySheetPanel panel) {
        this._panel = panel;
        this._entry = new PropertySheetEntry[0];
    }

    public void setColumnModel(TableColumnModel columnModel) {
        this._columnModel = columnModel;
        this._columnModel.setColumnSelectionAllowed(false);
        this.resizeColumns();
    }

    private void resizeColumns() {
        this._columnModel.getColumn(0).setPreferredWidth(250);
        this._columnModel.getColumn(1).setPreferredWidth(250);
        this._columnModel.getColumn(2).setMinWidth(50);
        this._columnModel.getColumn(2).setMaxWidth(50);
    }

    public void setValues(PropertySheetEntry[] entry) {
        this._entry = entry;
        this.fireTableDataChanged();
    }

    public PropertySheetEntry[] getValues() {
        return this._entry;
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this._entry[row].getName();
            }
            case 1: {
                if (this._entry[row].isSecure()) {
                    return "<secure content>";
                }
                return this._entry[row].getCustomValue() != null ? this._entry[row].getCustomValue() : this._entry[row].getDefaultValue();
            }
            case 2: {
                return new Boolean(this._entry[row].getCustomValue() != null);
            }
        }
        return null;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public int getRowCount() {
        return this._entry.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 2) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertySheetTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        return class$java$lang$String == null ? (class$java$lang$String = PropertySheetTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

