/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.PropertySheetEntry;
import com.sap.engine.frame.core.configuration.admin.PropertySheetExtension;
import com.sap.engine.gui.SortTable;
import com.sap.engine.services.configuration.exception.SAPConfigurationIllegalArgumentException;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.PropertySheetEntryPanel;
import com.sap.engine.services.configuration.gui.PropertySheetTableModel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class PropertySheetPanel
extends BasePanel
implements ListSelectionListener,
MouseMotionListener {
    private ConfigurationExtension _config;
    private PropertySheetExtension _sheet;
    private SortTable _sheetTable;
    private PropertySheetTableModel _sheetTableModel;
    private JScrollPane _scrollableTable;
    private MyTableCellRenderer _myRenderer;
    private boolean _editMode;
    private String[] m_toolTips;
    private int m_dismissDelay;
    static /* synthetic */ Class class$java$lang$String;

    public PropertySheetPanel(ConfigurationExtension config, boolean editMode) throws Exception {
        if (config == null) {
            throw new SAPConfigurationIllegalArgumentException("configuration_1202");
        }
        this._config = config;
        this._sheet = this._config.getPropertySheetExtensionInterface();
        this._editMode = editMode;
        this._sheetTableModel = new PropertySheetTableModel(this);
        this._sheetTable = ComponentFactory.createSortableTable(this._sheetTableModel);
        this._sheetTableModel.setColumnModel(this._sheetTable.getColumnModel());
        this._sheetTable.getTableHeader().setReorderingAllowed(false);
        this._sheetTable.getSelectionModel().setSelectionMode(0);
        this._sheetTable.getSelectionModel().addListSelectionListener(this);
        this._scrollableTable = new JScrollPane((Component)this._sheetTable, 20, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)this._scrollableTable, "Center");
        PropertySheetEntry[] values = this._sheet.getAllEntries();
        this._sheetTableModel.setValues(values);
        this.m_dismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.generateToolTips();
        this._sheetTable.addMouseMotionListener(this);
        this._myRenderer = new MyTableCellRenderer();
        int i = 0;
        while (i < this._sheetTable.getColumnCount()) {
            if (this._sheetTable.getColumnClass(i) == (class$java$lang$String == null ? PropertySheetPanel.class$("java.lang.String") : class$java$lang$String)) {
                this._sheetTable.getColumnModel().getColumn(i).setCellRenderer(this._myRenderer);
            }
            ++i;
        }
    }

    private PropertySheetEntry getSelectedConfiguration() {
        if (this._sheetTable.getSelectedRowCount() == 0) {
            return null;
        }
        int selectedRow = this._sheetTable.getSelectedRow();
        PropertySheetEntry[] allRows = this._sheetTableModel.getValues();
        PropertySheetEntry result = allRows[this._sheetTable.getDataIndex(selectedRow)];
        return result;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        try {
            if (this._sheetTable.getSelectedRowCount() == 0) {
                return;
            }
            int selectedRow = this._sheetTable.getSelectedRow();
            this._sheetTable.clearSelection();
            PropertySheetEntry[] allRows = this._sheetTableModel.getValues();
            PropertySheetEntry selected = allRows[this._sheetTable.getDataIndex(selectedRow)];
            String title = null;
            title = this._editMode ? "Change property entry" : "View property entry";
            PropertySheetEntryPanel editor = new PropertySheetEntryPanel(selected, this._editMode);
            JDialog dialog = ComponentFactory.createDialog(this, editor, title, true);
            ((Component)dialog).setVisible(true);
            if (editor.wasModified()) {
                Object customValue = editor.getCustomValue();
                if (customValue == null) {
                    this._sheet.getPropertyEntry(selected.getName()).restoreDefault();
                } else {
                    this._sheet.getPropertyEntry(selected.getName()).setValue(customValue);
                }
                PropertySheetEntry[] values = this._sheet.getAllEntries();
                this._sheetTableModel.setValues(values);
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        int row = this._sheetTable.getDataIndex(this._sheetTable.rowAtPoint(p));
        this._sheetTable.setToolTipText(this.m_toolTips[row]);
    }

    public void generateToolTips() {
        PropertySheetEntry[] entries = this._sheetTableModel.getValues();
        this.m_toolTips = new String[entries.length];
        int i = 0;
        while (i < entries.length) {
            PropertySheetEntry entry = entries[this._sheetTable.getDataIndex(i)];
            String key = entry.getName();
            Object def = entry.getDefaultValue();
            if (entry.isSecure()) {
                def = "[secure content]";
            }
            Object custom = entry.getCustomValue();
            if (entry.isSecure()) {
                custom = "[secure content]";
            }
            String descr = entry.getDescription();
            this.m_toolTips[this._sheetTable.getDataIndex((int)i)] = this.buildToolTip(key, def, custom, descr);
            ++i;
        }
    }

    private String buildToolTip(String key, Object def, Object custom, String descr) {
        StringBuffer html = new StringBuffer();
        html.append("<html><font face=");
        html.append(this.getFont().getName());
        html.append(" size=2>");
        html.append("Click to view/edit this PropertyEntry.<br>");
        html.append("<b>Description:</b> <br>");
        if (descr == null || descr.equals("")) {
            html.append("[no description]<br>");
        } else {
            this.wordWrapAppend(html, descr);
        }
        html.append("<br><b>Key:</b> <br>");
        html.append(key);
        html.append("<br><br><b>Default Value:</b> <br>");
        this.wordWrapAppend(html, def.toString());
        html.append("<br><b>Custom Value:</b> <br>");
        if (custom != null) {
            this.wordWrapAppend(html, custom.toString());
        } else {
            html.append("[undefined]<br>");
        }
        html.append("</font></html>");
        return html.toString();
    }

    private void wordWrapAppend(StringBuffer buffer, String text) {
        String whiteSpaces = " \t";
        int MAX_LENGTH = 80;
        String line = null;
        int index = text.length();
        while (index > 0) {
            index = text.indexOf(10);
            if (index != -1) {
                line = text.substring(0, index);
                text = text.substring(index + 1);
            } else {
                line = text;
            }
            while (line.length() > MAX_LENGTH) {
                int wrapIndex = MAX_LENGTH - 1;
                while (wrapIndex > 0) {
                    if (whiteSpaces.indexOf(line.charAt(wrapIndex)) != -1) break;
                    --wrapIndex;
                }
                if (wrapIndex == 0) {
                    wrapIndex = MAX_LENGTH - 1;
                }
                buffer.append(line.substring(0, wrapIndex));
                buffer.append("<br>");
                line = line.substring(wrapIndex);
            }
            buffer.append(line);
            buffer.append("<br>");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        ToolTipManager.sharedInstance().setDismissDelay(this.m_dismissDelay);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (value != null) {
                value = this.shortenMultiLineString(value.toString());
            }
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
            return c;
        }

        private String shortenMultiLineString(String text) {
            String result = null;
            int index = 0;
            result = text == null || (index = text.indexOf(10)) == -1 ? text : text.substring(0, index) + "...";
            return result;
        }
    }
}

