/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.admin.PropertySheetEntry;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class PropertySheetEntryPanel
extends BasePanel
implements ActionListener {
    private JTextArea _description;
    private JTextField _typeField;
    private JTextField _nameField;
    private JTextComponent _defaultField;
    private JTextComponent _customField;
    private JButton _restoreDefaultButton;
    private JButton _overtakeCustomButton;
    private JButton _cancelButton;
    private JButton _displayOkButton;
    private Object _customValue;
    private Class _defaultClass;
    private boolean _wasCanceled;
    private boolean _wasModified = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public PropertySheetEntryPanel(PropertySheetEntry entry, boolean editMode) throws Exception {
        this._customValue = entry.getCustomValue();
        this._defaultClass = entry.getDefaultValue().getClass();
        this._description = new JTextArea();
        this._description.setToolTipText("The description of the entry");
        this._description.setRows(2);
        this._description.setColumns(30);
        this._description.setEnabled(false);
        this._description.setLineWrap(true);
        JScrollPane scrollableDescriptionField = new JScrollPane(this._description);
        this._description.setText(entry.getDescription());
        this._description.setCaretPosition(0);
        this._nameField = ComponentFactory.createTextField(30, -1, "The name of the entry");
        this._nameField.setText(entry.getName());
        this._nameField.setEnabled(false);
        this._typeField = ComponentFactory.createTextField(30, -1, "The datatype of the entry");
        this._typeField.setText(this._defaultClass.getName());
        this._typeField.setEnabled(false);
        if (!entry.isSecure()) {
            this._defaultField = new JTextArea();
            ((JTextArea)this._defaultField).setRows(2);
            ((JTextArea)this._defaultField).setColumns(30);
            ((JTextArea)this._defaultField).setLineWrap(true);
        } else {
            this._defaultField = new JPasswordField();
        }
        this._defaultField.setToolTipText("The default-value of the entry");
        this._defaultField.setEditable(false);
        JScrollPane scrollableDefaultField = new JScrollPane(this._defaultField);
        this._defaultField.setText(entry.getDefaultValue().toString());
        this._defaultField.setCaretPosition(0);
        if (!entry.isSecure()) {
            this._customField = new JTextArea();
            ((JTextArea)this._customField).setRows(2);
            ((JTextArea)this._customField).setColumns(30);
            ((JTextArea)this._customField).setLineWrap(true);
        } else {
            this._customField = new JPasswordField();
        }
        this._customField.setToolTipText("The custom-value of the entry");
        if (!editMode) {
            this._customField.setEditable(false);
        }
        JScrollPane scrollableCustomField = new JScrollPane(this._customField);
        if (entry.getCustomValue() != null) {
            this._customField.setText(entry.getCustomValue().toString());
        }
        this._customField.setCaretPosition(0);
        JLabel descriptionLabel = new JLabel("Description:");
        JLabel nameLabel = new JLabel("Name:");
        JLabel typeLabel = new JLabel("Datatype:");
        JLabel defaultLabel = new JLabel("Default:");
        JLabel customLabel = new JLabel("Custom:");
        JLabel[] labels = new JLabel[]{descriptionLabel, nameLabel, typeLabel, defaultLabel, customLabel};
        JComponent[] components = new JComponent[]{scrollableDescriptionField, this._nameField, this._typeField, scrollableDefaultField, scrollableCustomField};
        JPanel fieldGrid = ComponentFactory.createLabeledGridPanel(labels, components);
        JPanel buttonPanel = null;
        if (editMode) {
            this._restoreDefaultButton = ComponentFactory.createButton("Restore default", null, this, "Restore the default value by discarding the custom value");
            this._overtakeCustomButton = ComponentFactory.createButton("Apply custom", null, this, "Apply the specified custom value");
            this._cancelButton = ComponentFactory.createButton("Cancel", null, this, "Cancel the operation and do not make any changes");
            buttonPanel = ComponentFactory.createHorizontalGridPanel(new JComponent[]{this._restoreDefaultButton, this._overtakeCustomButton, this._cancelButton});
        } else {
            this._displayOkButton = ComponentFactory.createButton("Ok", null, this, "Close this window");
            this._displayOkButton.setAlignmentX(0.5f);
            buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            buttonPanel.add(this._displayOkButton);
        }
        JPanel valueEntryPanel = ComponentFactory.createVerticalPanel(fieldGrid, null, buttonPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)valueEntryPanel, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Window window;
            Object source = event.getSource();
            if (source == this._overtakeCustomButton) {
                try {
                    this._wasCanceled = false;
                    this._wasModified = true;
                    String text = this._customField.getText();
                    if (this._defaultClass == (class$java$lang$String == null ? (class$java$lang$String = PropertySheetEntryPanel.class$("java.lang.String")) : class$java$lang$String)) {
                        this._customValue = text;
                    }
                    if (this._defaultClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertySheetEntryPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                        this._customValue = Boolean.valueOf(text);
                    }
                    if (this._defaultClass == (class$java$lang$Short == null ? (class$java$lang$Short = PropertySheetEntryPanel.class$("java.lang.Short")) : class$java$lang$Short)) {
                        this._customValue = Short.valueOf(text);
                    }
                    if (this._defaultClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = PropertySheetEntryPanel.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        this._customValue = Integer.valueOf(text);
                    }
                    if (this._defaultClass == (class$java$lang$Long == null ? (class$java$lang$Long = PropertySheetEntryPanel.class$("java.lang.Long")) : class$java$lang$Long)) {
                        this._customValue = Long.valueOf(text);
                    }
                    if (this._defaultClass == (class$java$lang$Double == null ? (class$java$lang$Double = PropertySheetEntryPanel.class$("java.lang.Double")) : class$java$lang$Double)) {
                        this._customValue = Double.valueOf(text);
                    }
                    this.displayMessage("Unknown datatype", "The datatype " + this._defaultClass + " is not registered and can not be created or changed");
                    return;
                }
                catch (NumberFormatException e) {
                    this.displayMessage("Invalid input for custom value", "The custom value can not be converted to the datatype " + this._defaultClass + ":\n" + e.getMessage());
                    return;
                }
            } else if (source == this._restoreDefaultButton) {
                this._wasCanceled = false;
                this._wasModified = true;
                this._customValue = null;
            } else if (source == this._cancelButton) {
                this._wasCanceled = true;
            }
            if ((source == this._displayOkButton || source == this._restoreDefaultButton || source == this._overtakeCustomButton || source == this._cancelButton) && (window = ComponentFactory.getWindowForComponent(this)) != null) {
                ((Component)window).setVisible(false);
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    public Object getCustomValue() {
        return this._customValue;
    }

    public boolean getWasCanceled() {
        return this._wasCanceled;
    }

    public boolean wasModified() {
        return this._wasModified;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

