/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.admin.OpenConfigInfo;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.OpenConfigurationTableModel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OpenConfigurationDetailPanel
extends BasePanel {
    private static final int VISIBLE_COLUMNS = 58;
    private JPanel _detailPanel;
    private JLabel _detailPathLabel;
    private JTextField _detailPathField;
    private JLabel _detailTransactionsLabel;
    private JTextField _detailTransactionsField;
    private JLabel _detailModeLabel;
    private JTextField _detailModeField;
    private JLabel _detailClusterIdLabel;
    private JTextField _detailClusterIdField;

    public OpenConfigurationDetailPanel(OpenConfigInfo openConfiguration) {
        this.initializeDetailPanel();
        this.displayOpenConfigInfo(openConfiguration);
    }

    private void initializeDetailPanel() {
        this._detailPathField = ComponentFactory.createTextField(58, -1, "The path of the configuration which is locked");
        this._detailTransactionsField = ComponentFactory.createTextField(58, -1, "The number of concurrent transactions on this configuration (always 1 for write-mode)");
        this._detailModeField = ComponentFactory.createTextField(58, -1, "The access-mode of the configuration (read or write)");
        this._detailClusterIdField = ComponentFactory.createTextField(58, -1, "The cluster-id on which this configuration is openend");
        this._detailPathField.setEditable(false);
        this._detailTransactionsField.setEditable(false);
        this._detailModeField.setEditable(false);
        this._detailClusterIdField.setEditable(false);
        this._detailPathLabel = new JLabel("Path:");
        this._detailTransactionsLabel = new JLabel("Transactions:");
        this._detailModeLabel = new JLabel("Access mode:");
        this._detailClusterIdLabel = new JLabel("Cluster id");
        JLabel[] labels = new JLabel[]{this._detailPathLabel, this._detailTransactionsLabel, this._detailModeLabel, this._detailClusterIdLabel};
        JComponent[] components = new JComponent[]{this._detailPathField, this._detailTransactionsField, this._detailModeField, this._detailClusterIdField};
        this._detailPanel = ComponentFactory.createLabeledGridPanel(labels, components);
        this.setLayout(new BorderLayout());
        this.add((Component)this._detailPanel, "North");
    }

    private void displayOpenConfigInfo(OpenConfigInfo openConfiguration) {
        this._detailPathField.setText(openConfiguration.getPath());
        this._detailTransactionsField.setText(Integer.toString(openConfiguration.getNumberOfAcessingTransactions()));
        this._detailModeField.setText(OpenConfigurationTableModel.getTextForAccessMode(openConfiguration.getAccessMode()));
        this._detailClusterIdField.setText(Integer.toString(openConfiguration.getClusterNodeID()));
        this._detailPathField.setCaretPosition(0);
        this._detailTransactionsField.setCaretPosition(0);
        this._detailModeField.setCaretPosition(0);
        this._detailClusterIdField.setCaretPosition(0);
    }
}

