/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.services.configuration.gui.AbstractConfigurationTreeNode;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportPanel
extends BasePanel
implements ActionListener,
DocumentListener {
    private static Icon ICON_IMPORT = new ImageIcon((class$com$sap$engine$services$configuration$gui$ImportPanel == null ? (class$com$sap$engine$services$configuration$gui$ImportPanel = ImportPanel.class$("com.sap.engine.services.configuration.gui.ImportPanel")) : class$com$sap$engine$services$configuration$gui$ImportPanel).getResource("images/icon_import.gif"));
    private static Icon ICON_CLOSE = new ImageIcon((class$com$sap$engine$services$configuration$gui$ImportPanel == null ? (class$com$sap$engine$services$configuration$gui$ImportPanel = ImportPanel.class$("com.sap.engine.services.configuration.gui.ImportPanel")) : class$com$sap$engine$services$configuration$gui$ImportPanel).getResource("images/icon_close_config.gif"));
    protected static final int IMPORT_CONTENT = 0;
    protected static final int IMPORT_AS_SUBCONFIGURATION = 1;
    private static final String IMPORT_CONTENT_MODE = "IMPORT_CONTENT";
    private static final String IMPORT_AS_SUBCONFIG_MODE = "IMPORT_AS_SUBNODE";
    private JTextField m_fileName;
    private JButton m_chooseFile;
    private JButton m_startButton;
    private JButton m_cancelButton;
    private JTextArea m_statusOutput;
    private ButtonGroup m_importModeRadioGroup;
    private JRadioButton m_importContent;
    private JRadioButton m_importSubNode;
    private AbstractConfigurationTreeNode m_node;
    private boolean m_online;
    private int m_importMode;
    private Timer m_timer;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$ImportPanel;

    public ImportPanel(AbstractConfigurationTreeNode node, boolean online) {
        this.m_node = node;
        this.m_online = online;
        this.m_timer = new Timer(1000, this);
        this.m_fileName = ComponentFactory.createTextField(30, 256, "The location and name of the source file for the export");
        this.m_fileName.getDocument().addDocumentListener(this);
        this.m_chooseFile = ComponentFactory.createButton("...", this, "Browse ...");
        JPanel fileNameLabel = ComponentFactory.createLabelForComponent("Source file name:", this.m_fileName);
        JPanel chooseFilePanel = ComponentFactory.createHorizontalPanel(fileNameLabel, null, this.m_chooseFile);
        this.m_startButton = ComponentFactory.createButton("Start import", ICON_IMPORT, this, "Start the import of the file");
        this.m_startButton.setEnabled(false);
        this.m_cancelButton = ComponentFactory.createButton("Close window", ICON_CLOSE, this, "Close this dialg");
        this.m_importContent = new JRadioButton("Import content directly into the selected configuration", true);
        this.m_importMode = 0;
        Font radioButtonFont = new Font(this.m_importContent.getFont().getName(), this.m_importContent.getFont().getStyle(), this.m_importContent.getFont().getSize() - 1);
        this.m_importContent.setFont(radioButtonFont);
        this.m_importContent.addActionListener(this);
        this.m_importSubNode = new JRadioButton("Import content as sub-configuration below the selected configuration");
        this.m_importSubNode.setFont(radioButtonFont);
        this.m_importSubNode.addActionListener(this);
        this.m_importModeRadioGroup = new ButtonGroup();
        this.m_importModeRadioGroup.add(this.m_importContent);
        this.m_importModeRadioGroup.add(this.m_importSubNode);
        JPanel radioPanel = ComponentFactory.createVerticalGridPanel(new JComponent[]{this.m_importContent, this.m_importSubNode});
        radioPanel.setBorder(ComponentFactory.STANDARD_LINE_BORDER);
        JPanel buttonPanel = ComponentFactory.createHorizontalPanel(this.m_startButton, null, this.m_cancelButton);
        JPanel topPanel = ComponentFactory.createVerticalPanel(chooseFilePanel, radioPanel, buttonPanel, ComponentFactory.STANDARD_LINE_BORDER);
        JLabel logLabel = new JLabel("Import status:");
        this.m_statusOutput = new JTextArea();
        this.m_statusOutput.setFont(new Font("Monospaced", this.m_statusOutput.getFont().getStyle(), this.m_statusOutput.getFont().getSize()));
        this.m_statusOutput.setRows(7);
        this.m_statusOutput.setColumns(30);
        this.m_statusOutput.setEditable(false);
        this.m_statusOutput.setLineWrap(true);
        JScrollPane scrollableOutputArea = new JScrollPane(this.m_statusOutput);
        JPanel bottomPanel = ComponentFactory.createVerticalPanel(logLabel, null, scrollableOutputArea, ComponentFactory.STANDARD_LINE_BORDER);
        JPanel exportPanel = ComponentFactory.createVerticalPanel(topPanel, null, bottomPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)exportPanel, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_timer) {
            this.m_statusOutput.append(".");
        } else if (source == this.m_chooseFile) {
            int result;
            JFileChooser fileChooser = new JFileChooser();
            if (DisplayAllConfigurationsPanel.FileChooserRoot != null) {
                fileChooser.setCurrentDirectory(DisplayAllConfigurationsPanel.FileChooserRoot);
            }
            if ((result = fileChooser.showOpenDialog(this)) != 0) {
                return;
            }
            DisplayAllConfigurationsPanel.FileChooserRoot = fileChooser.getCurrentDirectory();
            String fileName = fileChooser.getSelectedFile().getAbsolutePath();
            this.m_fileName.setText(fileName);
            this.m_startButton.setEnabled(true);
        } else if (source == this.m_startButton) {
            this.startImport();
        } else if (source == this.m_cancelButton) {
            Window window = ComponentFactory.getWindowForComponent(this);
            if (window != null) {
                ((Component)window).setVisible(false);
            }
        } else if (source == this.m_importContent || source == this.m_importSubNode) {
            this.m_importMode = source == this.m_importContent ? 0 : 1;
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.m_fileName.getText().length() > 0) {
            this.m_startButton.setEnabled(true);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.m_fileName.getText().length() == 0) {
            this.m_startButton.setEnabled(false);
        }
    }

    private void startImport() {
        String modeString = this.m_importMode == 0 ? IMPORT_CONTENT_MODE : IMPORT_AS_SUBCONFIG_MODE;
        File file = new File(this.m_fileName.getText());
        if (!file.exists()) {
            this.displayMessage("File does not exist", "The specified file '" + file + "' does not exist.");
            return;
        }
        if (file.isDirectory()) {
            this.displayMessage("Path is directory", "The specified path '" + file + "' is a directory.");
            return;
        }
        this.m_statusOutput.setText("");
        this.m_statusOutput.append("Start importing into configuration " + this.m_node.getFullName() + ", importMode: " + modeString + "...\n");
        this.m_statusOutput.append("Importing ...");
        new Thread(new ImporterThread()).start();
        this.m_timer.start();
        this.m_startButton.setEnabled(false);
        this.m_cancelButton.setEnabled(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ImporterThread
    implements Runnable {
        ImporterThread() {
        }

        public void run() {
            Throwable ex = null;
            long startTime = System.currentTimeMillis();
            try {
                ImportPanel.this.m_node.importConfig(ImportPanel.this.m_fileName.getText(), ImportPanel.this.m_importMode);
            }
            catch (Throwable e) {
                ex = e;
            }
            ImportPanel.this.m_timer.stop();
            if (ex == null) {
                long endTime = System.currentTimeMillis();
                ImportPanel.this.m_statusOutput.append("\nSuccessfully imported in " + (endTime - startTime) + " ms.");
            } else {
                StringWriter writer = new StringWriter();
                PrintWriter wrapper = new PrintWriter(writer);
                ex.printStackTrace(wrapper);
                ImportPanel.this.m_statusOutput.setLineWrap(false);
                ImportPanel.this.m_statusOutput.append("\nException occured during import:\n");
                ImportPanel.this.m_statusOutput.append(writer.toString());
                ImportPanel.this.m_statusOutput.append("\nImport failed.");
                ImportPanel.this.m_statusOutput.setLineWrap(true);
            }
            ImportPanel.this.m_startButton.setEnabled(true);
            ImportPanel.this.m_cancelButton.setEnabled(true);
        }
    }
}

