/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.gui.images.ImageHolder;
import com.sap.engine.services.configuration.exception.SAPConfigurationUnsupportedOperationException;
import com.sap.engine.services.configuration.gui.BaseTreeCellRenderer;
import com.sap.engine.services.configuration.gui.BaseTreeNode;
import com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel;
import com.sap.engine.services.configuration.gui.FileEntryPanel;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class FileEntryTreeNode
extends BaseTreeNode {
    private static final Category CATEGORY = Category.getCategory((String)"/System/Server");
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$configuration$gui$FileEntryTreeNode == null ? (class$com$sap$engine$services$configuration$gui$FileEntryTreeNode = FileEntryTreeNode.class$("com.sap.engine.services.configuration.gui.FileEntryTreeNode")) : class$com$sap$engine$services$configuration$gui$FileEntryTreeNode));
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$FileEntryTreeNode;

    public FileEntryTreeNode(DisplayAllConfigurationsPanel editor, String fullParentName, String name) {
        super(editor, fullParentName, name);
        this.initialize();
    }

    private void initialize() {
        this.setAllowsChildren(false);
        this.loadDisplayException(false);
    }

    protected void load(boolean forceReload) throws Exception {
        this.setUserObject(this.getName());
    }

    protected void loadChildren(boolean forceReload) throws Exception {
    }

    protected void deleteNode() {
        ConfigurationHandler handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandler();
                Configuration config = handler.openConfiguration(this.getFullParentName(), 1);
                config.deleteFile(this.getName());
                handler.commit();
                CATEGORY.infoT(LOCATION, "Deleted file entry " + this.getFullName());
                ((BaseTreeNode)this.getParent()).refreshNode();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var4_5 = null;
                this.closeAllConfigsInHandler(handler);
            }
            Object var4_4 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void changeNode() {
        ConfigurationHandlerExtension handler;
        block10: {
            block9: {
                block8: {
                    handler = null;
                    try {
                        try {
                            handler = this.getFactory().getConfigurationHandlerExtension();
                            ConfigurationExtension config = handler.openConfigurationExtension(this.getFullParentName(), 1);
                            byte[] value = config.getFileAsBytes(this.getName());
                            FileEntryPanel fileEntryPanel = new FileEntryPanel(value, 20, 60, true, null, this.getName());
                            JOptionPane jOptionPane = new JOptionPane(fileEntryPanel, -1, 2);
                            JDialog jDialog = jOptionPane.createDialog(this.getEditor(), "Change file");
                            jDialog.setResizable(true);
                            jDialog.show();
                            Object obj = jOptionPane.getValue();
                            if (jOptionPane.getValue() == null) {
                                Object var11_9 = null;
                                this.closeAllConfigsInHandler(handler);
                                return;
                            }
                            int result = (Integer)obj;
                            if (result != 0) {
                                break block8;
                            }
                            byte[] newValue = fileEntryPanel.getValue();
                            if (newValue == null) {
                                break block9;
                            }
                            config.updateFileAsBytes(this.getName(), newValue);
                            handler.commit();
                            CATEGORY.infoT(LOCATION, "Updated file entry " + this.getFullName());
                            ((BaseTreeNode)this.getParent()).refreshNode();
                            break block10;
                        }
                        catch (Exception e) {
                            this.getEditor().displayException(e);
                            this.refreshAsGoodAsPossible();
                            Object var11_13 = null;
                            this.closeAllConfigsInHandler(handler);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        this.closeAllConfigsInHandler(handler);
                        throw throwable;
                    }
                }
                Object var11_10 = null;
                this.closeAllConfigsInHandler(handler);
                return;
            }
            Object var11_11 = null;
            this.closeAllConfigsInHandler(handler);
            return;
        }
        Object var11_12 = null;
        this.closeAllConfigsInHandler(handler);
    }

    protected void showDetailsNode() {
        ConfigurationHandlerExtension handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandlerExtension();
                ConfigurationExtension config = handler.openConfigurationExtension(this.getFullParentName(), 0);
                byte[] value = config.getFileAsBytes(this.getName());
                FileEntryPanel fileEntryPanel = new FileEntryPanel(value, 20, 60, false, null, this.getName());
                JOptionPane jOptionPane = new JOptionPane(fileEntryPanel, -1);
                JDialog jDialog = jOptionPane.createDialog(this.getEditor(), "Display file");
                jDialog.setResizable(true);
                jDialog.show();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var8_9 = null;
                this.closeAllConfigsInHandler(handler);
            }
            Object var8_8 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    protected void createConfigurationNode(String name, Integer cacheMode, int type) {
        throw new SAPConfigurationUnsupportedOperationException("configuration_1100");
    }

    protected void setIcons(BaseTreeCellRenderer renderer) {
        renderer.setLeafIcon(ImageHolder.manifestFile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

