/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.BaseTreeNode;
import com.sap.engine.services.configuration.gui.ConfigurationPanel;
import com.sap.engine.services.configuration.gui.ConfigurationTreeNode;
import com.sap.engine.services.configuration.gui.FileEntryPanel;
import com.sap.engine.services.configuration.gui.ValueEntryPanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateTreeNodePanel
extends BasePanel
implements ActionListener {
    private static Icon ICON_CREATE = new ImageIcon((class$com$sap$engine$services$configuration$gui$CreateTreeNodePanel == null ? (class$com$sap$engine$services$configuration$gui$CreateTreeNodePanel = CreateTreeNodePanel.class$("com.sap.engine.services.configuration.gui.CreateTreeNodePanel")) : class$com$sap$engine$services$configuration$gui$CreateTreeNodePanel).getResource("images/icon_create.gif"));
    private static Icon ICON_CLOSE = new ImageIcon((class$com$sap$engine$services$configuration$gui$CreateTreeNodePanel == null ? (class$com$sap$engine$services$configuration$gui$CreateTreeNodePanel = CreateTreeNodePanel.class$("com.sap.engine.services.configuration.gui.CreateTreeNodePanel")) : class$com$sap$engine$services$configuration$gui$CreateTreeNodePanel).getResource("images/icon_close_config.gif"));
    private BaseTreeNode _node;
    private JPanel _inputPanel;
    private JComboBox _typeSelection;
    private JTextField _nameField;
    private JPanel _nameFieldPanel;
    private ConfigurationPanel _createConfigurationPanel;
    private JPanel _createPropertySheetPanel;
    private ValueEntryPanel _createValueEntryPanel;
    private FileEntryPanel _createFileEntryPanel;
    private JPanel _specificCreatePanel;
    private CardLayout _specificCreateCardLayout;
    private JButton _createButton;
    private JButton _closeWindowButton;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$CreateTreeNodePanel;

    public CreateTreeNodePanel(BaseTreeNode node, boolean allowCloseWindow) throws Exception {
        this._node = node;
        Object[] nodeTypes = this._node instanceof ConfigurationTreeNode ? new String[]{"Sub-configuration", "Value-entry", "File-entry"} : new String[]{"Sub-configuration"};
        this._typeSelection = ComponentFactory.createComboBox(nodeTypes, 0, this, "Select the type to create");
        this._nameField = ComponentFactory.createTextField(20, -1, "The name of the entry to create");
        this._nameFieldPanel = ComponentFactory.createLabelForComponent("Name:", this._nameField);
        JPanel topPanel = ComponentFactory.createVerticalPanel(this._typeSelection, null, this._nameFieldPanel);
        topPanel.setBorder(ComponentFactory.STANDARD_LINE_BORDER);
        this._createConfigurationPanel = new ConfigurationPanel(null, true);
        this._createValueEntryPanel = new ValueEntryPanel((Object)null, true);
        this._createFileEntryPanel = new FileEntryPanel(null, 10, 20, true, this, null);
        this._specificCreateCardLayout = new CardLayout();
        this._specificCreatePanel = new JPanel();
        this._specificCreatePanel.setLayout(this._specificCreateCardLayout);
        this._specificCreatePanel.setBorder(ComponentFactory.STANDARD_LINE_BORDER);
        this._specificCreatePanel.add((Component)this._createConfigurationPanel, "Sub-configuration");
        this._specificCreatePanel.add((Component)this._createValueEntryPanel, "Value-entry");
        this._specificCreatePanel.add((Component)this._createFileEntryPanel, "File-entry");
        this._createButton = ComponentFactory.createButton("Create", ICON_CREATE, this, "Create the specified item");
        this._closeWindowButton = ComponentFactory.createButton("Close window", ICON_CLOSE, this, "Closes this popup-window");
        JPanel buttonPanel = allowCloseWindow ? ComponentFactory.createHorizontalGridPanel(new JComponent[]{this._createButton, this._closeWindowButton}) : ComponentFactory.createHorizontalPanel(null, this._createButton, null);
        this._inputPanel = ComponentFactory.createVerticalPanel(topPanel, this._specificCreatePanel, buttonPanel);
        this._inputPanel.setBorder(ComponentFactory.STANDARD_LINE_BORDER);
        this.setLayout(new BorderLayout());
        this.add((Component)this._inputPanel, "Center");
        this.displaySpecificCreatePanel();
    }

    public void setName(String name) {
        this._nameField.setText(name);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._createButton) {
                if ("Sub-configuration".equals(this._typeSelection.getSelectedItem())) {
                    int cacheMode = this._createConfigurationPanel.getCacheMode();
                    this._node.createConfigurationNode(this._nameField.getText(), new Integer(cacheMode), 0);
                } else if ("Value-entry".equals(this._typeSelection.getSelectedItem())) {
                    Object value = this._createValueEntryPanel.getValue();
                    if (value == null) {
                        return;
                    }
                    ((ConfigurationTreeNode)this._node).createValueEntryNode(this._nameField.getText(), this._createValueEntryPanel.getValueClass(), value);
                } else {
                    byte[] value = this._createFileEntryPanel.getValue();
                    if (value == null) {
                        return;
                    }
                    ((ConfigurationTreeNode)this._node).createFileEntryNode(this._nameField.getText(), value);
                }
            } else if (source == this._closeWindowButton) {
                Window window = ComponentFactory.getWindowForComponent(this);
                if (window != null) {
                    ((Component)window).setVisible(false);
                }
            } else if (source == this._typeSelection) {
                this.displaySpecificCreatePanel();
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    private void displaySpecificCreatePanel() {
        this._specificCreateCardLayout.show(this._specificCreatePanel, (String)this._typeSelection.getSelectedItem());
        this._specificCreatePanel.validate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

