/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfigurationPanel
extends BasePanel {
    private Configuration _config;
    private JCheckBox _readAllCheckBox;
    private JCheckBox _cacheOnCheckBox;

    public ConfigurationPanel(Configuration config, boolean editMode) throws Exception {
        this._config = config;
        JLabel readAllLabel = new JLabel("Read all");
        this._readAllCheckBox = new JCheckBox();
        JLabel cacheOnLabel = new JLabel("Caching on");
        this._cacheOnCheckBox = new JCheckBox();
        if (this._config != null) {
            int cacheMode = this._config.getCacheMode();
            this._readAllCheckBox.setSelected((cacheMode & 2) != 0);
            this._cacheOnCheckBox.setSelected((cacheMode & 8) != 0);
        } else {
            this._readAllCheckBox.setSelected(true);
            this._cacheOnCheckBox.setSelected(true);
        }
        this._readAllCheckBox.setEnabled(editMode);
        this._cacheOnCheckBox.setEnabled(editMode);
        JLabel[] left = new JLabel[]{readAllLabel, cacheOnLabel};
        JComponent[] right = new JComponent[]{this._readAllCheckBox, this._cacheOnCheckBox};
        JPanel createConfigurationPanel = ComponentFactory.createLabeledGridPanel(left, right);
        this.setLayout(new BorderLayout());
        this.add((Component)createConfigurationPanel, "North");
    }

    public int getCacheMode() {
        int cacheMode = this._readAllCheckBox.isSelected() ? 2 : 4;
        return cacheMode |= this._cacheOnCheckBox.isSelected() ? 8 : 16;
    }
}

