/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.admin.BlockingLock;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.OpenConfigurationTableModel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BlockingLockDetailPanel
extends BasePanel {
    private static final int VISIBLE_COLUMNS = 58;
    private JPanel _detailPanel;
    private JLabel _detailPathLabel;
    private JTextField _detailPathField;
    private JLabel _detailTransIdLabel;
    private JTextField _detailTransIdField;
    private JLabel _detailWaitersLabel;
    private JTextField _detailWaitersField;
    private JLabel _detailModeLabel;
    private JTextField _detailModeField;
    private JLabel _detailClusterIdLabel;
    private JTextField _detailClusterIdField;
    private JLabel _detailTimeLabel;
    private JTextField _detailTimeField;

    public BlockingLockDetailPanel(BlockingLock openConfiguration) {
        this.initializeDetailPanel();
        this.displayBlockingLock(openConfiguration);
    }

    private void initializeDetailPanel() {
        this._detailPathField = ComponentFactory.createTextField(58, -1, "The path of the configuration which is locked");
        this._detailTransIdField = ComponentFactory.createTextField(58, -1, "The id of the transaction which is holding the lock");
        this._detailWaitersField = ComponentFactory.createTextField(58, -1, "The number of threads, which are waiting to access this configuration");
        this._detailModeField = ComponentFactory.createTextField(58, -1, "The access-mode of the waiting threads (read or write)");
        this._detailClusterIdField = ComponentFactory.createTextField(58, -1, "The id of the cluster node on which the threads are waiting");
        this._detailTimeField = ComponentFactory.createTextField(58, -1, "The time in seconds the blocking lock is already active");
        this._detailPathField.setEditable(false);
        this._detailTransIdField.setEditable(false);
        this._detailWaitersField.setEditable(false);
        this._detailModeField.setEditable(false);
        this._detailClusterIdField.setEditable(false);
        this._detailTimeField.setEditable(false);
        this._detailPathLabel = new JLabel("Path:");
        this._detailTransIdLabel = new JLabel("Transaction Id:");
        this._detailWaitersLabel = new JLabel("Waiters:");
        this._detailModeLabel = new JLabel("Access mode:");
        this._detailClusterIdLabel = new JLabel("Cluster Id:");
        this._detailTimeLabel = new JLabel("Time:");
        JLabel[] labels = new JLabel[]{this._detailPathLabel, this._detailTransIdLabel, this._detailWaitersLabel, this._detailModeLabel, this._detailClusterIdLabel, this._detailTimeLabel};
        JComponent[] components = new JComponent[]{this._detailPathField, this._detailTransIdField, this._detailWaitersField, this._detailModeField, this._detailClusterIdField, this._detailTimeField};
        this._detailPanel = ComponentFactory.createLabeledGridPanel(labels, components);
        this.setLayout(new BorderLayout());
        this.add((Component)this._detailPanel, "North");
    }

    private void displayBlockingLock(BlockingLock openConfiguration) {
        this._detailPathField.setText(openConfiguration.getBlockedConfigurationPath());
        this._detailTransIdField.setText(openConfiguration.getLockOwnerTransactionID());
        this._detailWaitersField.setText(Integer.toString(openConfiguration.getNumberOfWaiters()));
        this._detailModeField.setText(OpenConfigurationTableModel.getTextForAccessMode(openConfiguration.getAccessMode()));
        this._detailClusterIdField.setText(Integer.toString(openConfiguration.getClusterNodeID()));
        this._detailTimeField.setText(Integer.toString(openConfiguration.getBlockingTime()));
        this._detailPathField.setCaretPosition(0);
        this._detailTransIdField.setCaretPosition(0);
        this._detailWaitersField.setCaretPosition(0);
        this._detailModeField.setCaretPosition(0);
        this._detailClusterIdField.setCaretPosition(0);
        this._detailTimeField.setCaretPosition(0);
    }
}

