/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command.test;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.services.configuration.command.test.TestThread;

public class WriterThread
extends TestThread {
    private boolean m_stop = false;

    public WriterThread(ConfigurationHandlerFactory factory, String name, String[] params) {
        super(factory, name, params);
    }

    /*
     * Loose catch block
     */
    public void run() {
        ConfigurationHandler handler = null;
        try {
            handler = this.getFactory().getConfigurationHandler();
            while (!this.m_stop) {
                Configuration root = handler.openConfiguration("write_read_test", 1);
                Configuration config = root.createSubConfiguration("write");
                config.addConfigEntry("value1", new Boolean(true));
                config.addConfigEntry("value2", new Boolean(true));
                config.addConfigEntry("value3", new Boolean(true));
                handler.commit();
                System.out.println("created: " + this.getName());
                this.hangOut(500);
                config.deleteConfiguration();
                handler.commit();
                System.out.println("deleted: " + this.getName());
                Object var5_7 = null;
                try {
                    handler.closeAllConfigurations();
                    this.hangOut(500);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
                {
                    catch (ConfigurationException ce) {
                        if (ce instanceof NameAlreadyExistsException || ce instanceof ConfigurationLockedException) {
                            this.hangOut(10);
                        } else {
                            ce.printStackTrace();
                            this.m_stop = true;
                        }
                        var5_7 = null;
                        try {
                            handler.closeAllConfigurations();
                            this.hangOut(500);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var5_7 = null;
                    try {
                        handler.closeAllConfigurations();
                        this.hangOut(500);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                handler.closeAllConfigurations();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void hangOut(int howlong) {
        try {
            WriterThread writerThread = this;
            synchronized (writerThread) {
                this.wait(howlong);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public void kill() {
        this.m_stop = true;
    }
}

