/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerFactoryExtension;
import com.sap.engine.frame.core.configuration.admin.Controller;
import com.sap.engine.frame.core.configuration.admin.OpenConfigInfo;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.services.configuration.command.AbstractCommand;
import com.sap.engine.services.configuration.exception.SAPConfigurationIllegalArgumentException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class OpenConfigsCommand
extends AbstractCommand {
    private static final String NAME = "open_configs";
    private static final String DESCRIPTION = "Display and/or close configurations opened in read or write access.";
    private static final String USAGE = "Usage: open_configs [options]\n\nwhere options include:\n    -l -list     List all currently opened configurations\n    -c -close    First list all currently opened configurations, then select one to be closed\n\n";
    private ConfigurationHandlerFactoryExtension m_factory = this.getConfigurationRuntime().getConfigurationContext();

    public OpenConfigsCommand(ConfigurationRuntimeInterface runtime) {
        super(runtime);
    }

    public String getUsage() {
        return USAGE;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        PrintStream out = new PrintStream(output);
        if (params.length != 1) {
            out.println(this.getUsage());
            return;
        }
        if (params[0].equalsIgnoreCase("-list") || params[0].equalsIgnoreCase("-l")) {
            this.displayOpenConfigsList(output);
        } else if (params[0].equalsIgnoreCase("-close") || params[0].equalsIgnoreCase("-c")) {
            OpenConfigInfo[] configs = this.displayOpenConfigsList(output);
            this.closeConfig(configs, input, output);
        } else {
            out.println(this.getUsage());
        }
    }

    public String getName() {
        return NAME;
    }

    private OpenConfigInfo[] displayOpenConfigsList(OutputStream os) {
        PrintStream out = new PrintStream(os);
        Controller controller = null;
        try {
            controller = this.m_factory.getConfigurationController();
            OpenConfigInfo[] configs = controller.getOpenConfigurationInfo();
            if (configs.length == 0) {
                out.println("Currently no configurations opened.");
                return null;
            }
            out.println("\nLINE FORMAT: Config #: ClusterNode ID, Path of configuration, Access mode, Number of accessing transactions\n");
            int i = 0;
            while (i < configs.length) {
                String accessMode = configs[i].getAccessMode() == 0 ? "READ" : "WRITE";
                out.println(i + ": " + configs[i].getClusterNodeID() + ", " + configs[i].getPath() + ", " + accessMode + ", " + configs[i].getNumberOfAcessingTransactions());
                ++i;
            }
            out.println();
            return configs;
        }
        catch (Exception e) {
            this.displayException(out, e);
            return null;
        }
    }

    private void closeConfig(OpenConfigInfo[] configs, InputStream is, OutputStream os) {
        if (configs == null) {
            return;
        }
        PrintStream out = new PrintStream(os);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        Controller controller = null;
        try {
            int nrToBeClosed;
            controller = this.m_factory.getConfigurationController();
            out.print("Enter config # to be closed: ");
            String configNumber = in.readLine();
            if (configNumber == "") {
                throw new SAPConfigurationIllegalArgumentException("configuration_1203");
            }
            try {
                nrToBeClosed = Integer.parseInt(configNumber);
            }
            catch (NumberFormatException e) {
                throw new SAPConfigurationIllegalArgumentException("configuration_1203");
            }
            if (nrToBeClosed < 0 || nrToBeClosed > configs.length - 1) {
                throw new SAPConfigurationIllegalArgumentException("configuration_1204");
            }
            controller.forceToCloseConfiguration(configs[nrToBeClosed]);
            out.println("\nConfiguration closed.");
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }
}

