/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class MonitorEventCommand
implements Command,
ConfigurationChangedListener {
    private static final String GROUP = "configuration";
    private static final String NAME = "monitor_event";
    private static StringBuffer m_usageBuffer = new StringBuffer();
    private ConfigurationRuntimeInterface m_configurationRuntimeInterface = null;
    private ConfigurationHandlerExtension m_configurationHandler = null;
    private PrintStream m_globalOut = null;
    private boolean m_commandAlreadyExecuted = false;
    private String m_pathWithFileName = null;
    private Vector m_pathsVector = new Vector();
    private static int m_mode;
    private static final byte MONITOR_TO_FILE = 1;
    private static final byte MONITOR_TO_SCREEN = 2;
    private File m_f = null;
    private PrintWriter m_pw = null;

    public MonitorEventCommand(ConfigurationRuntimeInterface testRuntimeInterface) {
        this.m_configurationRuntimeInterface = testRuntimeInterface;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        PrintStream actualOut = new PrintStream(output);
        try {
            if (this.m_configurationHandler == null) {
                this.m_configurationHandler = this.m_configurationRuntimeInterface.getConfigurationContext().getConfigurationHandlerExtension();
            }
        }
        catch (Exception e) {
            actualOut.println("Error: " + e.getMessage());
            actualOut.println("       See log for details\n");
            e.printStackTrace(this.m_globalOut);
        }
        if (!this.parseArgs(params)) {
            actualOut.println(m_usageBuffer.toString());
            return;
        }
        if (m_mode == 1) {
            if (this.m_pathWithFileName.equals("")) {
                this.m_globalOut.println("Error: File name isn't correct!");
                return;
            }
            File f = new File(this.m_pathWithFileName);
            if (!f.isAbsolute()) {
                this.m_globalOut.println(this.m_pathWithFileName + " should be a absolute path!");
                return;
            }
            if (f.getName().equals("")) {
                this.m_globalOut.println("Error: File name isn't correct!");
                return;
            }
        }
        if (params[0].equalsIgnoreCase("-start") && !this.m_commandAlreadyExecuted) {
            this.startMonitoring(output);
        } else if (params[0].equalsIgnoreCase("-start") && this.m_commandAlreadyExecuted) {
            actualOut.println("Info: You try to execute this command a further times!");
            actualOut.println("      Now, the old monitoring will be stopped and the new");
            actualOut.println("      one will be started.");
            this.stopMonitoring(output);
            this.startMonitoring(output);
        } else if (params[0].equalsIgnoreCase("-stop")) {
            this.stopMonitoring(output);
        } else if (params[0].equalsIgnoreCase("-s") || params[0].equalsIgnoreCase("-status")) {
            actualOut.println("Info: monitor_event is currently switched " + this.isSwitchedOn());
        }
    }

    private void startMonitoring(OutputStream output) {
        this.m_globalOut = new PrintStream(output);
        if (m_mode == 1) {
            try {
                this.m_f = new File(this.m_pathWithFileName);
                this.m_f.getParentFile().mkdirs();
                if (this.m_f.exists()) {
                    long time = System.currentTimeMillis();
                    if (this.m_pathWithFileName.indexOf(".") != -1) {
                        int index = this.m_pathWithFileName.indexOf(".");
                        this.m_pathWithFileName = this.m_pathWithFileName.substring(0, index) + "_" + time + "." + this.m_pathWithFileName.substring(index + 1, this.m_pathWithFileName.length());
                    } else {
                        this.m_pathWithFileName = this.m_pathWithFileName + "_" + time;
                    }
                    this.m_globalOut.println("Warning: The file does already exist. The new name");
                    this.m_globalOut.println("         for the created file will be: " + this.m_pathWithFileName);
                    this.m_f = new File(this.m_pathWithFileName);
                }
                this.m_pw = new PrintWriter((Writer)new OutputStreamWriter(new FileOutputStream(this.m_f)), true);
            }
            catch (IOException e) {
                e.printStackTrace(this.m_globalOut);
            }
        }
        Iterator iter = ((AbstractList)this.m_pathsVector).iterator();
        while (iter.hasNext()) {
            this.m_configurationHandler.addConfigurationChangedListener(this, (String)iter.next());
        }
        this.m_commandAlreadyExecuted = true;
        this.m_globalOut.println("Info: Monitoring is starting...listeners will be registered");
    }

    private void stopMonitoring(OutputStream output) {
        this.m_globalOut = new PrintStream(output);
        Iterator iter = ((AbstractList)this.m_pathsVector).iterator();
        while (iter.hasNext()) {
            this.m_configurationHandler.removeConfigurationChangedListener(this, (String)iter.next());
        }
        this.m_commandAlreadyExecuted = false;
        if (this.m_pw != null) {
            this.m_pw.close();
        }
        this.m_globalOut.println("Info: Monitoring is stopping...listeners will be removed");
    }

    private boolean parseArgs(String[] args) {
        if (args.length < 1) {
            return false;
        }
        if (args[0].equalsIgnoreCase("-start")) {
            if (args.length == 3) {
                if (args[1].equalsIgnoreCase("-path") || args[1].equalsIgnoreCase("-p")) {
                    m_mode = 2;
                    this.m_pathsVector = this.getPaths(args[2]);
                    return true;
                }
                return false;
            }
            if (args.length == 5) {
                if (!args[1].equalsIgnoreCase("-path") && !args[1].equalsIgnoreCase("-p")) {
                    return false;
                }
                this.m_pathsVector = this.getPaths(args[2]);
                if (args[3].equalsIgnoreCase("-file") || args[3].equalsIgnoreCase("-f")) {
                    m_mode = 1;
                    this.m_pathWithFileName = args[4];
                    return true;
                }
                return false;
            }
            return false;
        }
        if (args[0].equalsIgnoreCase("-stop") || args[0].equalsIgnoreCase("-s") || args[0].equalsIgnoreCase("-status")) {
            return args.length == 1;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private Vector getPaths(String pathString) {
        st = new StringTokenizer(pathString, ";");
        tempVector = new Vector<String>();
        if (!pathString.equalsIgnoreCase("-all") && !pathString.equalsIgnoreCase("-a")) ** GOTO lbl19
        rootPathsArray = null;
        try {
            rootPathsArray = this.m_configurationHandler.getAllRootNames();
        }
        catch (ConfigurationException e) {
            e.printStackTrace(this.m_globalOut);
        }
        i = 0;
        while (i < rootPathsArray.length) {
            tempVector.add(rootPathsArray[i]);
            ++i;
        }
        return tempVector;
lbl-1000:
        // 1 sources

        {
            tempVector.add(st.nextToken());
lbl19:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl20:
        // 1 sources

        return tempVector;
    }

    public void configurationChanged(ChangeEvent e) {
        if (m_mode == 2) {
            this.m_globalOut.println(e);
            ChangeEvent[] allEvents = e.getDetailedChangeEvents();
            int i = 0;
            while (i < allEvents.length) {
                this.m_globalOut.println(allEvents[i]);
                ++i;
            }
            this.m_globalOut.println("------------------------------------------------------");
        } else if (m_mode == 1) {
            this.m_pw.println(e);
            ChangeEvent[] allEvents = e.getDetailedChangeEvents();
            int i = 0;
            while (i < allEvents.length) {
                this.m_pw.println(allEvents[i]);
                ++i;
            }
            this.m_pw.println("------------------------------------------------------");
        }
    }

    private String isSwitchedOn() {
        if (this.m_commandAlreadyExecuted) {
            return "on";
        }
        return "off";
    }

    public String getGroup() {
        return GROUP;
    }

    public String getHelpMessage() {
        return m_usageBuffer.toString();
    }

    public String getName() {
        return NAME;
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    static {
        m_usageBuffer.append("Enables monitoring of changes of specific or all configuration paths.\n");
        m_usageBuffer.append("Note that the path does not have to point to an existing configuration.\n");
        m_usageBuffer.append("This way you will be notified about the creation of this configuration.\n");
        m_usageBuffer.append("\n");
        m_usageBuffer.append("Usage: MONITOR_EVENT <-start> <-p paths|-a> [-f filepath]\n");
        m_usageBuffer.append("                     <-stop>\n");
        m_usageBuffer.append("                     <-s>\n");
        m_usageBuffer.append("\n");
        m_usageBuffer.append(" <-start>                         - Starts the monitoring\n");
        m_usageBuffer.append(" <-p[ath] paths|-a[ll]>           - The paths to the configurations which should be\n");
        m_usageBuffer.append("                                    monitored. You can register all configurations with\n");
        m_usageBuffer.append("                                    \"-a\" or one or many paths separated with\n");
        m_usageBuffer.append("                                    \";\". Example: apps;deploy;security\n");
        m_usageBuffer.append(" [-f[ile] filepath]               - For printing the output to a file you have to\n");
        m_usageBuffer.append("                                    declare the absolute path and the filename\n");
        m_usageBuffer.append(" <-stop>                          - Stops the monitoring for all paths\n");
        m_usageBuffer.append(" <-s[tatus]>                      - Shows the current state of the monitor_event command\n");
        m_mode = 0;
    }
}

