/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.admin.ConfigManagementInterface;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;

public class ConfigurationStatisticCommand
implements Command {
    private static final String GROUP = "configuration";
    private static final String NAME = "cfg_statistics";
    private static StringBuffer m_usageBuffer = new StringBuffer();
    private static byte m_mode = 0;
    private static final byte SHOW_SINCE_STARTUP = 0;
    private static final byte SHOW_SINCE_RESET = 1;
    private static final byte RESET = 2;
    private static Date m_lastResetDate = null;
    private static final Date m_startupDate = new Date();
    private static long[] m_statistics = new long[8];
    private ConfigurationRuntimeInterface m_configurationRuntimeInterface = null;
    private ConfigManagementInterface m_cfgMgmtInterface = null;
    private PrintStream m_globalOut = null;

    public ConfigurationStatisticCommand(ConfigurationRuntimeInterface configurationRuntimeInterface) {
        this.m_configurationRuntimeInterface = configurationRuntimeInterface;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        this.m_globalOut = new PrintStream(output);
        if (!this.parseArgs(params)) {
            this.m_globalOut.println(m_usageBuffer.toString());
            return;
        }
        if (this.m_cfgMgmtInterface == null) {
            try {
                this.m_cfgMgmtInterface = this.m_configurationRuntimeInterface.getConfigurationContext().getConfigurationController().getConfigManagementInterface();
            }
            catch (ConfigurationException e) {
                e.printStackTrace(this.m_globalOut);
            }
        }
        if (m_mode == 0) {
            this.showStatisticsSinceStartup();
        } else if (m_mode == 1) {
            this.showStatisticsSinceReset();
        } else if (m_mode == 2) {
            this.reset();
        }
    }

    private void showStatisticsSinceStartup() {
        try {
            this.m_globalOut.println("Statistics since the last startup of the server (" + m_startupDate + "):");
            this.m_globalOut.println("Accumulated time of all commits since startup:                 " + this.m_cfgMgmtInterface.getAccCommitTime());
            this.m_globalOut.println("Accumulated number of all commits since startup:               " + this.m_cfgMgmtInterface.getAccNrOfCommits());
            this.m_globalOut.println("Accumulated number of requests for an open configuration:      " + this.m_cfgMgmtInterface.getAccNrOfAllOpenConfigRequests());
            this.m_globalOut.println("Accumulated number of open configurations for read access:     " + this.m_cfgMgmtInterface.getAccNrOpenForRead());
            this.m_globalOut.println("Accumulated number of open configurations for write access:    " + this.m_cfgMgmtInterface.getAccNrOpenForWrite());
            this.m_globalOut.println("Accumulated number of open configurations for write access\nwhere the configuration was locked:                            " + this.m_cfgMgmtInterface.getAccNrLockedOpenForWrite());
            this.m_globalOut.println("Accumulated number of requests to read a cached configuration: " + this.m_cfgMgmtInterface.getAccNrOfRequests());
            this.m_globalOut.println("Accumulated number of requests to read a cached configuration\nwhere the request could be satisfied from the cache:           " + this.m_cfgMgmtInterface.getAccNrOfCacheRequests() + "\n");
        }
        catch (ConfigurationException e1) {
            e1.printStackTrace(this.m_globalOut);
        }
    }

    private void showStatisticsSinceReset() {
        if (m_lastResetDate == null) {
            this.m_globalOut.println("Info: The statistics have not been resetted yet!");
        } else {
            try {
                this.m_globalOut.println("\nStatistics since the last reset of the statistics (" + m_lastResetDate + "):");
                this.m_globalOut.println("Accumulated time of all commits since reset:                   " + (this.m_cfgMgmtInterface.getAccCommitTime() - m_statistics[0]));
                this.m_globalOut.println("Accumulated number of all commits since reset:                 " + (this.m_cfgMgmtInterface.getAccNrOfCommits() - m_statistics[1]));
                this.m_globalOut.println("Accumulated number of requests for an open configuration:      " + (this.m_cfgMgmtInterface.getAccNrOfAllOpenConfigRequests() - m_statistics[2]));
                this.m_globalOut.println("Accumulated number of open configurations for read access:     " + (this.m_cfgMgmtInterface.getAccNrOpenForRead() - m_statistics[3]));
                this.m_globalOut.println("Accumulated number of open configurations for write access:    " + (this.m_cfgMgmtInterface.getAccNrOpenForWrite() - m_statistics[4]));
                this.m_globalOut.println("Accumulated number of open configurations for write access\nwhere the configuration was locked:                            " + (this.m_cfgMgmtInterface.getAccNrLockedOpenForWrite() - m_statistics[5]));
                this.m_globalOut.println("Accumulated number of requests to read a cached configuration: " + (this.m_cfgMgmtInterface.getAccNrOfRequests() - m_statistics[6]));
                this.m_globalOut.println("Accumulated number of requests to read a cached configuration\nwhere the request could be satisfied from the cache:           " + (this.m_cfgMgmtInterface.getAccNrOfCacheRequests() - m_statistics[7]) + "\n");
            }
            catch (ConfigurationException e1) {
                e1.printStackTrace(this.m_globalOut);
            }
        }
    }

    private void reset() {
        this.m_globalOut.println("Info: The statistics are resetted!");
        m_lastResetDate = new Date();
        try {
            ConfigurationStatisticCommand.m_statistics[0] = this.m_cfgMgmtInterface.getAccCommitTime();
            ConfigurationStatisticCommand.m_statistics[1] = this.m_cfgMgmtInterface.getAccNrOfCommits();
            ConfigurationStatisticCommand.m_statistics[2] = this.m_cfgMgmtInterface.getAccNrOfAllOpenConfigRequests();
            ConfigurationStatisticCommand.m_statistics[3] = this.m_cfgMgmtInterface.getAccNrOpenForRead();
            ConfigurationStatisticCommand.m_statistics[4] = this.m_cfgMgmtInterface.getAccNrOpenForWrite();
            ConfigurationStatisticCommand.m_statistics[5] = this.m_cfgMgmtInterface.getAccNrLockedOpenForWrite();
            ConfigurationStatisticCommand.m_statistics[6] = this.m_cfgMgmtInterface.getAccNrOfRequests();
            ConfigurationStatisticCommand.m_statistics[7] = this.m_cfgMgmtInterface.getAccNrOfCacheRequests();
        }
        catch (ConfigurationException e) {
            e.printStackTrace(this.m_globalOut);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseArgs(String[] args) {
        if (args.length < 1) {
            return false;
        }
        if (args[0].equalsIgnoreCase("-since")) {
            if (args.length != 2) return false;
            if (args[1].equalsIgnoreCase("reset") || args[1].equalsIgnoreCase("r")) {
                m_mode = 1;
                return true;
            }
            if (!args[1].equalsIgnoreCase("startup") && !args[1].equalsIgnoreCase("s")) return false;
            m_mode = 0;
            return true;
        }
        if (!args[0].equalsIgnoreCase("-reset") && !args[0].equalsIgnoreCase("-r")) return false;
        if (args.length != 1) {
            return false;
        }
        m_mode = (byte)2;
        return true;
    }

    public String getGroup() {
        return GROUP;
    }

    public String getHelpMessage() {
        return m_usageBuffer.toString();
    }

    public String getName() {
        return NAME;
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    static {
        m_usageBuffer.append("Enables statistic functionality of the configuration manager.\n");
        m_usageBuffer.append("\n");
        m_usageBuffer.append("Usage: CFG_STATISTICS <-since s|r>\n");
        m_usageBuffer.append("                      <-r>\n");
        m_usageBuffer.append("\n");
        m_usageBuffer.append(" <-since r[eset]|s[tartup]>       - Shows the configuration statistics of the server node since\n");
        m_usageBuffer.append("                                    the last reset of the statistics or since the last startup\n");
        m_usageBuffer.append(" <-r[eset]>                       - Resets the current statistics\n");
    }
}

