/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.appconfiguration.impl;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.services.configuration.appconfiguration.ApplicationConfigHandlerFactory;
import com.sap.engine.services.configuration.appconfiguration.ApplicationConfigurationHandler;
import com.sap.engine.services.configuration.appconfiguration.ApplicationPropertiesChangeListener;
import com.sap.engine.services.configuration.appconfiguration.impl.AppPropertiesChangeListenerWrapper;
import com.sap.engine.services.configuration.appconfiguration.impl.ApplicationConfigurationHandlerImpl;
import com.sap.engine.services.configuration.appconfiguration.impl.ApplicationStateChangeListener;
import com.sap.engine.services.configuration.appconfiguration.impl.ChangeListenerWrapper;
import com.sap.engine.services.configuration.appconfiguration.impl.DeployCallbackAdapter;
import com.sap.engine.services.deploy.DeployService;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ApplicationConfigHandlerFactoryImpl
implements ApplicationConfigHandlerFactory,
ApplicationStateChangeListener {
    private ThreadSystem m_threadManager;
    private ConfigurationContext m_configContext;
    private ComponentExecutionContext m_appContext;
    private DeployService m_deploy;
    private ConfigurationHandler m_internalConfigHandler;
    private Hashtable m_applicationsData = new Hashtable();
    private Hashtable m_listenerContext = new Hashtable();
    public static String APP_CFG_ROOT = "APP_CONFIG_ROOT";
    public static final String APPLICATION_GLOBAL_PROPERTIES = "application.global.properties";

    public ApplicationConfigHandlerFactoryImpl(ConfigurationContext configContext, ApplicationServiceContext serviceContext) throws Exception {
        this.m_configContext = configContext;
        this.m_internalConfigHandler = configContext.getConfigurationHandler();
        this.m_appContext = (ComponentExecutionContext)serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("appcontext");
        this.m_deploy = (DeployService)serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("container");
        String localName = serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getName();
        this.m_threadManager = serviceContext.getCoreContext().getThreadSystem();
        DeployCallbackAdapter deployCallback = new DeployCallbackAdapter(this.m_deploy, localName);
        deployCallback.setApplicationStateChangeListener(this);
    }

    protected ThreadSystem getThreadSystem() {
        return this.m_threadManager;
    }

    public ApplicationConfigurationHandler getApplicationConfigurationHandler() throws ConfigurationException {
        return new ApplicationConfigurationHandlerImpl(this);
    }

    public Properties getApplicationProperties() {
        String path = this.getAppConfigPath(this.getApplicationContext()) + "/" + APPLICATION_GLOBAL_PROPERTIES;
        try {
            ConfigurationHandler handler = this.m_configContext.getConfigurationHandler();
            while (true) {
                Object var7_6;
                try {
                    try {
                        PropertySheet p = handler.openConfiguration(path, 0).getPropertySheetInterface();
                        Properties properties = p.getProperties();
                        var7_6 = null;
                        handler.closeAllConfigurations();
                        return properties;
                    }
                    catch (InconsistentReadException e0) {
                        var7_6 = null;
                        handler.closeAllConfigurations();
                        continue;
                    }
                    catch (NameNotFoundException e1) {
                        Properties properties = null;
                        var7_6 = null;
                        handler.closeAllConfigurations();
                        return properties;
                    }
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    handler.closeAllConfigurations();
                    throw throwable;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected ConfigurationContext getCoreConfigurationContext() {
        return this.m_configContext;
    }

    protected String getAppConfigPath(String appContext) {
        try {
            return this.m_deploy.getApplicationInformation(appContext).getApplicationConfigurationPath();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    protected void registerListenerContext(String appContext) {
        this.m_listenerContext.put(Thread.currentThread(), appContext);
    }

    protected void unRegisterListenerContext() {
        this.m_listenerContext.remove(Thread.currentThread());
    }

    protected String getApplicationContext() {
        String name = (String)this.m_listenerContext.get(Thread.currentThread());
        if (name != null) {
            return name;
        }
        return this.m_appContext.getApplicationName();
    }

    private Object[] getApplicationDataStruct(String id) {
        Object[] data = (Object[])this.m_applicationsData.get(id);
        if (data == null) {
            data = new Object[]{new HashMap(), Collections.synchronizedSet(new HashSet()), new HashMap()};
            this.m_applicationsData.put(id, data);
        }
        return data;
    }

    private Map getListenerMapForApplication(String appcontext) {
        return (Map)this.getApplicationDataStruct(appcontext)[0];
    }

    private Set getOpenConfigsMapForApplication(String appcontext) {
        return (Set)this.getApplicationDataStruct(appcontext)[1];
    }

    public void registerOpenedConfiguration(Configuration cfg, String appcontext) {
        this.getOpenConfigsMapForApplication(appcontext).add(cfg);
    }

    public void unRegisterOpenedConfiguration(Configuration cfg, String appcontext) {
        this.getOpenConfigsMapForApplication(appcontext).remove(cfg);
    }

    public void addConfigurationChangedListener(ConfigurationChangedListener l, String path, String appContext) {
        String listenPath = this.getAppConfigPath(appContext);
        if (!path.equals("")) {
            listenPath = listenPath + "/" + path;
        }
        Map listeners = this.getListenerMapForApplication(appContext);
        ListenerWrapperInfo wrappedListener = this.getWrapperForAddListener(l, listeners, appContext);
        this.m_internalConfigHandler.addConfigurationChangedListener(wrappedListener.m_wrapper, listenPath, 2);
        wrappedListener.addListenPath(listenPath);
    }

    public void removeConfigurationChangedListener(ConfigurationChangedListener l, String path, String appContext) {
        Map listeners = this.getListenerMapForApplication(appContext);
        ListenerWrapperInfo wrappedListener = this.getWrapperForRemoveListener(l, listeners);
        if (wrappedListener == null) {
            return;
        }
        String listenPath = this.getAppConfigPath(appContext);
        if (!path.equals("")) {
            listenPath = listenPath + "/" + path;
        }
        this.m_internalConfigHandler.removeConfigurationChangedListener(wrappedListener.m_wrapper, listenPath);
        wrappedListener.removeListenPath(listenPath);
    }

    private ListenerWrapperInfo getWrapperForAddListener(ConfigurationChangedListener l, Map listeners, String appContext) {
        Map map = listeners;
        synchronized (map) {
            ListenerWrapperInfo wrapper = (ListenerWrapperInfo)listeners.get(l);
            if (wrapper == null) {
                wrapper = new ListenerWrapperInfo(new ChangeListenerWrapper(l, this, appContext));
                listeners.put(l, wrapper);
            }
            wrapper.m_registerCount++;
            ListenerWrapperInfo listenerWrapperInfo = wrapper;
            return listenerWrapperInfo;
        }
    }

    private ListenerWrapperInfo getWrapperForRemoveListener(ConfigurationChangedListener l, Map listeners) {
        Map map = listeners;
        synchronized (map) {
            ListenerWrapperInfo wrapper = (ListenerWrapperInfo)listeners.get(l);
            if (wrapper == null) {
                ListenerWrapperInfo listenerWrapperInfo = null;
                return listenerWrapperInfo;
            }
            wrapper.m_registerCount--;
            if (wrapper.m_registerCount == 0) {
                listeners.remove(l);
            }
            ListenerWrapperInfo listenerWrapperInfo = wrapper;
            return listenerWrapperInfo;
        }
    }

    private void cleanUpApplication(String appName) {
        Map listeners = this.getListenerMapForApplication(appName);
        Iterator allListeners = listeners.values().iterator();
        int i = 0;
        while (i < listeners.size()) {
            ListenerWrapperInfo listener = (ListenerWrapperInfo)allListeners.next();
            String[] paths = listener.getAllListenPaths();
            int ii = 0;
            while (ii < paths.length) {
                this.m_internalConfigHandler.removeConfigurationChangedListener(listener.m_wrapper, paths[ii]);
                ++ii;
            }
            ++i;
        }
        listeners.clear();
        Set openConfigs = this.getOpenConfigsMapForApplication(appName);
        Iterator allOpenConfigs = openConfigs.iterator();
        int i2 = 0;
        while (i2 < openConfigs.size()) {
            try {
                ((Configuration)allOpenConfigs.next()).close();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            ++i2;
        }
        openConfigs.clear();
        HashMap appcfgListeners = this.getAppPropertiesChangedListenerMap(appName);
        appcfgListeners.clear();
    }

    public void applicationStopped(String appName) {
        this.cleanUpApplication(appName);
    }

    private HashMap getAppPropertiesChangedListenerMap(String appContext) {
        return (HashMap)this.getApplicationDataStruct(appContext)[2];
    }

    public void addApplicationPropertiesChangedListener(ApplicationPropertiesChangeListener listener) {
        HashMap listeners;
        String appContext = this.getApplicationContext();
        HashMap hashMap = listeners = this.getAppPropertiesChangedListenerMap(appContext);
        synchronized (hashMap) {
            AppPropertiesChangeListenerWrapper wrapper = (AppPropertiesChangeListenerWrapper)listeners.get(listener);
            if (wrapper == null) {
                wrapper = new AppPropertiesChangeListenerWrapper(listener);
                this.addConfigurationChangedListener(wrapper, APPLICATION_GLOBAL_PROPERTIES, appContext);
                listeners.put(listener, wrapper);
            }
        }
    }

    public void removeApplicationPropertiesChangedListener(ApplicationPropertiesChangeListener listener) {
        HashMap listeners;
        String appContext = this.getApplicationContext();
        HashMap hashMap = listeners = this.getAppPropertiesChangedListenerMap(appContext);
        synchronized (hashMap) {
            AppPropertiesChangeListenerWrapper wrapper = (AppPropertiesChangeListenerWrapper)listeners.get(listener);
            if (wrapper != null) {
                this.removeConfigurationChangedListener(wrapper, APPLICATION_GLOBAL_PROPERTIES, appContext);
                listeners.remove(listener);
            }
        }
    }

    private class ListenerWrapperInfo {
        private ConfigurationChangedListener m_wrapper;
        private int m_registerCount;
        private HashSet m_listenPaths;

        public ListenerWrapperInfo(ConfigurationChangedListener wrapper) {
            this.m_wrapper = wrapper;
            this.m_registerCount = 0;
            this.m_listenPaths = new HashSet();
        }

        public void addListenPath(String path) {
            this.m_listenPaths.add(path);
        }

        public void removeListenPath(String path) {
            this.m_listenPaths.remove(path);
        }

        public String[] getAllListenPaths() {
            return ((AbstractCollection)this.m_listenPaths).toArray(new String[0]);
        }
    }
}

