/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.test;

import com.sap.engine.services.applocking.LogicalLocking;
import com.sap.engine.services.applocking.test.BaseLogicalLockingTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class LifetimeTransactionTest
extends BaseLogicalLockingTest {
    public String getName() {
        return "LogicalLocking: Create locks for the transaction-lifetime";
    }

    public String getDescription() {
        return "1) Creates locks of all modes inside a transaction\n2) Commit the transaction and check if locks were removed";
    }

    protected void test(Properties properties, TestResult logging, LogicalLocking locking) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String argument2 = "$$_TESTARGUMENT_$$argument2";
        String argument3 = "$$_TESTARGUMENT_$$argument3";
        logging.log("Create exclusive lock outside transaction -> expect exception");
        this.lockExpectTechnicalException(locking, (byte)1, name1, argument1, 'S');
        logging.log("Begin transaction");
        this.beginTransaction();
        logging.log("Create several locks of all types");
        locking.lock((byte)1, name1, argument1, 'S');
        locking.lock((byte)1, name1, argument1, 'S');
        locking.lock((byte)1, name1, argument1, 'S');
        locking.lock((byte)1, name1, argument2, 'E');
        locking.lock((byte)1, name1, argument2, 'E');
        locking.lock((byte)1, name1, argument2, 'E');
        locking.lock((byte)1, name1, argument3, 'X');
        logging.log("Create several conflicting locks -> expect exception");
        this.lockExpectException(locking, (byte)1, name1, argument1, 'X');
        this.lockExpectException(locking, (byte)1, name1, argument2, 'X');
        this.lockExpectException(locking, (byte)1, name1, argument3, 'X');
        logging.log("Commit transaction");
        this.endTransaction(true);
        logging.log("");
        logging.log("Begin transaction");
        this.beginTransaction();
        logging.log("Create several previously conflicting locks");
        locking.lock((byte)1, name1, argument1, 'X');
        locking.lock((byte)1, name1, argument2, 'X');
        locking.lock((byte)1, name1, argument3, 'X');
        this.cleanupLocks(logging, locking);
        logging.log("Create several locks of all types");
        locking.lock((byte)1, name1, argument1, 'S');
        locking.lock((byte)1, name1, argument1, 'S');
        locking.lock((byte)1, name1, argument1, 'S');
        locking.lock((byte)1, name1, argument2, 'E');
        locking.lock((byte)1, name1, argument2, 'E');
        locking.lock((byte)1, name1, argument2, 'E');
        locking.lock((byte)1, name1, argument3, 'X');
        logging.log("Create several conflicting locks -> expect exception");
        this.lockExpectException(locking, (byte)1, name1, argument1, 'X');
        this.lockExpectException(locking, (byte)1, name1, argument2, 'X');
        this.lockExpectException(locking, (byte)1, name1, argument3, 'X');
        logging.log("Rollback transaction");
        this.endTransaction(false);
        logging.log("");
        logging.log("Create exclusive lock outside transaction -> expect exception");
        this.lockExpectTechnicalException(locking, (byte)1, name1, argument1, 'S');
        logging.log("Begin transaction");
        this.beginTransaction();
        logging.log("Create several previously conflicting locks");
        locking.lock((byte)1, name1, argument1, 'X');
        locking.lock((byte)1, name1, argument2, 'X');
        locking.lock((byte)1, name1, argument3, 'X');
    }

    private void cleanupLocks(TestResult logging, LogicalLocking locking) throws Exception {
        logging.log("Remove all locks");
        locking.unlockAll((byte)1, false);
        logging.log("");
    }
}

