/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.gui;

import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.services.applocking.AppLockingRuntimeInterface;
import com.sap.engine.services.applocking.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import com.sap.engine.services.locking.test.TestResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;

public class RunTestsPanel
extends BasePanel
implements ActionListener {
    private AppLockingRuntimeInterface _locking;
    private JPanel _runTestsPanel;
    private JButton _runFunctionalTestsButton;
    private JButton _runLoadTestsButton;
    private JTextArea _runTestsResultName;

    public RunTestsPanel(AppLockingRuntimeInterface locking) {
        this._locking = locking;
        this._runFunctionalTestsButton = ComponentFactory.createButton("Execute functional tests", this, "Executes several tests, which check if the locking is working correctly");
        this._runLoadTestsButton = ComponentFactory.createButton("Execute load tests", this, "Executes several tests, which perform load-tests (e.g. create thousands of locks)");
        JPanel buttons = ComponentFactory.createHorizontalGridPanel(new JComponent[]{this._runFunctionalTestsButton, this._runLoadTestsButton});
        this._runTestsResultName = ComponentFactory.createTextArea(null);
        JScrollPane scrollableResultName = new JScrollPane(this._runTestsResultName);
        CompoundBorder border = BorderFactory.createCompoundBorder(ComponentFactory.STANDARD_LINE_BORDER, BorderFactory.createEtchedBorder(1));
        scrollableResultName.setBorder(border);
        this._runTestsPanel = ComponentFactory.createVerticalPanel(buttons, scrollableResultName, null);
        this.setLayout(new BorderLayout());
        this.add((Component)this._runTestsPanel, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._runFunctionalTestsButton) {
                this.runTests(false, true);
            } else if (source == this._runLoadTestsButton) {
                this.runTests(true, false);
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    private void runTests(boolean nofunctional, boolean noload) throws TechnicalLockException {
        long start = System.currentTimeMillis();
        TestResult[] result = this._locking.runTests(nofunctional, noload);
        StringBuffer logBuffer = new StringBuffer(4096);
        int successfulTests = 0;
        int i = 0;
        while (i < result.length) {
            logBuffer.append(result[i].getLog());
            logBuffer.append("\n\n\n\n");
            if (result[i].getException() == null) {
                ++successfulTests;
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        String log = BasePanel.UTIL.replaceChars(logBuffer.toString(), '\t', "    ");
        this._runTestsResultName.setText(log);
        if (successfulTests == result.length) {
            this.displayMessage("Success", "All " + result.length + " tests finished successfully (" + (end - start) + " milliseconds)");
        } else {
            this.displayMessage("Error", "ERROR:\nOnly " + successfulTests + " of " + result.length + " tests finished successfully (" + (end - start) + " milliseconds)");
        }
    }
}

