/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.gui;

import com.sap.engine.lib.text.FastDateFormat;
import com.sap.engine.services.applocking.LifetimeDescription;
import com.sap.engine.services.applocking.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LifetimeDescriptionDetailPanel
extends BasePanel {
    private static final FastDateFormat DATEFORMAT = new FastDateFormat("yyyy-MM-dd HH:mm:ss", false);
    private static final int VISIBLE_COLUMNS = 58;
    private JPanel _detailPanel;
    private JLabel _detailLifetimeLabel;
    private JTextField _detailLifetimeField;
    private JLabel _detailUserLabel;
    private JTextField _detailUserField;
    private JLabel _detailCreatedLabel;
    private JTextField _detailCreatedField;
    private JLabel _detailChangedLabel;
    private JTextField _detailChangedField;
    private JLabel _detailOwnerLabel;
    private JTextField _detailOwnerField;

    public LifetimeDescriptionDetailPanel(LifetimeDescription lifetimeDescription) {
        this.initializeDetailPanel();
        this.displayLifetimeDescription(lifetimeDescription);
    }

    private void initializeDetailPanel() {
        this._detailLifetimeField = ComponentFactory.createTextField(58, -1, "The lifetime");
        this._detailUserField = ComponentFactory.createTextField(58, -1, "The user-name");
        this._detailCreatedField = ComponentFactory.createTextField(58, -1, "The creation-time");
        this._detailChangedField = ComponentFactory.createTextField(58, -1, "The last-changed-time");
        this._detailOwnerField = ComponentFactory.createTextField(58, -1, "The owner");
        this._detailLifetimeField.setEditable(false);
        this._detailUserField.setEditable(false);
        this._detailCreatedField.setEditable(false);
        this._detailChangedField.setEditable(false);
        this._detailOwnerField.setEditable(false);
        this._detailLifetimeLabel = new JLabel("Lifetime:");
        this._detailUserLabel = new JLabel("User:");
        this._detailCreatedLabel = new JLabel("Created:");
        this._detailChangedLabel = new JLabel("Changed:");
        this._detailOwnerLabel = new JLabel("Owner:");
        JLabel[] labels = new JLabel[]{this._detailLifetimeLabel, this._detailUserLabel, this._detailCreatedLabel, this._detailChangedLabel, this._detailOwnerLabel};
        JComponent[] components = new JComponent[]{this._detailLifetimeField, this._detailUserField, this._detailCreatedField, this._detailChangedField, this._detailOwnerField};
        this._detailPanel = ComponentFactory.createLabeledGridPanel(labels, components);
        this.setLayout(new BorderLayout());
        this.add((Component)this._detailPanel, "North");
    }

    private void displayLifetimeDescription(LifetimeDescription lifetimeDescription) {
        this._detailLifetimeField.setText(BasePanel.getDescriptionForLifetime(lifetimeDescription.getLifetime()));
        this._detailUserField.setText(lifetimeDescription.getUser());
        this._detailCreatedField.setText(this.formatDate(lifetimeDescription.getCreationTime()));
        this._detailChangedField.setText(this.formatDate(lifetimeDescription.getLastChangeTime()));
        this._detailOwnerField.setText(lifetimeDescription.getOwner());
        this._detailLifetimeField.setCaretPosition(0);
        this._detailUserField.setCaretPosition(0);
        this._detailCreatedField.setCaretPosition(0);
        this._detailChangedField.setCaretPosition(0);
        this._detailOwnerField.setCaretPosition(0);
    }

    private String formatDate(long millis) {
        byte[] result = new byte[DATEFORMAT.getLength()];
        DATEFORMAT.getDate(result, 0);
        return new String(result);
    }
}

