/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking;

import com.sap.dictionary.database.catalog.CatalogReaderAccess;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.TimeStatistics;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.util.NotSupportedException;
import com.sap.engine.services.applocking.AbstractBaseLocking;
import com.sap.engine.services.applocking.LifetimeDescription;
import com.sap.engine.services.applocking.TableLocking;
import com.sap.engine.services.applocking.TableLockingConnectionEventListener;
import com.sap.engine.services.applocking.exception.AppLockingTechnicalLockException;
import com.sap.engine.services.applocking.exception.SAPAppLockingIllegalArgumentException;
import com.sap.engine.services.dbpool.cci.ConnectionHandle;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.services.OpenSQLServices;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class TableLockingImpl
extends AbstractBaseLocking
implements TableLocking {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$applocking$TableLockingImpl == null ? (class$com$sap$engine$services$applocking$TableLockingImpl = TableLockingImpl.class$("com.sap.engine.services.applocking.TableLockingImpl")) : class$com$sap$engine$services$applocking$TableLockingImpl));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    private static final String NAMESPACE = "%";
    private static final String NAMESPACE_DESCRIPTION = "TableLocking interface, which is used to lock rows of tables";
    private static final int BOOLEAN_LEN = 1;
    private static final int BYTE_LEN = 4;
    private static final int SHORT_LEN = 6;
    private static final int INTEGER_LEN = 11;
    private static final int LONG_LEN = 20;
    private static final int FLOAT_LEN = 13;
    private static final int DOUBLE_LEN = 22;
    private static final int CHARACTER_LEN = 1;
    private static final int DATE_LEN = 10;
    private static final int TIME_LEN = 8;
    private static final int TIMESTAMP_LEN = 29;
    private static final String BOOLEAN_CHARACTER_VALUE_TRUE = "X";
    private static final String BOOLEAN_CHARACTER_VALUE_FALSE = " ";
    private static final String BOOLEAN_NUMERIC_VALUE_TRUE = "1";
    private static final String BOOLEAN_NUMERIC_VALUE_FALSE = "0";
    private static final int MAX_NAME_LENGTH_FREE = 30 - "%".length() - 6 - 6;
    private static final int MAX_ARGUMENT_LENGTH_FREE = 144;
    static /* synthetic */ Class class$com$sap$engine$services$applocking$TableLockingImpl;

    public TableLockingImpl(TimeStatistics timeStatistics, LockingContext lockingContext, TransactionManager transactionManager, ThreadSystem threadSystem) throws TechnicalLockException, IllegalArgumentException {
        super(timeStatistics, lockingContext, transactionManager, threadSystem);
        AbstractBaseLocking._lockingContext.getAdministrativeLocking().reserveNamespace(NAMESPACE, NAMESPACE_DESCRIPTION);
        String METHOD = "<init>";
        LOCATION.pathT(METHOD, "success");
    }

    public void lock(byte lifetime, Connection connection, String tableName, Map primaryKeys, char mode, int timeout) throws LockException, TechnicalLockException, IllegalArgumentException {
        String METHOD = "lock(lifetime, connection, table, primaryKey, mode, int)";
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}, table={2}, mode={3}, timeout={4}", new Object[]{new Byte(lifetime), connection, tableName, new Character(mode), new Integer(timeout)});
        String name = this.getName(connection, tableName);
        String argument = this.getArgument(connection, tableName, primaryKeys);
        this.lockInternal(lifetime, connection, name, argument, mode, timeout);
        LOCATION.pathT(METHOD, "success");
    }

    public void lock(byte lifetime, Connection connection, String tableName, Map primaryKeys, char mode) throws LockException, TechnicalLockException, IllegalArgumentException {
        this.lock(lifetime, connection, tableName, primaryKeys, mode, 0);
    }

    public void unlock(byte lifetime, Connection connection, String tableName, Map primaryKeys, char mode) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, connection, table, primaryKey, mode)";
        LOCATION.pathT(METHOD, "lifetime={0}, table={1}, mode={2}", new Object[]{new Byte(lifetime), tableName, new Character(mode)});
        String name = this.getName(connection, tableName);
        String argument = this.getArgument(connection, tableName, primaryKeys);
        this.unlockInternal(lifetime, connection, name, argument, mode, false);
        LOCATION.pathT(METHOD, "success");
    }

    public void unlock(byte lifetime, Connection connection, String tableName, Map primaryKeys, char mode, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, connection, table, primaryKey, mode, asynchronous)";
        LOCATION.pathT(METHOD, "lifetime={0}, table={1}, mode={2}, asynchronous={3}", new Object[]{new Byte(lifetime), tableName, new Character(mode), new Boolean(asynchronous)});
        String name = this.getName(connection, tableName);
        String argument = this.getArgument(connection, tableName, primaryKeys);
        this.unlockInternal(lifetime, connection, name, argument, mode, asynchronous);
        LOCATION.pathT(METHOD, "success");
    }

    public void assertLifetime(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "assertLifetime(lifetime)";
        long TIMESTATISTICS = AbstractBaseLocking._timeStatistics.startMeasurement(2);
        LOCATION.debugT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        this.checkServiceState();
        try {
            this.getObjectForLifetime(lifetime);
        }
        catch (AppLockingTechnicalLockException atle) {
            throw new NotSupportedException("Not supported for local transactions");
        }
        AbstractBaseLocking._timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "assert lifetime");
        LOCATION.pathT(METHOD, "success");
    }

    public String getCurrentOwner(byte lifetime, Connection connection) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "getCurrentOwner(lifetime)";
        long TIMESTATISTICS = AbstractBaseLocking._timeStatistics.startMeasurement(2);
        LOCATION.debugT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        String result = this.getCurrentLifetimeDescription(lifetime, connection).getOwner();
        AbstractBaseLocking._timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "get owner for lifetime");
        LOCATION.pathT(METHOD, "result={0}", new Object[]{result});
        return result;
    }

    public String getCurrentOwner(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "getCurrentOwner(lifetime)";
        long TIMESTATISTICS = AbstractBaseLocking._timeStatistics.startMeasurement(2);
        LOCATION.debugT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        this.checkServiceState();
        Object o = null;
        try {
            o = this.getObjectForLifetime(lifetime);
        }
        catch (AppLockingTechnicalLockException atle) {
            throw new NotSupportedException("Not supported for local transactions. Please use corresponding operation with Connection as parameter.");
        }
        LifetimeDescription description = lifetime == 1 ? this.getLifetimeDescriptionForTransaction((Transaction)o) : this.getLifetimeDescriptionForSession((SecuritySession)o);
        description.modifyLastChangeTime();
        String result = description.getOwner();
        AbstractBaseLocking._timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "get owner for lifetime");
        LOCATION.pathT(METHOD, "result={0}", new Object[]{result});
        return result;
    }

    protected ManagedConnection getManagedConnection(Connection connection) throws AppLockingTechnicalLockException {
        String METHOD = "getManagedConnection(Connection)";
        ConnectionHandle connectionHandle = null;
        try {
            connectionHandle = (ConnectionHandle)connection;
        }
        catch (Exception e) {
            throw new AppLockingTechnicalLockException("applocking1014");
        }
        ManagedConnection managedConnection = connectionHandle.getManagedConnection();
        return managedConnection;
    }

    protected Object getObjectForLifetime(byte lifetime, Connection connection) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "getObjectForLifetime(lifetime, connection)";
        Object result = null;
        if (lifetime == 1) {
            try {
                result = this.getObjectForLifetime(lifetime);
                return result;
            }
            catch (AppLockingTechnicalLockException atle) {
                if (connection == null) {
                    throw new AppLockingTechnicalLockException("applocking_1012");
                }
                boolean localTransactionOpen = false;
                try {
                    localTransactionOpen = !connection.getAutoCommit();
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
                if (localTransactionOpen) {
                    result = this.getManagedConnection(connection);
                    return result;
                }
                throw new AppLockingTechnicalLockException("applocking_1012");
            }
        }
        ThreadContext currentThreadContext = AbstractBaseLocking._threadSystem.getThreadContext();
        LOCATION.pathT(METHOD, "currentThreadContext={0}", new Object[]{currentThreadContext});
        if (currentThreadContext == null) {
            throw new AppLockingTechnicalLockException("applocking_1003");
        }
        SecuritySession currentSession = ((SecurityContextObject)((Object)currentThreadContext.getContextObject("security"))).getSession();
        return currentSession;
    }

    protected TableLockingConnectionEventListener getLifetimeDescriptionForTransaction(ManagedConnection managedConnection) throws TechnicalLockException {
        int[] nArray = AbstractBaseLocking.lifetimeStructureLock;
        synchronized (nArray) {
            String METHOD = "getLifetimeDescriptionForTransaction(transaction)";
            TableLockingConnectionEventListener description = (TableLockingConnectionEventListener)AbstractBaseLocking._lifetimeDescriptions.get(managedConnection);
            if (description == null) {
                LOCATION.pathT(METHOD, "will register ConnectionEventListener for new local transaction");
                String owner = AbstractBaseLocking._lockingContext.getAdministrativeLocking().createUniqueOwner();
                description = new TableLockingConnectionEventListener(this, owner, managedConnection);
                LOCATION.pathT(METHOD, "user={0}, owner={1}", new Object[]{description.getUser(), description.getOwner()});
                managedConnection.addConnectionEventListener((ConnectionEventListener)description);
                LOCATION.pathT(METHOD, "successfully registered in TransactionManager");
                AbstractBaseLocking._lifetimeDescriptions.put(managedConnection, description);
                AbstractBaseLocking._lifetimeDescriptionsReverse.put(description, managedConnection);
            }
            TableLockingConnectionEventListener tableLockingConnectionEventListener = description;
            return tableLockingConnectionEventListener;
        }
    }

    private String getName(Connection connection, String tableName) throws TechnicalLockException {
        int tableNameLength = tableName.length();
        StringBuffer result = new StringBuffer(30);
        result.append(NAMESPACE);
        if (tableNameLength <= MAX_NAME_LENGTH_FREE) {
            result.append(tableName);
            int i = tableNameLength;
            while (i < MAX_NAME_LENGTH_FREE + 6) {
                result.append(' ');
                ++i;
            }
        } else {
            String tail = tableName.substring(MAX_NAME_LENGTH_FREE);
            result.append(tableName.substring(0, MAX_NAME_LENGTH_FREE));
            Base64.encode(tail.hashCode(), result);
        }
        try {
            String connectionIdString = OpenSQLServices.getConnectionID((Connection)connection);
            Base64.encode(connectionIdString.hashCode(), result);
        }
        catch (SQLException e) {
            Base64.encode(0, result);
        }
        return result.toString();
    }

    private String getArgument(Connection connection, String tableName, Map primaryKeys) throws TechnicalLockException {
        CatalogReader catalogReader = this.getCatalogReader(connection);
        try {
            Table table = this.getTable(catalogReader, tableName);
            int primaryKeyCnt = table.getPrimaryKeyCnt();
            if (primaryKeyCnt != primaryKeys.size()) {
                throw new SAPAppLockingIllegalArgumentException("applocking_1100");
            }
            Object[] values = new Object[primaryKeyCnt];
            int[] types = new int[primaryKeyCnt];
            int[] lengths = new int[primaryKeyCnt];
            Set entrySet = primaryKeys.entrySet();
            Iterator i = entrySet.iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String columnName = null;
                Column column = null;
                try {
                    columnName = (String)entry.getKey();
                }
                catch (ClassCastException e) {
                    throw new SAPAppLockingIllegalArgumentException("applocking_1100");
                }
                column = table.getColumn(columnName);
                if (column == null) {
                    throw new SAPAppLockingIllegalArgumentException("applocking_1102", new Object[]{columnName, tableName});
                }
                if (!column.isPrimaryKey()) {
                    throw new SAPAppLockingIllegalArgumentException("applocking_1103", new Object[]{column.getName(), column.getTable().getName()});
                }
                if (!column.getTable().getName().equals(table.getName())) {
                    throw new SAPAppLockingIllegalArgumentException("applocking_1104", new Object[]{column.getName(), column.getTable().getName(), table.getName()});
                }
                int position = column.getPrimaryKeyPosition() - 1;
                if (position < 0 || position >= primaryKeyCnt) {
                    throw new SAPAppLockingIllegalArgumentException("applocking_1105");
                }
                values[position] = entry.getValue();
                types[position] = column.getJdbcType();
                long length = column.getSize();
                int n = lengths[position] = length < Integer.MAX_VALUE ? (int)length : Integer.MAX_VALUE;
            }
            String string = this.concatenate(values, types, lengths);
            Object var19_18 = null;
            this.releaseCatalogReader(catalogReader);
            return string;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            this.releaseCatalogReader(catalogReader);
            throw throwable;
        }
    }

    private String concatenate(Object[] values, int[] types, int[] lengths) throws TechnicalLockException {
        int concatenationLength = 0;
        int i = 0;
        while (i < values.length) {
            Object value = values[i];
            int type = types[i];
            switch (type) {
                case -7: {
                    lengths[i] = 1;
                    break;
                }
                case -6: {
                    lengths[i] = 4;
                    break;
                }
                case 5: {
                    lengths[i] = 6;
                    break;
                }
                case 4: {
                    lengths[i] = 11;
                    break;
                }
                case -5: {
                    lengths[i] = 20;
                    break;
                }
                case 7: {
                    lengths[i] = 13;
                    break;
                }
                case 6: 
                case 8: {
                    lengths[i] = 22;
                    break;
                }
                case 91: {
                    lengths[i] = 10;
                    break;
                }
                case 92: {
                    lengths[i] = 8;
                    break;
                }
                case 93: {
                    lengths[i] = 29;
                }
            }
            concatenationLength += lengths[i];
            ++i;
        }
        StringBuffer result = new StringBuffer(concatenationLength);
        int i2 = 0;
        while (i2 < values.length) {
            Object value = values[i2];
            int type = types[i2];
            int length = lengths[i2];
            if (value == null) {
                int j = 0;
                while (j < length) {
                    result.append('@');
                    ++j;
                }
            } else if (value instanceof String) {
                this.appendAdjusted(type, (String)value, length, result);
            } else if (value instanceof char[]) {
                this.appendAdjusted(type, new String((char[])value), length, result);
            } else if (value instanceof Character) {
                if (this.isNumeric(type)) {
                    this.appendRightAdjusted(new Integer(((Character)value).charValue()).toString(), length, result);
                } else {
                    this.appendLeftAdjusted(((Character)value).toString(), length, result);
                }
            } else if (value instanceof byte[]) {
                this.appendAdjusted(type, new String((byte[])value), length, result);
            } else if (value instanceof Byte) {
                if (this.isNumeric(type)) {
                    this.appendRightAdjusted(((Byte)value).toString(), length, result);
                } else {
                    this.appendLeftAdjusted(new String(new byte[]{(Byte)value}), length, result);
                }
            } else if (value instanceof Number) {
                this.appendAdjusted(type, value.toString(), length, result);
            } else if (value instanceof Boolean) {
                boolean booleanValue = (Boolean)value;
                if (this.isNumeric(type)) {
                    this.appendRightAdjusted(booleanValue ? BOOLEAN_NUMERIC_VALUE_TRUE : BOOLEAN_NUMERIC_VALUE_FALSE, length, result);
                } else {
                    this.appendLeftAdjusted(booleanValue ? BOOLEAN_CHARACTER_VALUE_TRUE : BOOLEAN_CHARACTER_VALUE_FALSE, length, result);
                }
            } else if (value instanceof Date || value instanceof Time || value instanceof Timestamp) {
                this.appendLeftAdjusted(value.toString(), length, result);
            } else {
                throw new SAPAppLockingIllegalArgumentException("applocking_1107", new Object[]{value.getClass().getName()});
            }
            ++i2;
        }
        if (concatenationLength != result.length()) {
            throw new AppLockingTechnicalLockException("applocking_1007", new Object[]{new Integer(concatenationLength), new Integer(result.length())});
        }
        if (concatenationLength <= 144) {
            return result.toString();
        }
        String tail = result.substring(144);
        result.setLength(144);
        Base64.encode(tail.hashCode(), result);
        return result.toString();
    }

    private void appendAdjusted(int type, String value, int length, StringBuffer result) {
        if (this.isNumeric(type)) {
            this.appendRightAdjusted(value, length, result);
        } else {
            this.appendLeftAdjusted(value, length, result);
        }
    }

    private void appendLeftAdjusted(String value, int length, StringBuffer result) {
        int valueLength = value.length();
        if (valueLength == length) {
            result.append(value);
        } else if (valueLength > length) {
            result.append(value.substring(0, length));
        } else {
            result.append(value);
            int j = valueLength;
            while (j < length) {
                result.append(' ');
                ++j;
            }
        }
    }

    private void appendRightAdjusted(String value, int length, StringBuffer result) {
        int valueLength = value.length();
        if (valueLength == length) {
            result.append(value);
        } else if (valueLength > length) {
            result.append(value.substring(valueLength - length, valueLength));
        } else {
            int j = valueLength;
            while (j < length) {
                result.append(' ');
                ++j;
            }
            result.append(value);
        }
    }

    private boolean isNumeric(int type) {
        return type == -6 || type == 5 || type == 4 || type == -5 || type == 7 || type == 6 || type == 8 || type == 2 || type == -7 || type == 3;
    }

    private Table getTable(CatalogReader catalogReader, String tableName) throws TechnicalLockException {
        Table result = null;
        try {
            result = catalogReader.getTable(tableName);
        }
        catch (SQLException e) {
            throw new AppLockingTechnicalLockException("applocking_1008", new Object[]{tableName}, e);
        }
        if (result == null) {
            throw new AppLockingTechnicalLockException("applocking_1008", new Object[]{tableName});
        }
        return result;
    }

    private CatalogReader getCatalogReader(Connection connection) throws TechnicalLockException {
        try {
            CatalogReader result = CatalogReaderAccess.getCatalogReader((Connection)connection);
            if (result == null) {
                throw new AppLockingTechnicalLockException("applocking_1010");
            }
            return result;
        }
        catch (Exception e) {
            throw new AppLockingTechnicalLockException("applocking_1010", e);
        }
    }

    private void releaseCatalogReader(CatalogReader catalogReader) {
        CatalogReaderAccess.releaseCatalogReader((CatalogReader)catalogReader);
    }

    public void unlockAll(byte lifetime, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        this.unlockAll(lifetime, null, asynchronous);
    }

    public void unlockAll(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        this.unlockAll(lifetime, null);
    }

    public void unlockAll(byte lifetime, Connection connection, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        this.unlockAllInternal(lifetime, connection, asynchronous);
    }

    public void unlockAll(byte lifetime, Connection connection) throws TechnicalLockException, IllegalArgumentException {
        this.unlockAllInternal(lifetime, connection);
    }

    LifetimeDescription getCurrentLifetimeDescription(byte lifetime, Connection connection) throws TechnicalLockException, IllegalArgumentException {
        this.checkServiceState();
        Object o = this.getObjectForLifetime(lifetime, connection);
        LifetimeDescription description = null;
        if (lifetime == 1) {
            if (o instanceof Transaction) {
                description = this.getLifetimeDescriptionForTransaction((Transaction)o);
            } else if (o instanceof ManagedConnection) {
                description = this.getLifetimeDescriptionForTransaction((ManagedConnection)o);
            }
        } else {
            description = this.getLifetimeDescriptionForSession((SecuritySession)o);
        }
        description.modifyLastChangeTime();
        return description;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Base64 {
        public static final int LEN = 6;
        private static final char EQUALS_SIGN = '=';
        private static final char[] ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        Base64() {
        }

        public static void encode(int value, StringBuffer buffer) {
            int pos = buffer.length();
            buffer.setLength(pos + 6);
            buffer.setCharAt(pos + 5, ALPHABET[(value & 3) << 4]);
            buffer.setCharAt(pos + 4, ALPHABET[(value >>>= 2) & 0x3F]);
            buffer.setCharAt(pos + 3, ALPHABET[(value >>>= 6) & 0x3F]);
            buffer.setCharAt(pos + 2, ALPHABET[(value >>>= 6) & 0x3F]);
            buffer.setCharAt(pos + 1, ALPHABET[(value >>>= 6) & 0x3F]);
            buffer.setCharAt(pos, ALPHABET[(value >>>= 6) & 0x3F]);
        }
    }
}

