/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking;

import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.interfaces.security.SessionListener;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.applocking.AbstractBaseLocking;
import com.sap.engine.services.applocking.LifetimeDescription;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.Serializable;

public class LogicalLockingSessionListener
extends LifetimeDescription
implements SessionListener,
Serializable {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$applocking$LogicalLockingSessionListener == null ? (class$com$sap$engine$services$applocking$LogicalLockingSessionListener = LogicalLockingSessionListener.class$("com.sap.engine.services.applocking.LogicalLockingSessionListener")) : class$com$sap$engine$services$applocking$LogicalLockingSessionListener));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    static /* synthetic */ Class class$com$sap$engine$services$applocking$LogicalLockingSessionListener;

    public LogicalLockingSessionListener(AbstractBaseLocking locking, String owner, SecuritySession session) {
        super(locking, owner, session, null, null);
    }

    public void onSessionLocallyRemoved() {
        super.onSessionLocallyRemoved();
        this.onUserLogOut();
    }

    public void onUserLogOut() {
        String METHOD = "onUserLogOut()";
        super.onUserLogOut();
        if (this.getIsDeactivated()) {
            return;
        }
        try {
            try {
                LOCATION.pathT(METHOD, "begin");
                LOCATION.pathT(METHOD, "user={0}, owner={1}", new Object[]{this.getUser(), this.getOwner()});
                this.getLocking().getLockingContext().getAdministrativeLocking().unlockAll(this.getOwner(), true);
                LOCATION.pathT(METHOD, "successfully removed all locks for owner");
            }
            catch (Exception e) {
                CATEGORY.errorT(LOCATION, METHOD, "Failed to remove all locks for owner {0}. They must be removed manually by the administrator.", new Object[]{this.getOwner()});
                LoggingHelper.traceThrowable(200, LOCATION, METHOD, e);
                Object var4_3 = null;
                this.getLocking().removeLifetimeDescription(this);
            }
            Object var4_2 = null;
            this.getLocking().removeLifetimeDescription(this);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getLocking().removeLifetimeDescription(this);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

