/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking;

import com.sap.engine.frame.core.locking.LockingConstants;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.interfaces.security.SessionListener;
import com.sap.engine.services.applocking.AbstractBaseLocking;
import java.io.Serializable;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Transaction;

public class LifetimeDescription
implements SessionListener,
LockingConstants,
Serializable {
    private transient AbstractBaseLocking _locking;
    private transient SecuritySession _session;
    private transient Transaction _transaction;
    private transient ManagedConnection _managedConnection;
    private boolean _isDeactivated = false;
    private String _owner;
    private String _user;
    private int _lifetime;
    private long _creationTime;
    private long _lastChangeTime;

    public LifetimeDescription(AbstractBaseLocking locking, String owner, SecuritySession session, Transaction transaction, ManagedConnection managedConnection) {
        ThreadContext currentThreadContext;
        this._locking = locking;
        this._owner = owner;
        this._session = session;
        this._transaction = transaction;
        this._managedConnection = managedConnection;
        if (this._session == null && (currentThreadContext = this._locking.getThreadSystem().getThreadContext()) != null) {
            this._session = ((SecurityContextObject)((Object)currentThreadContext.getContextObject("security"))).getSession();
        }
        this._user = this._session != null && this._session.getPrincipal() != null ? this._session.getPrincipal().getName() : "<app-system>";
        this._lifetime = this._transaction != null || this._managedConnection != null ? 1 : 2;
        this._lastChangeTime = this._creationTime = System.currentTimeMillis();
    }

    protected final void modifyLastChangeTime() {
        this._lastChangeTime = System.currentTimeMillis();
    }

    protected final AbstractBaseLocking getLocking() {
        return this._locking;
    }

    protected final SecuritySession getSecuritySession() {
        return this._session;
    }

    protected final Transaction getTransaction() {
        return this._transaction;
    }

    protected final ManagedConnection getManagedConnection() {
        return this._managedConnection;
    }

    protected void setIsDeactivated(boolean isDeactivated) {
        this._isDeactivated = isDeactivated;
    }

    protected boolean getIsDeactivated() {
        return this._isDeactivated;
    }

    public void onSessionLocallyRemoved() {
        this.onUserLogOut();
    }

    public void onUserLogOut() {
        this._session = null;
        this._user = "<logged out>";
    }

    public final long getCreationTime() {
        return this._creationTime;
    }

    public final long getLastChangeTime() {
        return this._lastChangeTime;
    }

    public final String getUser() {
        return this._user;
    }

    public final String getOwner() {
        return this._owner;
    }

    public final int getLifetime() {
        return this._lifetime;
    }
}

