/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.SAPLockingIllegalArgumentException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.TimeStatistics;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.applocking.AppLockingRuntimeInterface;
import com.sap.engine.services.applocking.AppLockingRuntimeInterfaceImpl;
import com.sap.engine.services.applocking.LogicalLockingFactory;
import com.sap.engine.services.applocking.command.DisplayOpenSessionsCommand;
import com.sap.engine.services.applocking.command.DisplayTimeStatisticsCommand;
import com.sap.engine.services.applocking.command.ResetTimeStatisticsCommand;
import com.sap.engine.services.applocking.command.RunTestsCommand;
import com.sap.engine.services.applocking.exception.AppLockingTechnicalLockException;
import com.sap.engine.services.applocking.test.AllTests;
import com.sap.engine.services.applocking.test.ILogicalLockingTest;
import com.sap.engine.services.locking.test.TestResult;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

public class AppLockingApplicationFrame
implements ApplicationServiceFrame,
ContainerEventListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$applocking$AppLockingApplicationFrame == null ? (class$com$sap$engine$services$applocking$AppLockingApplicationFrame = AppLockingApplicationFrame.class$("com.sap.engine.services.applocking.AppLockingApplicationFrame")) : class$com$sap$engine$services$applocking$AppLockingApplicationFrame));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    public static final String OWN_NAME = "applocking-service";
    private static final String JNDI_SERVICE_NAME = "naming";
    private static final String PROPERTY_TESTLEVEL = "testlevel";
    private static final String PROPERTY_TIMESTATISTICSLEVEL = "timestatisticslevel";
    private static final Util UTIL = new Util();
    private TimeStatistics _timeStatistics;
    private ApplicationServiceContext _applicationServiceContext;
    private LockingContext _lockingContext;
    private ThreadSystem _threadSystem;
    private SecurityContext _securityContext;
    private TransactionManager _transactionManager;
    private AppLockingRuntimeInterfaceImpl _lockingRuntimeInterface;
    private ShellInterface _shellInterface;
    private int _commandId;
    private int _testlevel;
    private boolean _serviceIsRunning = false;
    static /* synthetic */ Class class$com$sap$engine$services$applocking$AppLockingApplicationFrame;

    public AppLockingRuntimeInterface getRuntimeInterface() throws TechnicalLockException {
        return this._lockingRuntimeInterface;
    }

    public LockingContext getLockingContext() {
        return this._lockingContext;
    }

    public ThreadSystem getThreadSystem() {
        return this._threadSystem;
    }

    public SecurityContext getSecurityContext() throws TechnicalLockException {
        this.checkServiceState();
        return this._securityContext;
    }

    public TransactionManager getTransactionManager() throws TechnicalLockException {
        this.checkServiceState();
        return this._transactionManager;
    }

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        String METHOD = "start(serviceContext)";
        this._applicationServiceContext = serviceContext;
        try {
            this._serviceIsRunning = true;
            LOCATION.pathT(METHOD, "begin");
            Properties properties = this._applicationServiceContext.getServiceState().getProperties();
            this._timeStatistics = new TimeStatistics();
            if (this._timeStatistics.getInitializationFailure() != null) {
                LOCATION.pathT(METHOD, "Failed to init the time-statistics correctly. As a fallback the times will be measured with a granularity of milliseconds instead of microseconds. Reason for the failure: {0}", new Object[]{this._timeStatistics.getInitializationFailure().toString()});
                LoggingHelper.traceThrowable(200, LOCATION, METHOD, this._timeStatistics.getInitializationFailure());
            }
            LOCATION.pathT(METHOD, "initialized TimeStatistics");
            this._lockingContext = this._applicationServiceContext.getCoreContext().getLockingContext();
            LOCATION.pathT(METHOD, "got access to LockingContext");
            this._threadSystem = this._applicationServiceContext.getCoreContext().getThreadSystem();
            LOCATION.pathT(METHOD, "got access to ThreadSystem");
            this._securityContext = (SecurityContext)this._applicationServiceContext.getContainerContext().getObjectRegistry().getServiceInterface("security");
            LOCATION.pathT(METHOD, "got access to SecurityContext");
            this._transactionManager = (TransactionManager)this._applicationServiceContext.getContainerContext().getObjectRegistry().getServiceInterface("ts");
            LOCATION.pathT(METHOD, "got access to TransactionManager");
            this.parseProperties(properties);
            this._lockingRuntimeInterface = new AppLockingRuntimeInterfaceImpl(this, this._timeStatistics, serviceContext);
            LOCATION.pathT(METHOD, "created AppLockingRuntimeInterfaceImpl");
            int mask = 196;
            HashSet<String> names = new HashSet<String>(1);
            names.add("shell");
            serviceContext.getServiceState().registerContainerEventListener(mask, names, this);
            serviceContext.getContainerContext().getObjectRegistry().registerInterface(this._lockingRuntimeInterface);
            serviceContext.getServiceState().registerManagementInterface(this._lockingRuntimeInterface);
            LOCATION.pathT(METHOD, "registered in server");
            this.bindToNaming(false);
            this.runTests(this._testlevel);
            CATEGORY.infoT(LOCATION, METHOD, "{0} started successfully", new Object[]{OWN_NAME});
        }
        catch (Exception e) {
            this._serviceIsRunning = false;
            CATEGORY.fatalT(LOCATION, METHOD, "Can not start {0}. Applications which use this service functionality may not work properly. Please try to start the service manually.", new Object[]{OWN_NAME});
            LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, e);
            try {
                this.stop();
            }
            catch (Exception x) {
                // empty catch block
            }
            throw new ServiceException("kernel_6000", new Object[]{OWN_NAME}, null);
        }
    }

    public void stop() throws ServiceRuntimeException {
        String METHOD = "stop()";
        try {
            boolean problemOccured = false;
            try {
                LOCATION.pathT(METHOD, "begin");
                this._applicationServiceContext.getContainerContext().getObjectRegistry().unregisterInterface();
                this._applicationServiceContext.getServiceState().unregisterContainerEventListener();
            }
            catch (Exception e) {
                problemOccured = true;
                CATEGORY.errorT(LOCATION, METHOD, "can not cleanup {0} correctly when trying to stop it", new Object[]{OWN_NAME});
                LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, e);
            }
            try {
                if (this._lockingRuntimeInterface != null) {
                    this._lockingRuntimeInterface.stop();
                }
            }
            catch (Exception e) {
                problemOccured = true;
                CATEGORY.errorT(LOCATION, METHOD, "can not cleanup {0} correctly when trying to stop it", new Object[]{OWN_NAME});
                LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, e);
            }
            try {
                this.unsetShellInterface();
                this.unbindFromNaming(false);
            }
            catch (Exception e) {
                problemOccured = true;
                CATEGORY.errorT(LOCATION, METHOD, "can not cleanup {0} correctly when trying to stop it", new Object[]{OWN_NAME});
                LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, e);
            }
            CATEGORY.infoT(LOCATION, METHOD, "{0} stopped successfully", new Object[]{OWN_NAME});
            if (problemOccured) {
                throw new ServiceRuntimeException("kernel_6050", new Object[]{OWN_NAME}, null);
            }
            Object var5_7 = null;
            this._serviceIsRunning = false;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this._serviceIsRunning = false;
            throw throwable;
        }
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public boolean setServiceProperty(String key, String value) {
        Properties currentProperties = this._applicationServiceContext.getServiceState().getProperties();
        Properties properties = (Properties)((Hashtable)currentProperties).clone();
        ((Hashtable)properties).put(key, value);
        return this.parseProperties(properties);
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return this.parseProperties(serviceProperties);
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        String METHOD = "serviceStarted(serviceName, serviceInterface)";
        LOCATION.pathT(METHOD, "serviceName={0}", new Object[]{serviceName});
        if (serviceName.equals(JNDI_SERVICE_NAME)) {
            try {
                this.bindToNaming(true);
            }
            catch (TechnicalLockException e) {
                throw new ServiceRuntimeException("kernel_6051", new Object[]{OWN_NAME, JNDI_SERVICE_NAME}, null);
            }
        }
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        String METHOD = "interfaceAvailable(interfaceName, interfaceImpl)";
        LOCATION.pathT(METHOD, "interfaceName={0}", new Object[]{interfaceName});
        if (interfaceName.equals("shell")) {
            this.setShellInterface((ShellInterface)interfaceImpl);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        String METHOD = "interfaceNotAvailable(interfaceName)";
        LOCATION.pathT(METHOD, "interfaceName={0}", new Object[]{interfaceName});
        if (interfaceName.equals("shell")) {
            this.unsetShellInterface();
        }
    }

    public void markForShutdown(long timeout) {
    }

    private void setShellInterface(ShellInterface shellInterface) {
        String METHOD = "setShellInterface(shellInterface)";
        LOCATION.pathT(METHOD, "begin");
        this._shellInterface = shellInterface;
        Command[] shellcommands = new Command[]{new DisplayTimeStatisticsCommand(this), new ResetTimeStatisticsCommand(this), new DisplayOpenSessionsCommand(this), new RunTestsCommand(this)};
        this._commandId = this._shellInterface.registerCommands(shellcommands);
        LOCATION.pathT(METHOD, "success");
    }

    private void unsetShellInterface() {
        String METHOD = "unsetShellInterface()";
        LOCATION.pathT(METHOD, "begin");
        if (this._shellInterface != null) {
            this._shellInterface.unregisterCommands(this._commandId);
        }
        this._shellInterface = null;
        LOCATION.pathT(METHOD, "success");
    }

    private void runTests(int testlevel) throws Exception {
        String METHOD = "runTests(testlevel)";
        LOCATION.pathT(METHOD, "testlevel={0}", new Object[]{new Integer(testlevel)});
        if (testlevel <= 0) {
            return;
        }
        long start = System.currentTimeMillis();
        if (testlevel >= 2) {
            this.runLogicalLockingTests(AllTests.getAllLogicalLockingTests());
        } else {
            this.runLogicalLockingTests(AllTests.getFunctionalLogicalLockingTests());
        }
        long end = System.currentTimeMillis();
        CATEGORY.infoT(LOCATION, METHOD, "All tests finished successfully ({0} milliseconds)", new Object[]{new Long(end - start)});
    }

    private void runLogicalLockingTests(ILogicalLockingTest[] test2) throws Exception {
        String METHOD = "runLockingContextTests(test)";
        CATEGORY.infoT(LOCATION, METHOD, "Start execution of {0} tests", new Object[]{new Integer(test2.length)});
        LogicalLockingFactory logicalLockingFactory = this._lockingRuntimeInterface.getLogicalLockingFactory();
        int i = 0;
        while (i < test2.length) {
            LOCATION.pathT(METHOD, "start test {0}", new Object[]{test2[i]});
            TestResult result = test2[i].start(this._lockingContext, this._threadSystem, this._securityContext, logicalLockingFactory, this._transactionManager, null);
            if (result.getException() != null) {
                CATEGORY.errorT(LOCATION, METHOD, result.getLog());
                throw new TechnicalLockException("kernel_1026", new Object[]{new Integer(i), test2[i].getName()}, result.getException());
            }
            LOCATION.pathT(METHOD, "Test {0} finished successfully", new Object[]{test2[i].getName()});
            LOCATION.pathT(METHOD, result.getLog());
            ++i;
        }
    }

    private void unbindFromNaming(boolean expectNamingAvailable) throws TechnicalLockException {
        String METHOD = "unbindFromNaming(expectNamingAvailable)";
        try {
            InitialContext jndi = this.getInitialContext(expectNamingAvailable);
            if (jndi == null) {
                return;
            }
            jndi.unbind("LogicalLockingFactory");
            jndi.unbind("TableLocking");
            CATEGORY.infoT(LOCATION, METHOD, "Successfully unbound {0} from JNDI", new Object[]{OWN_NAME});
        }
        catch (NamingException e) {
            throw new AppLockingTechnicalLockException("applocking_1000", new Object[]{OWN_NAME}, e);
        }
    }

    private void bindToNaming(boolean expectNamingAvailable) throws TechnicalLockException {
        String METHOD = "bindToNaming(expectNamingAvailable)";
        try {
            InitialContext jndi = this.getInitialContext(expectNamingAvailable);
            if (jndi == null) {
                return;
            }
            jndi.rebind("LogicalLockingFactory", (Object)this._lockingRuntimeInterface.getLogicalLockingFactory());
            jndi.rebind("TableLocking", (Object)this._lockingRuntimeInterface.getTableLocking());
            CATEGORY.infoT(LOCATION, METHOD, "Successfully bound {0} in JNDI", new Object[]{OWN_NAME});
        }
        catch (Exception e) {
            throw new AppLockingTechnicalLockException("applocking_1001", new Object[]{OWN_NAME}, e);
        }
    }

    private InitialContext getInitialContext(boolean expectNamingAvailable) throws NamingException {
        String METHOD = "getInitialContext(expectNamingAvailable)";
        LOCATION.pathT(METHOD, "expectNamingAvailable={0}", new Object[]{new Boolean(expectNamingAvailable)});
        try {
            InitialContext jndi = new InitialContext();
            LOCATION.pathT(METHOD, "success");
            return jndi;
        }
        catch (NamingException e) {
            LOCATION.pathT(METHOD, "exception={0}", new Object[]{e});
            if (expectNamingAvailable) {
                throw e;
            }
            return null;
        }
    }

    private boolean parseProperties(Properties properties) throws IllegalArgumentException {
        String METHOD = "changeProperties(properties)";
        try {
            boolean propertiesActiveWithoutRestart = true;
            LOCATION.debugT(METHOD, "properties={0}", new Object[]{properties});
            LOCATION.pathT(METHOD, "begin");
            Integer testlevelObject = UTIL.getIntegerProperty(properties, PROPERTY_TESTLEVEL, 0, Integer.MAX_VALUE, false);
            this._testlevel = testlevelObject == null ? 0 : testlevelObject;
            Integer timestatisticslevelObject = UTIL.getIntegerProperty(properties, PROPERTY_TIMESTATISTICSLEVEL, 0, Integer.MAX_VALUE, false);
            this._timeStatistics.setTimeStatisticsLevel(timestatisticslevelObject == null ? 0 : timestatisticslevelObject);
            CATEGORY.infoT(LOCATION, METHOD, "Properties of {0} changed successfully", new Object[]{OWN_NAME});
            return propertiesActiveWithoutRestart;
        }
        catch (Exception e) {
            SAPLockingIllegalArgumentException wrappedException = new SAPLockingIllegalArgumentException("kernel_1059", new Object[]{OWN_NAME, e.toString()});
            LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, (Throwable)((Object)wrappedException));
            throw wrappedException;
        }
    }

    public void checkServiceState() throws TechnicalLockException {
        if (!this._serviceIsRunning) {
            throw new AppLockingTechnicalLockException("applocking_1002", new Object[]{this, OWN_NAME});
        }
    }

    protected Properties reloadProperties() {
        Properties props = this._applicationServiceContext.getServiceState().getProperties();
        this.parseProperties(props);
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

