/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.appclient.server;

import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.appclient.AppClientResourceAccessor;
import com.sap.engine.services.appclient.AppclientRuntimeInterface;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.exceptions.BaseRemoteException;
import com.sap.engine.services.appclient.server.ApplicationClientContainer;
import com.sap.engine.services.appclient.server.ApplicationClientFrame;
import com.sap.engine.services.appclient.server.ClientObject;
import com.sap.engine.services.appclient.server.Log;
import com.sap.engine.services.appclient.server.ReaderCouple;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.server.ApplicationLoader;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;

public class AppclientRuntimeImpl
extends PortableRemoteObject
implements AppclientRuntimeInterface {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$appclient$server$AppclientRuntimeImpl == null ? (class$com$sap$engine$services$appclient$server$AppclientRuntimeImpl = AppclientRuntimeImpl.class$("com.sap.engine.services.appclient.server.AppclientRuntimeImpl")) : class$com$sap$engine$services$appclient$server$AppclientRuntimeImpl));
    private static final String CLASSPATH_TOKEN_PREFIX_STR = "classpathToken_";
    private static final String PROPERTY_CLASSPATH_NUMBER = "com.sap.engine.services.appclient.classpathNumber";
    private static ApplicationClientFrame frame = null;
    private static Runtime runtime = Runtime.getRuntime();
    private static HashMapIntObject processes = new HashMapIntObject();
    private static int lastId = 0;
    private ApplicationClientContainer appclient;
    private Log logger = null;
    private LoadContext lc = null;
    private Properties appclientProperties = null;
    static /* synthetic */ Class class$com$sap$engine$services$appclient$server$AppclientRuntimeImpl;

    public AppclientRuntimeImpl(ApplicationClientFrame frame, ApplicationClientContainer appclient, Log logger, LoadContext lc, Properties appclientProperties) throws RemoteException {
        AppclientRuntimeImpl.frame = frame;
        this.appclient = appclient;
        this.logger = logger;
        this.lc = lc;
        this.appclientProperties = appclientProperties;
    }

    public int runClient(String appname, String args, Properties additionalProperties) throws RemoteException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".runClient", new Object[]{appname, args, "additionalProperties"}));
        }
        try {
            String initialCommand = this.getCommandLine(appname, additionalProperties);
            if (initialCommand == null) {
                BaseRemoteException bre = new BaseRemoteException("appclient_0400", appname);
                LOCATION.logT(500, "Error while trying to construct command line for application client " + appname + ". Maybe it is not installed.");
                throw bre;
            }
            String command = initialCommand + " " + args;
            HashMapIntObject hashMapIntObject = processes;
            synchronized (hashMapIntObject) {
                Runtime runtime = AppclientRuntimeImpl.runtime;
                synchronized (runtime) {
                    if (LOCATION.beLogged(100)) {
                        LOCATION.logT(100, "Command -> " + command);
                    }
                    processes.put(lastId, AppclientRuntimeImpl.runtime.exec(command));
                }
                int n = ++lastId - 1;
                return n;
            }
        }
        catch (Throwable e) {
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, AppClientResourceAccessor.CATEGORY_SYS_SERVER, "Error running application client " + appname + ".", e);
            }
            throw new BaseRemoteException("appclient_0400", appname, e);
        }
    }

    protected synchronized void goodToGo(ReaderCouple readerCouple) {
        block5: {
            try {
                ReaderCouple readerCouple2 = readerCouple;
                synchronized (readerCouple2) {
                    readerCouple.notify();
                }
            }
            catch (IllegalMonitorStateException ex) {
                if (!LOCATION.beLogged(500)) break block5;
                LOCATION.traceThrowableT(500, "Error notifying reader couple.", (Throwable)ex);
            }
        }
    }

    public int processClient(String appname, String args, String dumpFileName, Properties additionalProperties) throws RemoteException {
        try {
            String command = this.getCommandLine(appname, additionalProperties) + " " + args;
            if (command == null) {
                throw new BaseRemoteException("appclient_0400", appname);
            }
            Process processToWait = null;
            Runtime runtime = AppclientRuntimeImpl.runtime;
            synchronized (runtime) {
                processToWait = AppclientRuntimeImpl.runtime.exec(command);
            }
            try {
                ReaderCouple readerCouple;
                File f = new File(dumpFileName);
                File f2 = new File(dumpFileName + ".errors");
                InputStream is = processToWait.getInputStream();
                InputStream is2 = processToWait.getErrorStream();
                FileOutputStream fos = new FileOutputStream(f);
                FileOutputStream fos2 = new FileOutputStream(f2);
                ReaderCouple readerCouple2 = readerCouple = new ReaderCouple(is, fos, is2, fos2, this);
                synchronized (readerCouple2) {
                    readerCouple.wait();
                }
                fos.flush();
                fos2.flush();
                fos.close();
                fos2.close();
                readerCouple.stop();
                try {
                    return processToWait.exitValue();
                }
                catch (Exception e) {
                    if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) {
                        com.sap.engine.services.appclient.exceptions.IOException ioex = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0119", new Object[]{appname}, (Throwable)e);
                        AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)ioex);
                    }
                    processToWait.destroy();
                    return 333;
                }
            }
            catch (Exception e) {
                if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(500)) {
                    com.sap.engine.services.appclient.exceptions.IOException ioex = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0120", new Object[]{appname}, (Throwable)e);
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)ioex);
                }
                return 666;
            }
        }
        catch (Exception e) {
            BaseRemoteException bre = new BaseRemoteException("appclient_0400", appname, (Throwable)e);
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, null, (Throwable)bre);
            }
            throw bre;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int stopClient(int id, String dumpFileName, boolean destroy, int timeout) throws RemoteException {
        HashMapIntObject hashMapIntObject;
        int n;
        Process processToStop = (Process)processes.get(id);
        if (processToStop == null) {
            throw new BaseRemoteException("appclient_0404", Integer.toString(id));
        }
        if (destroy) {
            processToStop.destroy();
            HashMapIntObject hashMapIntObject2 = processes;
            synchronized (hashMapIntObject2) {
                processes.remove(id);
                if (id == lastId - 1) {
                    --lastId;
                }
                return 0;
            }
        }
        try {
            try {
                ReaderCouple readerCouple;
                File f = new File(dumpFileName);
                File f2 = new File(dumpFileName + ".errors");
                InputStream is = processToStop.getInputStream();
                InputStream is2 = processToStop.getErrorStream();
                FileOutputStream fos = new FileOutputStream(f);
                FileOutputStream fos2 = new FileOutputStream(f2);
                ReaderCouple readerCouple2 = readerCouple = new ReaderCouple(is, fos, is2, fos2, this);
                synchronized (readerCouple2) {
                    readerCouple.wait(timeout);
                }
                fos.flush();
                fos2.flush();
                fos.close();
                fos2.close();
                readerCouple.stop();
                try {
                    n = processToStop.exitValue();
                    Object var17_20 = null;
                    hashMapIntObject = processes;
                }
                catch (Exception e) {
                    if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) {
                        com.sap.engine.services.appclient.exceptions.IOException ioex = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0119", new Object[]{Integer.toString(id)}, (Throwable)e);
                        AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)ioex);
                    }
                    processToStop.destroy();
                    int n2 = 333;
                    Object var17_21 = null;
                    HashMapIntObject hashMapIntObject3 = processes;
                    synchronized (hashMapIntObject3) {
                        processes.remove(id);
                        if (id == lastId - 1) {
                            --lastId;
                        }
                        return n2;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(500)) {
                    com.sap.engine.services.appclient.exceptions.IOException ioex = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0120", new Object[]{Integer.toString(id)}, e);
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)ioex);
                }
                int n3 = 666;
                Object var17_22 = null;
                HashMapIntObject hashMapIntObject4 = processes;
                synchronized (hashMapIntObject4) {
                    processes.remove(id);
                    if (id == lastId - 1) {
                        --lastId;
                    }
                    return n3;
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_23 = null;
            HashMapIntObject hashMapIntObject5 = processes;
            synchronized (hashMapIntObject5) {
                processes.remove(id);
                if (id == lastId - 1) {
                    --lastId;
                }
                throw throwable;
            }
        }
        synchronized (hashMapIntObject) {
            processes.remove(id);
            if (id == lastId - 1) {
                --lastId;
            }
            return n;
        }
    }

    public int runClient(String appname, String args) throws RemoteException {
        return this.runClient(appname, args, new Properties());
    }

    public int processClient(String appname, String args, String dumpFileName) throws RemoteException {
        return this.processClient(appname, args, dumpFileName, new Properties());
    }

    public String[] listElements(String applicationName) throws RemoteException {
        return this.appclient.listElements(applicationName);
    }

    public String[] listApplications() throws RemoteException {
        return this.appclient.listApplications();
    }

    public ApplicationClientDescriptor getRuntimeDescriptor(String earName, String clName) throws RemoteException {
        return null;
    }

    public void save(String applicationName, Properties props) throws BaseRemoteException {
        Enumeration keys = ((Hashtable)props).keys();
        String clName = (String)keys.nextElement();
    }

    private String getCommandLine(String clientName, Properties additionalProperties) throws RemoteException {
        String msg;
        String msg2;
        String classpathNumberStr;
        int classPathNumber;
        String applicationName;
        String appRootDir;
        ClientObject clientObject;
        String commandLine;
        block47: {
            ClassLoader loader;
            EJBeanReference[] unresolvedBefore;
            block44: {
                commandLine = "java -cp ";
                clientObject = null;
                appRootDir = null;
                applicationName = null;
                String clName = null;
                if (this.appclient.clientJars.size() == 0) {
                    BaseRemoteException bre = new BaseRemoteException("appclient_0402");
                    if (LOCATION.beLogged(300)) {
                        LOCATION.traceThrowableT(300, "Unable to build command line for application client " + clientName, (Throwable)bre);
                    }
                    throw bre;
                }
                Enumeration e = this.appclient.clientJars.elements();
                block14: while (e.hasMoreElements()) {
                    ClientObject[] cobj = (ClientObject[])e.nextElement();
                    int i = 0;
                    while (i < cobj.length) {
                        clName = cobj[i].getClientName();
                        if (clName.equals(clientName)) {
                            clientObject = cobj[i];
                            applicationName = clientObject.applicationName;
                            continue block14;
                        }
                        ++i;
                    }
                }
                if (clientObject == null) {
                    if (LOCATION.beLogged(300)) {
                        LOCATION.logT(300, "Application client " + clientName + "is not registered in -> " + this.appclient.clientJars);
                    }
                    throw new BaseRemoteException("appclient_0403");
                }
                try {
                    appRootDir = AppclientRuntimeImpl.frame.communicator.getMyWorkDirectory(applicationName);
                }
                catch (IOException ioEx) {
                    BaseRemoteException bre = new BaseRemoteException("appclient_0401", applicationName, (Throwable)ioEx);
                    if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(500)) {
                        com.sap.engine.services.appclient.exceptions.IOException ioex = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0401", new Object[]{applicationName}, (Throwable)ioEx);
                        AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)ioex);
                    }
                    throw bre;
                }
                commandLine = commandLine + "\"";
                try {
                    File policyFile = new File(appRootDir + File.separator + "client.policy");
                    FileOutputStream policyStream = new FileOutputStream(policyFile);
                    policyStream.write(new String("grant {\n").getBytes());
                    policyStream.write(new String("  permission com.sap.engine.lib.security.VirtualPermission \"@a@p@p" + applicationName + "/" + clientName + "\";\n").getBytes());
                    policyStream.write(new String("};\n\n").getBytes());
                    String sPolicy = (String)((Hashtable)additionalProperties).remove("java.security.policy");
                    if (sPolicy == null) {
                        sPolicy = this.appclientProperties.getProperty("java.security.policy");
                    }
                    if (sPolicy != null) {
                        File defaultPolicyFile = new File(sPolicy);
                        FileInputStream defPolicyStream = new FileInputStream(defaultPolicyFile);
                        byte[] buffer = new byte[1024];
                        int bufSize = defPolicyStream.read(buffer);
                        while (bufSize != -1) {
                            policyStream.write(buffer, 0, bufSize);
                            bufSize = defPolicyStream.read(buffer);
                        }
                        defPolicyStream.close();
                    }
                    policyStream.flush();
                    policyStream.close();
                }
                catch (IOException e2) {
                    if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block44;
                    BaseRemoteException bre = new BaseRemoteException("appclient_0406", applicationName, (Throwable)e2);
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)bre);
                }
            }
            String sCr = File.separator;
            String pCr = File.pathSeparator;
            Vector warnings = new Vector();
            commandLine = commandLine + appRootDir + sCr + clientObject.getClientJar().getName() + pCr;
            String[] appClJars = clientObject.getDescriptor().getClientJars();
            if (appClJars != null) {
                int i = 0;
                while (i < appClJars.length) {
                    commandLine = commandLine + appClJars[i] + pCr;
                    ++i;
                }
            }
            if ((unresolvedBefore = clientObject.getDescriptor().getUnresolvedRefs()) != null) {
                if (AppclientRuntimeImpl.frame.ejbManager != null) {
                    int k = 0;
                    while (k < unresolvedBefore.length) {
                        String[] helpers = AppclientRuntimeImpl.frame.ejbManager.getApplicationJars(applicationName, warnings, unresolvedBefore[k].getReferenceJndiLink(), unresolvedBefore[k].getReferenceEjbLink(), unresolvedBefore[k].getHomeInterfaceName(), unresolvedBefore[k].getRemoteInterfaceName(), unresolvedBefore[k].getReferenceName());
                        if (helpers != null) {
                            int t = 0;
                            while (t < helpers.length) {
                                commandLine = commandLine + helpers[t] + pCr;
                                ++t;
                            }
                            ++k;
                            continue;
                        }
                        break;
                    }
                } else if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) {
                    BaseRemoteException bre = new BaseRemoteException("appclient_0302", applicationName);
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)bre);
                }
            }
            if ((loader = this.lc.getClassLoader(applicationName)) != null) {
                String classpath = ((ApplicationLoader)loader).getClassPath();
                commandLine = commandLine + classpath + pCr;
            }
            classPathNumber = 0;
            classpathNumberStr = this.appclientProperties.getProperty(PROPERTY_CLASSPATH_NUMBER);
            if (classpathNumberStr != null) {
                try {
                    classPathNumber = Integer.parseInt(classpathNumberStr);
                    int i = 0;
                    while (i < classPathNumber) {
                        block46: {
                            try {
                                commandLine = commandLine + this.appclientProperties.getProperty(CLASSPATH_TOKEN_PREFIX_STR + String.valueOf(i)).replace('/', File.separatorChar) + File.pathSeparator;
                            }
                            catch (NullPointerException npe) {
                                if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block46;
                                msg2 = AppClientResourceAccessor.getLocalizedText("appclient_0205", new Object[]{String.valueOf(i), applicationName});
                                AppClientResourceAccessor.DEFAULT_CATEGORY.logT(400, LOCATION, msg2);
                                AppClientResourceAccessor.DEFAULT_LOCATION.traceThrowableT(100, msg2, (Throwable)npe);
                            }
                        }
                        ++i;
                    }
                }
                catch (NumberFormatException e) {
                    if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block47;
                    msg = AppClientResourceAccessor.getLocalizedText("appclient_0207", new Object[]{applicationName, ""});
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logT(400, LOCATION, msg);
                    AppClientResourceAccessor.DEFAULT_LOCATION.traceThrowableT(100, msg, (Throwable)e);
                }
            }
        }
        if (additionalProperties != null) {
            try {
                Object var21_41;
                block48: {
                    try {
                        classpathNumberStr = additionalProperties.getProperty(PROPERTY_CLASSPATH_NUMBER);
                        if (classpathNumberStr == null) break block48;
                        classPathNumber = Integer.parseInt(classpathNumberStr);
                        ((Hashtable)additionalProperties).remove(PROPERTY_CLASSPATH_NUMBER);
                        int i = 0;
                        while (i < classPathNumber) {
                            block49: {
                                try {
                                    commandLine = commandLine + ((String)((Hashtable)additionalProperties).remove(CLASSPATH_TOKEN_PREFIX_STR + String.valueOf(i))).replace('/', File.separatorChar) + File.pathSeparator;
                                }
                                catch (NullPointerException npe) {
                                    if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block49;
                                    msg2 = AppClientResourceAccessor.getLocalizedText("appclient_0206", new Object[]{String.valueOf(i), applicationName});
                                    AppClientResourceAccessor.DEFAULT_CATEGORY.logT(400, LOCATION, msg2);
                                    AppClientResourceAccessor.DEFAULT_LOCATION.traceThrowableT(100, msg2, (Throwable)npe);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) {
                            msg = AppClientResourceAccessor.getLocalizedText("appclient_0207", new Object[]{applicationName, "additional "});
                            AppClientResourceAccessor.DEFAULT_CATEGORY.logT(400, LOCATION, msg);
                            AppClientResourceAccessor.DEFAULT_LOCATION.traceThrowableT(100, msg, (Throwable)nfe);
                        }
                        var21_41 = null;
                        commandLine = commandLine + "\"";
                    }
                }
                var21_41 = null;
                commandLine = commandLine + "\"";
            }
            catch (Throwable throwable) {
                Object var21_42 = null;
                commandLine = commandLine + "\"";
                throw throwable;
            }
            commandLine = commandLine + " \"-Djava.security.policy=" + appRootDir + File.separator + "client.policy" + "\"";
            Enumeration<?> keys = additionalProperties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                commandLine = commandLine + " \"-D" + key + "=" + additionalProperties.getProperty(key) + "\"";
            }
        } else {
            commandLine = commandLine + "\"";
            commandLine = commandLine + " \"-Djava.naming.factory.initial=" + this.appclientProperties.getProperty("java.naming.factory.initial") + "\"";
            commandLine = commandLine + " \"-Djava.security.policy=" + appRootDir + File.separator + "client.policy" + "\"";
            if (this.appclientProperties.getProperty("java.security.auth.login.config") != null) {
                commandLine = commandLine + " \"-Djava.security.auth.login.config=" + this.appclientProperties.getProperty("java.security.auth.login.config") + "\"";
            }
            if (this.appclientProperties.getProperty("java.security.auth.policy") != null) {
                commandLine = commandLine + " \"-Djava.security.auth.policy=" + this.appclientProperties.getProperty("java.security.auth.policy") + "\"";
            }
        }
        commandLine = commandLine + " ";
        commandLine = commandLine + clientObject.getMainClassName();
        return commandLine;
    }

    public void setAppClientContainer(ApplicationClientContainer appClient) {
        this.appclient = appClient;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

