/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.appclient.descriptor.xml;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.exceptions.WrongStructureException;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class J2EEApplicationAdditionalDocument {
    public static final String dtd = "<!DOCTYPE appclient-j2ee-engine SYSTEM 'appclient-j2ee-engine.dtd'>";
    protected Document mainDocument;
    protected Element docElement;
    protected Element clients;
    public boolean toSave;

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public String getDTD() {
        return dtd;
    }

    public void setMainDocument(Document document) throws WrongStructureException {
        if (!document.getDocumentElement().getNodeName().equals("application-client-additional") || !document.getDocumentElement().getNodeName().equals("appclient-j2ee-engine")) {
            throw new WrongStructureException("appclient_0200");
        }
        this.mainDocument = document;
        this.docElement = document.getDocumentElement();
        NodeList list = this.docElement.getElementsByTagName(document.getDocumentElement().getNodeName());
        if (list.item(0) != null) {
            this.clients = (Element)list.item(0);
        }
    }

    public void init() {
        this.mainDocument = J2EEApplicationAdditionalDocument.createDOMDocument();
        this.clients = this.mainDocument.createElement("appclient-j2ee-engine");
        this.mainDocument.appendChild(this.clients);
    }

    protected void loadResourceRef(Element elmnt, ResourceReference resRef) {
        if (resRef.getResourceLink() != null && !resRef.getResourceLink().trim().equals("")) {
            Element resRefElement = this.mainDocument.createElement("resource-ref");
            String name = resRef.getResourceName();
            this.load(resRefElement, name, "res-ref-name");
            String resLink = resRef.getResourceLink();
            this.load(resRefElement, resLink, "res-link");
            elmnt.appendChild(resRefElement);
            this.toSave = true;
        }
    }

    protected void loadResourceEnvRef(Element elmnt, ResourceEnvReference resEnvRef) {
        if (resEnvRef.getJndiName() != null && !resEnvRef.getJndiName().trim().equals("")) {
            Element resEnvRefElement = this.mainDocument.createElement("resource-env-ref");
            String name = resEnvRef.getName();
            this.load(resEnvRefElement, name, "resource-env-ref-name");
            String jndiName = resEnvRef.getJndiName();
            this.load(resEnvRefElement, jndiName, "jndi-name");
            elmnt.appendChild(resEnvRefElement);
            this.toSave = true;
        }
    }

    protected void loadEjbRef(Element elmnt, EJBeanReference ejbRef) {
        if (ejbRef.getReferenceJndiLink() != null && !ejbRef.getReferenceJndiLink().trim().equals("")) {
            Element ejbRefElement = this.mainDocument.createElement("ejb-ref");
            String name = ejbRef.getReferenceName();
            this.load(ejbRefElement, name, "ejb-ref-name");
            String jndiName = ejbRef.getReferenceJndiLink();
            if (jndiName != null) {
                this.load(ejbRefElement, jndiName, "jndi-name");
            }
            elmnt.appendChild(ejbRefElement);
            this.toSave = true;
        }
    }

    protected void loadCompRef(Element elmnt, ComponentReference compRef) {
        if (compRef != null && compRef.getName() != null && !compRef.getName().trim().equals("")) {
            Element compRefElement = this.mainDocument.createElement("server-component-ref");
            this.load(compRefElement, compRef.getName(), "name");
            this.toSave = true;
            String type = "Service";
            if (compRef.getType() == 1) {
                type = "Interface";
            }
            this.load(compRefElement, type, "type");
            if (compRef.getJndiName() != null && !compRef.getJndiName().equals("")) {
                this.load(compRefElement, compRef.getJndiName(), "jndi-name");
            }
            if (compRef.getDescription() != null && !compRef.getDescription().equals("")) {
                this.load(compRefElement, compRef.getDescription(), "description");
            }
            elmnt.appendChild(compRefElement);
        }
    }

    public Document loadClientAdditionalElements(ApplicationClientDescriptor descriptor) {
        this.toSave = false;
        if (descriptor != null) {
            ComponentReference[] compReferences;
            EJBeanReference[] ejbReferences;
            ResourceEnvReference[] resEnvRefs;
            ResourceReference[] resRefs;
            if (this.mainDocument == null) {
                this.init();
            }
            if ((resRefs = descriptor.getResourceReferences()) != null) {
                int i = 0;
                while (i < resRefs.length) {
                    this.loadResourceRef(this.mainDocument.getDocumentElement(), resRefs[i]);
                    ++i;
                }
            }
            if ((resEnvRefs = descriptor.getResourceEnvReference()) != null) {
                int i = 0;
                while (i < resEnvRefs.length) {
                    this.loadResourceEnvRef(this.mainDocument.getDocumentElement(), resEnvRefs[i]);
                    ++i;
                }
            }
            if ((ejbReferences = descriptor.getEJBeanReferences()) != null) {
                int t = 0;
                while (t < ejbReferences.length) {
                    this.loadEjbRef(this.mainDocument.getDocumentElement(), ejbReferences[t]);
                    ++t;
                }
            }
            if ((compReferences = descriptor.getServerComponentRefs()) != null) {
                int i = 0;
                while (i < compReferences.length) {
                    this.loadCompRef(this.mainDocument.getDocumentElement(), compReferences[i]);
                    ++i;
                }
            }
            return this.mainDocument;
        }
        return null;
    }

    protected void load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    public void readXML(Document doc, ApplicationClientDescriptor descriptor) throws WrongStructureException {
        Element elm = doc.getDocumentElement();
        if (!elm.getNodeName().equals("application-client-additional") && !elm.getNodeName().equals("appclient-j2ee-engine")) {
            throw new WrongStructureException("appclient_0202", new Object[]{"ApplicationClient", "application-client-additional"});
        }
        ResourceEnvReference[] resEnvRefs = descriptor.getResourceEnvReference();
        ResourceReference[] resRefs = descriptor.getResourceReferences();
        EJBeanReference[] ejbRefs = descriptor.getEJBeanReferences();
        ComponentReference compRef = null;
        int type = -1;
        NodeList list = elm.getChildNodes();
        Element tempEl = null;
        String tempTag = null;
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    NodeList nodeList2;
                    int k;
                    String value;
                    int j;
                    NodeList list1;
                    Element el = (Element)list.item(i);
                    String tag = el.getNodeName();
                    if (tag.equals("resource-ref") && resRefs != null && (list1 = el.getChildNodes()) != null) {
                        j = 0;
                        while (j < list1.getLength()) {
                            if (list1.item(j).getNodeName().equals("res-ref-name") && (value = this.getTextValue((Element)list1.item(j))) != null) {
                                k = 0;
                                while (k < resRefs.length) {
                                    if (value.equals(resRefs[k].getResourceName())) {
                                        this.completeResRefs(resRefs[k], el);
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    if (tag.equals("resource-env-ref") && resEnvRefs != null && (list1 = el.getChildNodes()) != null) {
                        j = 0;
                        while (j < list1.getLength()) {
                            if (list1.item(j).getNodeName().equals("resource-env-ref-name") && (value = this.getTextValue((Element)list1.item(j))) != null) {
                                k = 0;
                                while (k < resEnvRefs.length) {
                                    if (value.equals(resEnvRefs[k].getName())) {
                                        this.completeResEnvRefs(resEnvRefs[k], el);
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    if (tag.equals("ejb-ref") && ejbRefs != null && (nodeList2 = el.getChildNodes()) != null) {
                        int t = 0;
                        while (t < nodeList2.getLength()) {
                            if (nodeList2.item(t).getNodeName().equals("ejb-ref-name") && (value = this.getTextValue((Element)nodeList2.item(t))) != null) {
                                int b = 0;
                                while (b < ejbRefs.length) {
                                    if (value.equals(ejbRefs[b].getReferenceName())) {
                                        this.completeEjbRefs(ejbRefs[b], el);
                                    }
                                    ++b;
                                }
                            }
                            ++t;
                        }
                    }
                    if (tag.equals("server-component-ref")) {
                        list1 = el.getChildNodes();
                        compRef = null;
                        if (list1 != null) {
                            j = 0;
                            while (j < list1.getLength()) {
                                if (list1.item(j).getNodeType() == 1) {
                                    tempEl = (Element)list1.item(j);
                                    tempTag = tempEl.getNodeName();
                                    if (tempTag.equals("name") && (value = this.getTextValue(tempEl)) != null && !value.equals("")) {
                                        compRef = new ComponentReference();
                                        compRef.setName(value);
                                    }
                                    if (compRef == null) {
                                        throw new WrongStructureException("appclient_0203", "Name");
                                    }
                                    if (tempTag.equals("type")) {
                                        type = 0;
                                        if (this.getTextValue(tempEl).equalsIgnoreCase("Interface")) {
                                            type = 1;
                                        }
                                        compRef.setType(type);
                                    } else if (tempTag.equals("jndi-name")) {
                                        compRef.setJndiName(this.getTextValue(tempEl));
                                    } else if (tempTag.equals("description")) {
                                        compRef.setDescription(this.getTextValue(tempEl));
                                    }
                                }
                                ++j;
                            }
                        }
                        if (compRef != null) {
                            descriptor.setServerComponentReference(compRef);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void completeResRefs(ResourceReference resRef, Element el) {
        NodeList list1 = el.getChildNodes();
        if (list1 != null) {
            int j = 0;
            while (j < list1.getLength()) {
                if (list1.item(j).getNodeName().equals("res-link")) {
                    resRef.setResourceLink(this.getTextValue((Element)list1.item(j)));
                }
                ++j;
            }
        }
    }

    private void completeEjbRefs(EJBeanReference ejbRefs, Element el) {
        NodeList ejbRefList = el.getChildNodes();
        int i = 0;
        while (i < ejbRefList.getLength()) {
            Element elem;
            String ejbTag;
            if (ejbRefList.item(i).getNodeType() == 1 && ((ejbTag = (elem = (Element)ejbRefList.item(i)).getNodeName()).equals("jndi-name") || ejbTag.equals("ejb-jndi-name"))) {
                String value = this.getTextValue(elem);
                ejbRefs.setReferenceJndiLink(value);
            }
            ++i;
        }
    }

    private void completeResEnvRefs(ResourceEnvReference resEnvRef, Element el) {
        NodeList list1 = el.getChildNodes();
        if (list1 != null) {
            int j = 0;
            while (j < list1.getLength()) {
                if (list1.item(j).getNodeName().equals("jndi-name")) {
                    resEnvRef.setJndiName(this.getTextValue((Element)list1.item(j)));
                }
                ++j;
            }
        }
    }

    protected String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    private static Document createDOMDocument() {
        Document document = null;
        ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
        try {
            document = StandardDOMParser.createDocument();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
        return document;
    }
}

