/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.cache;

import com.sap.engine.lib.util.cache.SoftValue;
import com.sap.engine.lib.util.cache.SoftValueHashMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

public class CacheGroup
extends ReferenceQueue
implements Runnable {
    private Thread thread = null;
    protected ReferenceQueue queue = new ReferenceQueue();
    protected boolean stopFlag = false;

    public Reference poll() {
        return this.queue.poll();
    }

    public Reference remove() throws InterruptedException {
        return this.queue.remove();
    }

    public Reference remove(long timeout) throws InterruptedException {
        return this.queue.remove(timeout);
    }

    public void stop() {
        this.stopFlag = true;
        this.queue = null;
        this.thread.interrupt();
    }

    public void run() {
        this.thread = Thread.currentThread();
        while (!this.stopFlag) {
            try {
                SoftValue value = (SoftValue)this.queue.remove();
                SoftValueHashMap softValueHashMap = value.hashMap;
                synchronized (softValueHashMap) {
                    Object removingKey = value.key;
                    SoftValue getted = (SoftValue)value.hashMap.get(removingKey);
                    if (getted != null && getted.get() == null) {
                        if (value.hashMap.cacheListener != null) {
                            value.hashMap.cacheListener.removedByGarbageCollector(removingKey);
                        }
                        value.hashMap.remove(removingKey);
                    }
                }
            }
            catch (InterruptedException inEx) {
                this.stopFlag = true;
            }
        }
    }
}

