/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.base.BaseDeque;
import com.sap.engine.lib.util.base.LinearItem;

public class BaseWaitDeque
extends BaseDeque {
    private transient int waitPop = 0;
    private transient int waitPush = 0;

    public BaseWaitDeque() {
    }

    public BaseWaitDeque(int limit) {
        super(limit);
    }

    public synchronized boolean pushLeft(LinearItem item) {
        boolean result;
        while (!(result = this.addFirstItem(item))) {
            Object var5_3;
            ++this.waitPop;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var5_3 = null;
                    --this.waitPop;
                    break;
                }
                var5_3 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var5_3 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized boolean pushLeft(LinearItem item, long timeout) throws InterruptedException {
        boolean result = this.addFirstItem(item);
        if (!result) {
            ++this.waitPop;
            try {
                this.wait(timeout);
                Object var6_4 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                --this.waitPop;
                throw throwable;
            }
            result = this.addFirstItem(item);
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized LinearItem popLeft() {
        LinearItem result;
        while ((result = this.removeFirstItem()) == null) {
            Object var4_2;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPush;
                    break;
                }
                var4_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized LinearItem popLeft(long timeout) throws InterruptedException {
        LinearItem result = this.removeFirstItem();
        if (result == null) {
            ++this.waitPush;
            try {
                this.wait(timeout);
                Object var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                --this.waitPush;
                throw throwable;
            }
            result = this.removeFirstItem();
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized LinearItem topLeft() {
        LinearItem result;
        while ((result = this.getFirstItem()) == null) {
            Object var4_2;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPush;
                    break;
                }
                var4_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        return result;
    }

    public synchronized LinearItem topLeft(long timeout) throws InterruptedException {
        LinearItem result = this.getFirstItem();
        if (result == null) {
            ++this.waitPush;
            try {
                this.wait(timeout);
                Object var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                --this.waitPush;
                throw throwable;
            }
            return this.getFirstItem();
        }
        return result;
    }

    public synchronized boolean pushRight(LinearItem item) {
        boolean result;
        while (!(result = this.addLastItem(item))) {
            Object var5_3;
            ++this.waitPop;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var5_3 = null;
                    --this.waitPop;
                    break;
                }
                var5_3 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                var5_3 = null;
                --this.waitPop;
                throw throwable;
            }
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized boolean pushRight(LinearItem item, long timeout) throws InterruptedException {
        boolean result = this.addLastItem(item);
        if (!result) {
            ++this.waitPop;
            try {
                this.wait(timeout);
                Object var6_4 = null;
                --this.waitPop;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                --this.waitPop;
                throw throwable;
            }
            result = this.addLastItem(item);
        }
        if (this.waitPush > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized LinearItem popRight() {
        LinearItem result;
        while ((result = this.removeLastItem()) == null) {
            Object var4_2;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPush;
                    break;
                }
                var4_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized LinearItem popRight(long timeout) throws InterruptedException {
        LinearItem result = this.removeLastItem();
        if (result == null) {
            ++this.waitPush;
            try {
                this.wait(timeout);
                Object var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                --this.waitPush;
                throw throwable;
            }
            result = this.removeLastItem();
        }
        if (this.waitPop > 0) {
            this.notifyAll();
        }
        return result;
    }

    public synchronized LinearItem topRight() {
        LinearItem result;
        while ((result = this.getLastItem()) == null) {
            Object var4_2;
            ++this.waitPush;
            try {
                try {
                    this.wait();
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitPush;
                    break;
                }
                var4_2 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitPush;
                throw throwable;
            }
        }
        return result;
    }

    public synchronized LinearItem topRight(long timeout) throws InterruptedException {
        LinearItem result = this.getLastItem();
        if (result == null) {
            ++this.waitPush;
            try {
                this.wait(timeout);
                Object var5_3 = null;
                --this.waitPush;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                --this.waitPush;
                throw throwable;
            }
            return this.getLastItem();
        }
        return result;
    }
}

