/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.AbstractDataStructure;
import com.sap.engine.lib.util.NotSupportedException;
import com.sap.engine.lib.util.RootDataStructure;
import com.sap.engine.lib.util.base.NextItem;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.ForwardIterator;
import com.sap.engine.lib.util.iterators.IteratorException;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;

public class BaseLinkedList
extends AbstractDataStructure {
    protected NextItem first = null;
    protected NextItem last = null;
    protected int limit;

    public BaseLinkedList() {
        this(0);
    }

    public BaseLinkedList(int limit) {
        this.setLimit(limit);
    }

    public boolean addItem(int index, NextItem item) {
        if (this.count >= this.limit || index > this.count || index < 0) {
            return false;
        }
        this.add_(index, item);
        return true;
    }

    protected void add_(int index, NextItem item) {
        if (index == 0) {
            item.setNext(this.first);
            this.first = item;
            if (this.last == null) {
                this.last = this.first;
            }
        } else if (index == this.count) {
            this.last.setNext(item);
            item.setNext(null);
            this.last = item;
        } else {
            NextItem temp = this.first;
            int i = 1;
            while (i < index) {
                temp = temp.getNext();
                ++i;
            }
            item.setNext(temp.getNext());
            temp.setNext(item);
        }
        ++this.count;
    }

    public boolean addFirstItem(NextItem item) {
        if (this.count >= this.limit) {
            return false;
        }
        this.addFirst_(item);
        return true;
    }

    protected void addFirst_(NextItem item) {
        item.setNext(this.first);
        this.first = item;
        if (this.last == null) {
            this.last = this.first;
        }
        ++this.count;
    }

    public boolean addItem(NextItem item) {
        return this.addLastItem(item);
    }

    public boolean addLastItem(NextItem item) {
        if (this.count >= this.limit) {
            return false;
        }
        this.addLast_(item);
        return true;
    }

    protected void addLast_(NextItem item) {
        if (this.count == 0) {
            item.setNext(null);
            this.first = item;
            this.last = item;
        } else {
            this.last.setNext(item);
            item.setNext(null);
            this.last = item;
        }
        ++this.count;
    }

    public NextItem removeItem(int index) {
        if (index >= this.count || index < 0) {
            return null;
        }
        if (index == 0) {
            NextItem temp = this.first;
            this.first = this.first.getNext();
            --this.count;
            if (this.count == 0) {
                this.last = null;
            }
            temp.clearItem();
            return temp;
        }
        NextItem temp = this.first;
        int i = 1;
        while (i < index) {
            temp = temp.getNext();
            ++i;
        }
        NextItem res = temp.getNext();
        temp.setNext(res.getNext());
        --this.count;
        if (res == this.last) {
            this.last = temp;
        }
        res.clearItem();
        return res;
    }

    public NextItem removeItem(NextItem item) {
        if (this.count == 0) {
            return null;
        }
        NextItem old = null;
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                if (old != null) {
                    old.setNext(temp.getNext());
                } else {
                    this.first = temp.getNext();
                }
                if (temp == this.last) {
                    this.last = old;
                }
                temp.clearItem();
                --this.count;
                return temp;
            }
            old = temp;
            temp = temp.getNext();
            ++i;
        }
        return null;
    }

    public int removeAllItems(NextItem item) {
        int deleted = 0;
        NextItem prev = null;
        NextItem next = null;
        NextItem temp = this.first;
        while (temp != null) {
            next = temp.getNext();
            if (temp.equals(item)) {
                ++deleted;
                if (prev != null) {
                    prev.setNext(next);
                } else {
                    this.first = next;
                }
                temp.clearItem();
            } else {
                prev = temp;
            }
            temp = next;
        }
        this.last = prev;
        this.count -= deleted;
        return deleted;
    }

    public NextItem removeFirstItem() {
        if (this.count == 0) {
            return null;
        }
        NextItem temp = this.first;
        this.first = this.first.getNext();
        --this.count;
        if (this.count == 0) {
            this.last = null;
        }
        temp.clearItem();
        return temp;
    }

    public NextItem removeLastItem() {
        if (this.count == 0) {
            return null;
        }
        NextItem tmp = this.first;
        if (this.count == 1) {
            this.first = null;
            this.last = null;
            tmp.clearItem();
            --this.count;
            return tmp;
        }
        int i = 2;
        while (i < this.count) {
            tmp = tmp.getNext();
            ++i;
        }
        this.last = tmp;
        tmp = tmp.getNext();
        this.last.setNext(null);
        tmp.clearItem();
        --this.count;
        return tmp;
    }

    public NextItem setItem(int index, NextItem item) {
        NextItem result;
        if (index >= this.count || index < 0) {
            return null;
        }
        if (index == 0) {
            item.setNext(this.first.getNext());
            result = this.first;
            this.first = item;
        } else {
            NextItem temp = this.first;
            int i = 1;
            while (i < index) {
                temp = temp.getNext();
                ++i;
            }
            result = temp.getNext();
            item.setNext(result.getNext());
            temp.setNext(item);
        }
        if (this.last == result) {
            this.last = item;
        }
        result.clearItem();
        return result;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.count = 0;
    }

    public Object clone() {
        return this.clone_();
    }

    private Object clone_() {
        NextItem newFirst;
        BaseLinkedList result = (BaseLinkedList)super.clone();
        if (this.count == 0) {
            return result;
        }
        NextItem temp = this.first;
        NextItem newItem = newFirst = (NextItem)this.first.clone();
        int i = 1;
        while (i < this.count) {
            temp = temp.getNext();
            newItem.setNext((NextItem)temp.clone());
            newItem = newItem.getNext();
            ++i;
        }
        newItem.setNext(null);
        result.first = newFirst;
        result.last = newItem;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseLinkedList)) {
            return false;
        }
        if (this.count != ((BaseLinkedList)obj).count) {
            return false;
        }
        if (this.count == 0) {
            return true;
        }
        NextItem currentTemp = this.first;
        NextItem checkedTemp = ((BaseLinkedList)obj).first;
        int i = 0;
        while (i < this.count) {
            if (!currentTemp.equals(checkedTemp)) {
                return false;
            }
            currentTemp = currentTemp.getNext();
            checkedTemp = checkedTemp.getNext();
            ++i;
        }
        return true;
    }

    public boolean containsItem(NextItem item) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return true;
            }
            temp = temp.getNext();
            ++i;
        }
        return false;
    }

    public NextItem getItem(NextItem item) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return temp;
            }
            temp = temp.getNext();
            ++i;
        }
        return null;
    }

    public NextItem getItem(int index) {
        if (index >= this.count || index < 0) {
            return null;
        }
        NextItem temp = this.first;
        int i = 0;
        while (i < index) {
            temp = temp.getNext();
            ++i;
        }
        return temp;
    }

    public NextItem getFirstItem() {
        return this.first;
    }

    public NextItem getLastItem() {
        return this.last;
    }

    public int indexOfItem(NextItem item) {
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return i;
            }
            temp = temp.getNext();
            ++i;
        }
        return -1;
    }

    public int lastIndexOfItem(NextItem item) {
        NextItem temp = this.first;
        int lastIndex = -1;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                lastIndex = i;
            }
            temp = temp.getNext();
            ++i;
        }
        return lastIndex;
    }

    public boolean isFull() {
        return this.count >= this.limit;
    }

    public NextItem[] toItemArray() {
        NextItem[] array = new NextItem[this.count];
        NextItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            array[i] = temp;
            temp = temp.getNext();
            ++i;
        }
        return array;
    }

    protected void init(NextItem first, NextItem last, int count) {
        this.first = first;
        this.last = last;
        this.count = count;
    }

    public BaseLinkedList sublist(int index) {
        return this.sublist_(index);
    }

    private BaseLinkedList sublist_(int index) {
        NextItem newFirst;
        if (index <= 0) {
            return (BaseLinkedList)this.clone_();
        }
        BaseLinkedList result = (BaseLinkedList)super.clone();
        if (index >= this.count) {
            result.init(null, null, 0);
            return result;
        }
        NextItem temp = this.first;
        int i = 0;
        while (i < index) {
            temp = temp.getNext();
            ++i;
        }
        NextItem newItem = newFirst = (NextItem)temp.clone();
        int i2 = index + 1;
        while (i2 < this.count) {
            temp = temp.getNext();
            newItem.setNext((NextItem)temp.clone());
            newItem = newItem.getNext();
            ++i2;
        }
        newItem.setNext(null);
        result.init(newFirst, newItem, this.count - index);
        return result;
    }

    public BaseLinkedList sublist(int lowerBoundary, int upperBoundary) {
        NextItem newFirst;
        if (upperBoundary >= this.count) {
            upperBoundary = this.count - 1;
        }
        if (lowerBoundary < 0) {
            lowerBoundary = 0;
        }
        if (upperBoundary == this.count - 1) {
            return this.sublist_(lowerBoundary);
        }
        BaseLinkedList result = (BaseLinkedList)super.clone();
        if (lowerBoundary > upperBoundary) {
            result.init(null, null, 0);
            return result;
        }
        NextItem temp = this.first;
        int i = 0;
        while (i < lowerBoundary) {
            temp = temp.getNext();
            ++i;
        }
        NextItem newItem = newFirst = (NextItem)temp.clone();
        int i2 = lowerBoundary;
        while (i2 < upperBoundary) {
            temp = temp.getNext();
            newItem.setNext((NextItem)temp.clone());
            newItem = newItem.getNext();
            ++i2;
        }
        newItem.setNext(null);
        result.init(newFirst, newItem, upperBoundary - lowerBoundary + 1);
        return result;
    }

    public boolean removeSublist(int index) {
        if (index >= this.count || this.count == 0) {
            return false;
        }
        if (index <= 0) {
            this.first = null;
            this.last = null;
            this.count = 0;
        } else {
            NextItem temp = this.first;
            int i = 1;
            while (i < index) {
                temp = temp.getNext();
                ++i;
            }
            temp.setNext(null);
            this.last = temp;
            this.count = index;
        }
        return true;
    }

    public boolean removeRange(int lowerBoundary, int upperBoundary) {
        if (upperBoundary >= this.count) {
            upperBoundary = this.count - 1;
        }
        if (lowerBoundary < 0) {
            lowerBoundary = 0;
        }
        if (lowerBoundary > upperBoundary || lowerBoundary >= this.count) {
            return false;
        }
        int dif = upperBoundary - lowerBoundary;
        if (lowerBoundary == 0) {
            NextItem temp = this.first;
            int i = 0;
            while (i < upperBoundary) {
                temp = temp.getNext();
                ++i;
            }
            this.first = temp.getNext();
            if (this.first == null) {
                this.last = null;
            }
        } else {
            NextItem old = this.first;
            int i = 1;
            while (i < lowerBoundary) {
                old = old.getNext();
                ++i;
            }
            NextItem temp = old.getNext();
            int i2 = 0;
            while (i2 <= dif) {
                temp = temp.getNext();
                ++i2;
            }
            old.setNext(temp);
            if (temp == null) {
                this.last = old;
            }
        }
        this.count -= dif + 1;
        return true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(" [Size = " + this.count + "; First = " + this.first + "; Last = " + this.last + "; Limit = " + this.limit + "]\n[");
        NextItem temp = this.first;
        while (temp != null) {
            s.append(temp + ", ");
            temp = temp.getNext();
        }
        s.append("]");
        return s.toString();
    }

    public SnapShotEnumeration itemsEnumeration() {
        return new ArrayEnumeration(this.toItemArray());
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit <= 0 ? Integer.MAX_VALUE : limit;
    }

    protected Object getNewInstance() {
        return super.clone();
    }

    public boolean addAfter(NextItem index, NextItem item) {
        if (this.count >= this.limit) {
            return false;
        }
        NextItem next = index.getNext();
        item.setNext(next);
        if (next == null) {
            this.last = item;
        }
        index.setNext(item);
        ++this.count;
        return true;
    }

    public void removeAfter(NextItem index) {
        NextItem target = index.getNext();
        if (target != null) {
            NextItem next = target.getNext();
            index.setNext(next);
            if (next == null) {
                this.last = index;
            }
            target.clearItem();
            --this.count;
        }
    }

    public void removeRange(NextItem start, NextItem end) {
        int counter = 0;
        NextItem temp = start;
        while (temp != end) {
            temp = temp.getNext();
            ++counter;
        }
        NextItem next = end.getNext();
        start.setNext(next);
        if (next == null) {
            this.last = start;
        }
        this.count -= counter;
    }

    public NextItem replaceAfter(NextItem index, NextItem newItem) {
        NextItem target = index.getNext();
        if (target != null) {
            NextItem next = target.getNext();
            if (next == null) {
                this.last = newItem;
            }
            newItem.setNext(next);
            index.setNext(newItem);
            target.clearItem();
        }
        return target;
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.toArray());
    }

    public Pointer[] toPointerArray() {
        throw new NotSupportedException("Use toArray() method instead!");
    }

    public Object deepClone() {
        throw new NotSupportedException("Use clone() method instead!");
    }

    public Object[] toArray() {
        return this.toItemArray();
    }

    public RootIterator elementsIterator() {
        return new BaseLinkedListIterator();
    }

    protected NextItem iterGet(RootIterator rootIter) {
        BaseLinkedListIterator iter = (BaseLinkedListIterator)rootIter;
        if (iter.pointer == iter.end.getNext()) {
            throw new IteratorException("End of Iterator reached!");
        }
        return iter.pointer;
    }

    protected NextItem iterNext(RootIterator rootIter, int offset) {
        BaseLinkedListIterator iter = (BaseLinkedListIterator)rootIter;
        NextItem endNext = iter.end.getNext();
        if (offset < 0) {
            throw new IteratorException("Invalid argument: " + offset + " < 0");
        }
        if (iter.pointer == endNext) {
            throw new IteratorException("End of Iterator reached!");
        }
        int i = 0;
        while (i < offset) {
            if (iter.pointer == endNext) {
                throw new IteratorException("Specified position exceeds the end of Iterator!");
            }
            ++i;
            iter.pointer = iter.pointer.getNext();
        }
        iter.beforePointer = iter.pointer;
        iter.pointer = iter.pointer.getNext();
        return iter.beforePointer;
    }

    protected NextItem iterAdd(Object obj, RootIterator rootIter) {
        BaseLinkedListIterator iter = (BaseLinkedListIterator)rootIter;
        if (obj == null) {
            throw new IteratorException("An illegal attempt to add null element!");
        }
        if (this.count >= this.limit) {
            throw new IteratorException("The limit ot LinkedList exceeded!");
        }
        NextItem item = (NextItem)obj;
        if (this.count == 0) {
            item.setNext(null);
            this.first = item;
            iter.start = item;
            this.last = item;
        } else {
            if (iter.end == this.last) {
                this.last = item;
            }
            item.setNext(iter.end.getNext());
            iter.end.setNext(item);
        }
        ++this.count;
        iter.end = item;
        return item;
    }

    protected NextItem iterChange(Object obj, RootIterator rootIter) {
        BaseLinkedListIterator iter = (BaseLinkedListIterator)rootIter;
        if (obj == null) {
            throw new IteratorException("An illegal attempt to change an element to null!");
        }
        if (iter.pointer == iter.end.getNext()) {
            throw new IteratorException("End of Iterator reached!");
        }
        NextItem item = (NextItem)obj;
        NextItem old = iter.pointer;
        item.setNext(iter.pointer.getNext());
        iter.pointer = item;
        iter.beforePointer.setNext(iter.pointer);
        return old;
    }

    protected NextItem iterRemove(RootIterator rootIter) {
        BaseLinkedListIterator iter = (BaseLinkedListIterator)rootIter;
        if (iter.pointer == iter.end.getNext()) {
            throw new IteratorException("End of Iterator reached!");
        }
        if (this.count == 0) {
            throw new IteratorException("Iterator is empty!");
        }
        NextItem temp = iter.pointer;
        iter.pointer = iter.pointer.getNext();
        if (temp == iter.start) {
            if (iter.start == this.first) {
                this.first = iter.pointer;
            } else {
                iter.beforePointer.setNext(iter.pointer);
            }
            NextItem nextItem = iter.start = temp == iter.end ? null : iter.pointer;
            if (--this.count == 0) {
                iter.end = this.last = null;
            }
        } else {
            iter.beforePointer.setNext(iter.pointer);
            --this.count;
        }
        if (iter.end == temp) {
            boolean isLast = iter.end == this.last;
            iter.end = iter.beforePointer;
            if (isLast) {
                this.last = iter.end;
            }
        }
        temp.clearItem();
        return temp;
    }

    protected NextItem iterInsert(Object obj, RootIterator rootIter) {
        BaseLinkedListIterator iter = (BaseLinkedListIterator)rootIter;
        if (obj == null) {
            throw new IteratorException("An illegal attempt to add null element!");
        }
        if (this.count >= this.limit) {
            throw new IteratorException("The limit ot LinkedList exceeded!");
        }
        NextItem item = (NextItem)obj;
        item.setNext(iter.pointer);
        if (this.count == 0) {
            this.first = item;
            iter.start = item;
            this.last = item;
            iter.end = item;
        } else if (iter.pointer == iter.start) {
            if (iter.start == this.first) {
                this.first = item;
            }
            iter.start = item;
        } else if (iter.pointer == iter.end.getNext()) {
            if (iter.end == this.last) {
                this.last = item;
            }
            iter.end = item;
        }
        if (iter.beforePointer != null) {
            iter.beforePointer.setNext(item);
        }
        iter.pointer = item;
        ++this.count;
        return item;
    }

    protected int iterSize(RootIterator rootIter) {
        BaseLinkedListIterator iter = (BaseLinkedListIterator)rootIter;
        NextItem endNext = iter.end.getNext();
        int counter = 0;
        if (iter.start == null || iter.start == iter.end) {
            return 0;
        }
        NextItem ptr = iter.start;
        while (ptr != endNext) {
            if (ptr == null) {
                throw new IteratorException("Start of Iterator was set after its end!");
            }
            ++counter;
            ptr = ptr.getNext();
        }
        return counter;
    }

    protected class BaseLinkedListIterator
    implements ForwardIterator {
        protected NextItem start;
        protected NextItem end;
        protected NextItem pointer;
        protected NextItem beforePointer;

        protected BaseLinkedListIterator() {
            this.start = BaseLinkedList.this.first;
            this.end = BaseLinkedList.this.last;
            this.pointer = this.start;
            this.beforePointer = null;
        }

        public Object get() {
            return BaseLinkedList.this.iterGet(this);
        }

        public boolean isAtBegin() {
            return this.start == null ? true : this.pointer == this.start;
        }

        public boolean isAtEnd() {
            return this.end == null ? true : this.pointer == this.end.getNext();
        }

        public RootDataStructure getDataStructure() {
            return BaseLinkedList.this;
        }

        public Object next() {
            return BaseLinkedList.this.iterNext(this, 0);
        }

        public Object next(int n) {
            return BaseLinkedList.this.iterNext(this, n);
        }

        public void setStartFromIterator(RootIterator iterator) {
            BaseLinkedListIterator blli = (BaseLinkedListIterator)iterator;
            if (BaseLinkedList.this != blli.getDataStructure()) {
                throw new IteratorException("An attempt to set start from an Iterator over a different LinkedList instance!");
            }
            NextItem newPointer = blli.pointer;
            if (newPointer == null) {
                throw new IteratorException("Illegal argument: pointer == null");
            }
            this.pointer = this.start = newPointer;
            this.beforePointer = blli.beforePointer;
        }

        public void setEndFromIterator(RootIterator iterator) {
            BaseLinkedListIterator blli = (BaseLinkedListIterator)iterator;
            if (BaseLinkedList.this != blli.getDataStructure()) {
                throw new IteratorException("An attempt to set end from an Iterator over a different LinkedList instance!");
            }
            NextItem newPointer = blli.beforePointer;
            if (this.pointer == null) {
                throw new IteratorException("End of Iterator reached!");
            }
            if (newPointer == null) {
                throw new IteratorException("An attempt to set the end from an exhausted Iterator!");
            }
            this.end = newPointer;
        }

        public Object add(Object obj) {
            return BaseLinkedList.this.iterAdd(obj, this);
        }

        public Object change(Object obj) {
            return BaseLinkedList.this.iterChange(obj, this);
        }

        public Object remove() {
            return BaseLinkedList.this.iterRemove(this);
        }

        public Object insert(Object obj) {
            return BaseLinkedList.this.iterInsert(obj, this);
        }

        public int size() {
            return BaseLinkedList.this.iterSize(this);
        }

        public boolean isInsertable() {
            return true;
        }

        public boolean isRemoveable() {
            return true;
        }

        public boolean isChangeable() {
            return true;
        }

        public boolean isAddable() {
            return true;
        }
    }
}

