/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.PoolInstanceCreator;

public abstract class PoolObject
implements PoolInstanceCreator {
    protected int capacityIncrement;
    protected int limit;
    protected int elementCount;
    protected Object[] pool;

    public PoolObject() {
        this.pool = new Object[1];
        this.setLimit(0);
    }

    public PoolObject(int initialSize) {
        this(initialSize, 0, 0);
    }

    public PoolObject(int initialSize, int capacityIncrement) {
        this(initialSize, capacityIncrement, 0);
    }

    public PoolObject(int initialSize, int capacityIncrement, int limit) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Initial size must be positive!");
        }
        this.capacityIncrement = capacityIncrement;
        this.pool = new Object[initialSize];
        int i = 0;
        while (i < initialSize) {
            this.pool[i] = this.newInstance();
            ++i;
        }
        this.elementCount = initialSize;
        this.setLimit(limit);
    }

    public synchronized void setLimit(int lim) {
        int n = this.limit = lim <= 0 ? Integer.MAX_VALUE : lim;
        if (this.limit < this.pool.length) {
            Object[] oldPool = this.pool;
            this.pool = new Object[this.limit];
            if (this.elementCount > this.limit) {
                this.elementCount = this.limit;
            }
            System.arraycopy(oldPool, 0, this.pool, 0, this.elementCount);
        }
    }

    public Object getObject() {
        Object temp = null;
        PoolObject poolObject = this;
        synchronized (poolObject) {
            if (this.elementCount != 0) {
                temp = this.pool[--this.elementCount];
                this.pool[this.elementCount] = null;
            }
        }
        return temp == null ? this.newInstance() : temp;
    }

    public synchronized void releaseObject(Object item) {
        if (this.elementCount < this.limit) {
            if (this.elementCount == this.pool.length) {
                int newCapacity;
                int n = newCapacity = this.capacityIncrement > 0 ? this.pool.length + this.capacityIncrement : this.pool.length << 1;
                if (newCapacity > this.limit) {
                    newCapacity = this.limit;
                }
                Object[] oldPool = this.pool;
                this.pool = new Object[newCapacity];
                System.arraycopy(oldPool, 0, this.pool, 0, this.elementCount);
            }
            this.pool[this.elementCount++] = item;
        }
    }

    public synchronized void freeMemory() {
        this.pool = new Object[1];
        this.elementCount = 0;
    }

    public synchronized void freeMemory(int count) {
        if (count <= 0) {
            count = 1;
        }
        if (this.pool.length > count) {
            Object[] oldPool = this.pool;
            this.pool = new Object[count];
            if (this.elementCount > count) {
                this.elementCount = count;
            }
            System.arraycopy(oldPool, 0, this.pool, 0, this.elementCount);
        }
    }

    public synchronized String toString() {
        return "Pool: Objects = " + this.elementCount + " Capacity = " + this.pool.length + " Limit = " + this.limit + " Capacity increment = " + this.capacityIncrement;
    }

    public abstract Object newInstance();
}

