/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationInt;
import com.sap.engine.lib.util.IntHashHolder;
import com.sap.engine.lib.util.IntHashHolderImpl;
import com.sap.engine.lib.util.PrimeGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class HashMapIntMultiObject
implements Cloneable,
Serializable {
    protected int count;
    public static final int MULTI_FACTOR = 2;
    public static final float LOAD_FACTOR = 0.75f;
    public static final int INITIAL_CAPACITY = 13;
    public static final int GROW_STEP = 2;
    protected static final int LAST = -1;
    protected int growStep;
    protected int growSimpl;
    protected float loadFactor;
    protected IntHashHolder hasher;
    protected int simplIndex;
    protected int limit;
    protected int capacity;
    protected int multiFactor;
    protected transient int nextFree;
    protected transient int currentIndex;
    protected transient int[] keys;
    protected transient Object[][] elements;
    protected transient int[] nextPtr;

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public HashMapIntMultiObject() {
        this(13, 2, 0.75f, 2, new IntHashHolderImpl());
    }

    public HashMapIntMultiObject(int initialCapacity) {
        this(initialCapacity, 2, 0.75f, 2, new IntHashHolderImpl());
    }

    public HashMapIntMultiObject(int initialCapacity, int multiFactor) {
        this(initialCapacity, 2, 0.75f, multiFactor, new IntHashHolderImpl());
    }

    public HashMapIntMultiObject(int initialCapacity, int growStep, float loadFactor, int multiFactor, IntHashHolder hasher) {
        if (multiFactor < 1) {
            throw new IllegalArgumentException("The Number of Values per Key must be greater than zero !");
        }
        if (loadFactor > 1.0f || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("The Load Factor must be in the range (0.0,1.0] !");
        }
        if (growStep < 2) {
            throw new IllegalArgumentException("The Grow Step must be greater than one !");
        }
        this.growStep = growStep;
        this.growSimpl = growStep == 2 ? 4 : (growStep < 10 ? growStep + 4 : 13);
        this.loadFactor = loadFactor;
        this.multiFactor = multiFactor;
        this.hasher = hasher;
        this.simplIndex = 0;
        this.init(initialCapacity);
    }

    public EnumerationInt keys() {
        return new EnumerationInt(){
            private int i = 0;
            private int pos;
            private int counter;
            {
                this.pos = HashMapIntMultiObject.this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < HashMapIntMultiObject.this.count;
            }

            public int nextElement() {
                while (this.i < HashMapIntMultiObject.this.capacity) {
                    if (this.pos != -1) {
                        int result = HashMapIntMultiObject.this.keys[this.pos - HashMapIntMultiObject.this.capacity];
                        this.pos = HashMapIntMultiObject.this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = HashMapIntMultiObject.this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public int[] getAllKeys() {
        int index = 0;
        int[] result = new int[this.count];
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.keys[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public int[] getAllKeys(int[] result) {
        int index = 0;
        if (result.length < this.count) {
            result = new int[this.count];
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.keys[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public Enumeration elements(final int range) {
        if (range >= this.multiFactor) {
            throw new IllegalArgumentException("The range must be less than " + this.multiFactor + " !");
        }
        if (range < 0) {
            return new Enumeration(){
                private int i = 0;
                private int j = 0;
                private int pos;
                private int index;
                private int counter;
                {
                    this.pos = HashMapIntMultiObject.this.nextPtr[this.i];
                    this.index = this.pos - HashMapIntMultiObject.this.capacity;
                    this.counter = 0;
                }

                public boolean hasMoreElements() {
                    return this.counter < HashMapIntMultiObject.this.count;
                }

                /*
                 * Unable to fully structure code
                 */
                public Object nextElement() {
                    ** GOTO lbl12
                    {
                        if (this.j < HashMapIntMultiObject.this.multiFactor) {
                            return HashMapIntMultiObject.this.elements[this.index][this.j++];
                        }
                        this.j = 0;
                        this.pos = HashMapIntMultiObject.this.nextPtr[this.pos];
                        this.index = this.pos - HashMapIntMultiObject.this.capacity;
                        ++this.counter;
                        do {
                            if (this.pos != -1) continue block0;
                            this.pos = HashMapIntMultiObject.this.nextPtr[++this.i];
                            this.index = this.pos - HashMapIntMultiObject.this.capacity;
lbl12:
                            // 2 sources

                        } while (this.i < HashMapIntMultiObject.this.capacity);
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        return new Enumeration(){
            private int i = 0;
            private int pos;
            private int counter;
            {
                this.pos = HashMapIntMultiObject.this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < HashMapIntMultiObject.this.count;
            }

            public Object nextElement() {
                while (this.i < HashMapIntMultiObject.this.capacity) {
                    if (this.pos != -1) {
                        Object result = HashMapIntMultiObject.this.elements[this.pos - HashMapIntMultiObject.this.capacity][range];
                        this.pos = HashMapIntMultiObject.this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = HashMapIntMultiObject.this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Object[][] getAllValues() {
        int index = 0;
        Object[][] result = new Object[this.count][this.multiFactor];
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                System.arraycopy(this.elements, pos - this.capacity, result, index++, 1);
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public Object[] getAllValues(int range) {
        return this.getAllValues(new Object[this.count], range);
    }

    public Object[] getAllValues(Object[] result, int range) {
        int index = 0;
        if (result.length < this.count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.count);
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.elements[pos - this.capacity][range];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public boolean contains(Object value, int range) {
        if (range < 0) {
            int i = 0;
            while (i < this.capacity) {
                int pos = this.nextPtr[i];
                while (pos != -1) {
                    int index = pos - this.capacity;
                    int j = 0;
                    while (j < this.multiFactor) {
                        if (HashMapIntMultiObject.equals(value, this.elements[index][j])) {
                            return true;
                        }
                        ++j;
                    }
                    pos = this.nextPtr[pos];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.capacity) {
                int pos = this.nextPtr[i];
                while (pos != -1) {
                    if (HashMapIntMultiObject.equals(value, this.elements[pos - this.capacity][range])) {
                        return true;
                    }
                    pos = this.nextPtr[pos];
                }
                ++i;
            }
        }
        return false;
    }

    public boolean containsValue(Object value, int range) {
        return this.contains(value, range);
    }

    public boolean containsKey(int key) {
        int pos = this.nextPtr[this.hasher.hash(key) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity] == key) {
                return true;
            }
            pos = this.nextPtr[pos];
        }
        return false;
    }

    public boolean seek(int key) {
        int pos = this.nextPtr[this.hasher.hash(key) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity] == key) {
                this.currentIndex = pos - this.capacity;
                return true;
            }
            pos = this.nextPtr[pos];
        }
        return false;
    }

    public void clear() {
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        int i3 = 0;
        while (i3 < this.limit) {
            int j = 0;
            while (j < this.multiFactor) {
                this.elements[i3][j] = null;
                ++j;
            }
            ++i3;
        }
        this.nextFree = this.capacity;
        this.currentIndex = -1;
        this.count = 0;
    }

    public Object clone() {
        try {
            HashMapIntMultiObject result = (HashMapIntMultiObject)super.clone();
            result.nextPtr = new int[this.nextPtr.length];
            result.keys = new int[this.keys.length];
            result.elements = new Object[this.elements.length][this.multiFactor];
            System.arraycopy(this.nextPtr, 0, result.nextPtr, 0, this.nextPtr.length);
            System.arraycopy(this.keys, 0, result.keys, 0, this.keys.length);
            System.arraycopy(this.elements, 0, result.elements, 0, this.elements.length);
            return result;
        }
        catch (CloneNotSupportedException _) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashMapIntMultiObject)) {
            return false;
        }
        HashMapIntMultiObject t = (HashMapIntMultiObject)o;
        if (t.count != this.count || t.multiFactor != this.multiFactor) {
            return false;
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                Object[] values = t.getAll(this.keys[index]);
                if (values == null) {
                    return false;
                }
                int j = 0;
                while (j < this.multiFactor) {
                    if (!HashMapIntMultiObject.equals(this.elements[index][j], values[j])) {
                        return false;
                    }
                    ++j;
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return true;
    }

    protected static final boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public void shrink() {
        this.shrink(0.75f);
    }

    public void shrink(float shrinkFactor) {
        if (shrinkFactor <= 0.0f || shrinkFactor > 1.0f) {
            throw new IllegalArgumentException("The Shrink Factor must be in the range (0.0,1.0] !");
        }
        int newCapacity = (int)((float)this.count / (this.loadFactor * shrinkFactor));
        long l = PrimeGenerator.getClosestPrime(newCapacity);
        this.simplIndex = (int)(l >> 32);
        newCapacity = (int)l;
        if (newCapacity < this.capacity) {
            int oldCapacity = this.capacity;
            int[] oldPtr = this.nextPtr;
            int[] oldKeys = this.keys;
            Object[][] oldElements = this.elements;
            this.init(newCapacity);
            int i = 0;
            while (i < oldCapacity) {
                int pos = oldPtr[i];
                while (pos != -1) {
                    int index = pos - oldCapacity;
                    this.putQuick(oldKeys[index], oldElements[index]);
                    pos = oldPtr[pos];
                }
                ++i;
            }
        }
    }

    public void put(int key, Object[] values) {
        if (values.length != this.multiFactor) {
            throw new IllegalArgumentException("The number of values per key must be : " + this.multiFactor);
        }
        if (this.count == this.limit) {
            this.rehash();
        }
        int pos = this.hasher.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            if (this.keys[(pos = this.nextPtr[pos]) - this.capacity] != key) continue;
            System.arraycopy(values, 0, this.elements[pos - this.capacity], 0, values.length);
            return;
        }
        int index = this.nextFree - this.capacity;
        this.keys[index] = key;
        System.arraycopy(values, 0, this.elements[index], 0, values.length);
        this.nextPtr[pos] = this.nextFree;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    protected void putQuick(int key, Object[] values) {
        int pos = this.hasher.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            pos = this.nextPtr[pos];
        }
        int index = this.nextFree - this.capacity;
        this.keys[index] = key;
        System.arraycopy(values, 0, this.elements[index], 0, values.length);
        this.nextPtr[pos] = this.nextFree;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    public boolean modify(int key, Object[] values) {
        if (values.length != this.multiFactor) {
            throw new IllegalArgumentException("The number of values per key must be : " + this.multiFactor);
        }
        int pos = this.hasher.hash(key) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            if (this.keys[(pos = this.nextPtr[pos]) - this.capacity] != key) continue;
            System.arraycopy(values, 0, this.elements[pos - this.capacity], 0, values.length);
            return true;
        }
        return false;
    }

    public Object modify(int index, Object value) {
        Object tmp = this.elements[this.currentIndex][index];
        this.elements[this.currentIndex][index] = value;
        return tmp;
    }

    public Object get(int index) {
        return this.elements[this.currentIndex][index];
    }

    public Object[] getAll(int key) {
        int pos = this.nextPtr[this.hasher.hash(key) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity] == key) {
                return this.elements[pos - this.capacity];
            }
            pos = this.nextPtr[pos];
        }
        return null;
    }

    public boolean remove(int key) {
        int prevPos = this.hasher.hash(key) % this.capacity;
        int pos = this.nextPtr[prevPos];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index] == key) {
                int j = 0;
                while (j < this.multiFactor) {
                    this.elements[index][j] = null;
                    ++j;
                }
                this.nextPtr[prevPos] = this.nextPtr[pos];
                this.nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return true;
            }
            prevPos = pos;
            pos = this.nextPtr[pos];
        }
        return false;
    }

    protected void init(int initialCapacity) {
        if (this.growStep > 17) {
            this.capacity = (int)PrimeGenerator.getClosestPrime(initialCapacity);
        } else {
            long l = PrimeGenerator.getClosestPrime(initialCapacity, this.simplIndex);
            this.simplIndex = (int)(l >> 32) + this.growSimpl;
            this.capacity = (int)l;
        }
        this.limit = (int)((float)this.capacity * this.loadFactor);
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new int[this.limit];
        this.elements = new Object[this.limit][this.multiFactor];
        this.nextFree = this.capacity;
        this.currentIndex = -1;
        this.count = 0;
    }

    protected void rehash() {
        int[] oldKeys = this.keys;
        Object[][] oldElements = this.elements;
        this.init(this.capacity * this.growStep);
        int i = 0;
        while (i < oldKeys.length) {
            this.putQuick(oldKeys[i], oldElements[i]);
            ++i;
        }
    }

    public String toString() {
        int c = 0;
        int lim = this.multiFactor - 1;
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                buf.append(this.keys[index]);
                buf.append('=');
                int j = 0;
                while (j < lim) {
                    buf.append(this.elements[index][j]);
                    buf.append(',');
                    ++j;
                }
                buf.append(this.elements[index][lim]);
                if (++c < this.count) {
                    buf.append("; ");
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }

    public void setHasher(IntHashHolder hasher) {
        this.hasher = hasher;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                int j = 0;
                while (j < this.multiFactor) {
                    stream.writeObject(this.elements[index][j]);
                    ++j;
                }
                stream.writeInt(this.keys[index]);
                pos = this.nextPtr[pos];
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new int[this.limit];
        this.elements = new Object[this.limit][this.multiFactor];
        this.nextFree = this.capacity;
        this.currentIndex = -1;
        int size = this.count;
        this.count = 0;
        Object[] values = new Object[this.multiFactor];
        int i3 = 0;
        while (i3 < size) {
            int j = 0;
            while (j < this.multiFactor) {
                values[j] = stream.readObject();
                ++j;
            }
            this.putQuick(stream.readInt(), values);
            ++i3;
        }
    }
}

