/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ConcurrentReadHashMap
implements Cloneable,
Serializable {
    public static final float LOAD_FACTOR = 0.75f;
    public static final int INITIAL_CAPACITY = 13;
    public static final int GROW_STEP = 2;
    private static final int LAST = -1;
    private int growStep;
    private int growSimpl;
    private float loadFactor;
    private int simplIndex;
    private int limit;
    private int capacity;
    private int count;
    private transient int nextFree;
    private transient DataHolder holder;
    private static final int[] primes = new int[]{13, 17, 19, 23, 29, 31, 37, 43, 53, 61, 73, 89, 107, 127, 149, 179, 223, 257, 307, 367, 439, 523, 631, 757, 907, 1087, 1301, 1559, 1871, 2243, 2689, 3229, 3877, 4649, 5581, 6689, 8039, 9631, 11579, 13873, 16649, 19973, 23971, 28753, 34511, 41411, 49697, 59621, 71549, 85853, 103043, 123631, 148361, 178021, 213623, 256349, 307627, 369137, 442961, 531569, 637873, 765437, 918529, 1102237, 1322669, 1587221, 1904647, 2285581, 2742689, 3291221, 3949469, 4739363, 5687237, 6824669, 8189603, 9827537, 11793031, 14151629, 16981957, 20378357, 24454013, 29344823, 35213777, 42256531, 50707837, 60849407, 73019327, 87623147, 105147773, 126177323, 151412791, 181695341, 218034407, 261641287, 313969543, 376763459, 452116163, 542539391, 651047261, 781256711, 937508041, 1125009637, 1350011569, 1620013909, 1944016661, Integer.MAX_VALUE};

    public ConcurrentReadHashMap() {
        this(13, 2, 0.75f);
    }

    public ConcurrentReadHashMap(int initialCapacity) {
        this(initialCapacity, 2, 0.75f);
    }

    public ConcurrentReadHashMap(int initialCapacity, int growStep, float loadFactor) {
        if ((double)loadFactor > 1.0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Load Factor = " + loadFactor);
        }
        if (growStep <= 1) {
            throw new IllegalArgumentException("Grow step = " + growStep);
        }
        this.growStep = growStep;
        this.growSimpl = growStep == 2 ? 4 : (growStep < 10 ? growStep + 4 : 13);
        this.loadFactor = loadFactor;
        this.simplIndex = 0;
        this.holder = new DataHolder();
        this.init(this.holder, initialCapacity);
    }

    public Enumeration keys() {
        return new Enumeration(){
            Object[] keys;
            int[] nextPtr;
            private int i;
            private int pos;
            private int counter;
            {
                this.keys = ((ConcurrentReadHashMap)ConcurrentReadHashMap.this).holder.keys;
                this.nextPtr = ((ConcurrentReadHashMap)ConcurrentReadHashMap.this).holder.nextPtr;
                this.i = 0;
                this.pos = this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < ConcurrentReadHashMap.this.count;
            }

            public Object nextElement() {
                while (this.i < ConcurrentReadHashMap.this.capacity) {
                    if (this.pos != -1) {
                        Object result = this.keys[this.pos - ConcurrentReadHashMap.this.capacity];
                        this.pos = this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public synchronized Object[] getAllKeys() {
        Object[] keys = this.holder.keys;
        int[] nextPtr = this.holder.nextPtr;
        int index = 0;
        Object[] result = new Object[this.count];
        int i = 0;
        while (i < this.capacity) {
            int pos = nextPtr[i];
            while (pos != -1) {
                result[index++] = keys[pos - this.capacity];
                pos = nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public Enumeration elements() {
        return new Enumeration(){
            Object[] elements;
            int[] nextPtr;
            private int i;
            private int pos;
            private int counter;
            {
                this.elements = ((ConcurrentReadHashMap)ConcurrentReadHashMap.this).holder.elements;
                this.nextPtr = ((ConcurrentReadHashMap)ConcurrentReadHashMap.this).holder.nextPtr;
                this.i = 0;
                this.pos = this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < ConcurrentReadHashMap.this.count;
            }

            public Object nextElement() {
                while (this.i < ConcurrentReadHashMap.this.capacity) {
                    if (this.pos != -1) {
                        Object result = this.elements[this.pos - ConcurrentReadHashMap.this.capacity];
                        this.pos = this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public synchronized Object[] getAllValues() {
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int index = 0;
        Object[] result = new Object[this.count];
        int i = 0;
        while (i < this.capacity) {
            int pos = nextPtr[i];
            while (pos != -1) {
                result[index++] = elements[pos - this.capacity];
                pos = nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public synchronized boolean contains(Object value) {
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int i = 0;
        while (i < this.capacity) {
            int pos = nextPtr[i];
            while (pos != -1) {
                if (elements[pos - this.capacity].equals(value)) {
                    return true;
                }
                pos = nextPtr[pos];
            }
            ++i;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public synchronized void clear() {
        Object[] keys = this.holder.keys;
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int i = 0;
        while (i < this.capacity) {
            nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < nextPtr.length) {
            nextPtr[i2++] = i2;
        }
        int i3 = 0;
        while (i3 < elements.length) {
            keys[i3] = null;
            elements[i3] = null;
            ++i3;
        }
        this.nextFree = this.capacity;
        this.count = 0;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        DataHolder active = this.holder;
        Object[] keys = active.keys;
        Object[] elements = active.elements;
        int[] nextPtr = active.nextPtr;
        ConcurrentReadHashMap result = null;
        result = (ConcurrentReadHashMap)super.clone();
        Object[] rKeys = new Object[keys.length];
        Object[] rElements = new Object[elements.length];
        int[] rNextPtr = new int[nextPtr.length];
        DataHolder newHolder = new DataHolder();
        newHolder.keys = rKeys;
        newHolder.elements = rElements;
        newHolder.nextPtr = rNextPtr;
        result.holder = newHolder;
        System.arraycopy(nextPtr, 0, rNextPtr, 0, nextPtr.length);
        System.arraycopy(keys, 0, rKeys, 0, keys.length);
        System.arraycopy(elements, 0, rElements, 0, elements.length);
        return result;
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConcurrentReadHashMap)) {
            return false;
        }
        ConcurrentReadHashMap t = (ConcurrentReadHashMap)object;
        if (t.count != this.count) {
            return false;
        }
        Object[] keys = this.holder.keys;
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int i = 0;
        while (i < this.capacity) {
            int pos = nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                Object temp = t.get(keys[index]);
                if (temp == null) {
                    return false;
                }
                if (!elements[index].equals(temp)) {
                    return false;
                }
                pos = nextPtr[pos];
            }
            ++i;
        }
        return true;
    }

    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException("Value can not be null.");
        }
        if (this.count == this.limit) {
            this.rehash();
        }
        Object[] keys = this.holder.keys;
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int pos = ConcurrentReadHashMap.hash(key.hashCode()) % this.capacity;
        while (nextPtr[pos] != -1) {
            int index = (pos = nextPtr[pos]) - this.capacity;
            if (!keys[index].equals(key)) continue;
            Object temp = elements[index];
            elements[index] = value;
            return temp;
        }
        int newSlot = this.nextFree;
        int newIndex = newSlot - this.capacity;
        keys[newIndex] = key;
        elements[newIndex] = value;
        this.nextFree = nextPtr[this.nextFree];
        nextPtr[newSlot] = -1;
        nextPtr[pos] = newSlot;
        ++this.count;
        return null;
    }

    public synchronized Object put(Object key, Object value, int hash) {
        if (value == null) {
            throw new NullPointerException("Value can not be null.");
        }
        if (this.count == this.limit) {
            this.rehash();
        }
        Object[] keys = this.holder.keys;
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int pos = hash % this.capacity;
        while (nextPtr[pos] != -1) {
            int index = (pos = nextPtr[pos]) - this.capacity;
            if (!keys[index].equals(key)) continue;
            Object temp = elements[index];
            elements[index] = value;
            return temp;
        }
        int newSlot = this.nextFree;
        int newIndex = newSlot - this.capacity;
        keys[newIndex] = key;
        elements[newIndex] = value;
        this.nextFree = nextPtr[this.nextFree];
        nextPtr[newSlot] = -1;
        nextPtr[pos] = newSlot;
        ++this.count;
        return null;
    }

    public Object get(Object key) {
        DataHolder active = this.holder;
        Object[] keys = active.keys;
        int[] nextPtr = active.nextPtr;
        int cap = active.capacity;
        int pos = nextPtr[ConcurrentReadHashMap.hash(key.hashCode()) % cap];
        while (pos != -1) {
            int index = pos - cap;
            if (keys[index].equals(key)) {
                return active.elements[index];
            }
            pos = nextPtr[pos];
        }
        return null;
    }

    public Object get(Object key, int hash) {
        DataHolder active = this.holder;
        Object[] keys = active.keys;
        int[] nextPtr = active.nextPtr;
        int cap = active.capacity;
        int pos = nextPtr[hash % cap];
        while (pos != -1) {
            int index = pos - cap;
            if (keys[index].equals(key)) {
                return active.elements[index];
            }
            pos = nextPtr[pos];
        }
        return null;
    }

    public synchronized Object remove(Object key) {
        Object[] keys = this.holder.keys;
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int prevPos = ConcurrentReadHashMap.hash(key.hashCode()) % this.capacity;
        int pos = nextPtr[prevPos];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (keys[index].equals(key)) {
                nextPtr[prevPos] = nextPtr[pos];
                Object result = elements[index];
                keys[index] = null;
                elements[index] = null;
                nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return result;
            }
            prevPos = pos;
            pos = nextPtr[pos];
        }
        return null;
    }

    public synchronized Object remove(Object key, int hash) {
        Object[] keys = this.holder.keys;
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int prevPos = hash % this.capacity;
        int pos = nextPtr[prevPos];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (keys[index].equals(key)) {
                nextPtr[prevPos] = nextPtr[pos];
                Object result = elements[index];
                keys[index] = null;
                elements[index] = null;
                nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return result;
            }
            prevPos = pos;
            pos = nextPtr[pos];
        }
        return null;
    }

    private void init(DataHolder initHolder, int initialCapacity) {
        if (this.growStep > 17) {
            this.capacity = (int)ConcurrentReadHashMap.getClosestPrime(initialCapacity);
        } else {
            long l = ConcurrentReadHashMap.getClosestPrime(initialCapacity, this.simplIndex);
            this.simplIndex = (int)(l >> 32) + this.growSimpl;
            this.capacity = (int)l;
        }
        this.limit = (int)((float)this.capacity * this.loadFactor);
        initHolder.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            initHolder.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < initHolder.nextPtr.length) {
            initHolder.nextPtr[i2++] = i2;
        }
        initHolder.keys = new Object[this.limit];
        initHolder.elements = new Object[this.limit];
        initHolder.capacity = this.capacity;
        this.nextFree = this.capacity;
        this.count = 0;
    }

    private void rehash() {
        DataHolder newHolder = new DataHolder();
        this.init(newHolder, this.capacity * this.growStep);
        Object[] keys = newHolder.keys;
        Object[] elements = newHolder.elements;
        int[] nextPtr = newHolder.nextPtr;
        Object[] oldKeys = this.holder.keys;
        Object[] oldElements = this.holder.elements;
        int i = 0;
        while (i < oldKeys.length) {
            int pos = ConcurrentReadHashMap.hash(oldKeys[i].hashCode()) % this.capacity;
            int newSlot = this.nextFree;
            int newIndex = this.nextFree - this.capacity;
            this.nextFree = nextPtr[this.nextFree];
            nextPtr[newSlot] = nextPtr[pos];
            nextPtr[pos] = newSlot;
            keys[newIndex] = oldKeys[i];
            elements[newIndex] = oldElements[i];
            ++this.count;
            ++i;
        }
        this.holder = newHolder;
    }

    public synchronized String toString() {
        Object[] keys = this.holder.keys;
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int c = 0;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i = 0;
        while (i < this.capacity) {
            int pos = nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                buf.append(keys[index] + "=" + elements[index]);
                if (++c < this.count) {
                    buf.append(", ");
                }
                pos = nextPtr[pos];
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Object[] keys = this.holder.keys;
        Object[] elements = this.holder.elements;
        int[] nextPtr = this.holder.nextPtr;
        int i = 0;
        while (i < this.capacity) {
            int pos = nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                stream.writeObject(keys[index]);
                stream.writeObject(elements[index]);
                pos = nextPtr[pos];
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int[] nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < nextPtr.length) {
            nextPtr[i2++] = i2;
        }
        Object[] keys = new Object[this.limit];
        Object[] elements = new Object[this.limit];
        this.nextFree = this.capacity;
        int size = this.count;
        this.count = 0;
        int i3 = 0;
        while (i3 < size) {
            Object key = stream.readObject();
            Object element = stream.readObject();
            int pos = ConcurrentReadHashMap.hash(key.hashCode()) % this.capacity;
            int newSlot = this.nextFree;
            int newIndex = this.nextFree - this.capacity;
            this.nextFree = nextPtr[this.nextFree];
            nextPtr[newSlot] = nextPtr[pos];
            nextPtr[pos] = newSlot;
            keys[newIndex] = key;
            elements[newIndex] = element;
            ++this.count;
            ++i3;
        }
        this.holder = new DataHolder();
        this.holder.capacity = this.capacity;
        this.holder.nextPtr = nextPtr;
        this.holder.keys = keys;
        this.holder.elements = elements;
    }

    public Object[] toArray() {
        return this.getAllValues();
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private static final int hash(int key) {
        return key & Integer.MAX_VALUE;
    }

    private static final long getClosestPrime(int key) {
        int low = 0;
        int high = primes.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = primes[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return (long)mid << 32 | (long)primes[mid];
        }
        return (long)low << 32 | (long)primes[low];
    }

    private static final long getClosestPrime(int key, int startPos) {
        int i = startPos < primes.length ? startPos : primes.length;
        while (primes[i] < key) {
            ++i;
        }
        return (long)i << 32 | (long)primes[i];
    }

    private static class DataHolder {
        public Object[] keys;
        public Object[] elements;
        public int[] nextPtr;
        public int capacity;

        private DataHolder() {
        }
    }
}

