/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.AbstractDataStructure;
import com.sap.engine.lib.util.DeepCloneable;
import com.sap.engine.lib.util.NotSupportedException;
import com.sap.engine.lib.util.RootDataStructure;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.IteratorException;
import com.sap.engine.lib.util.iterators.RandomAccessIterator;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.NoSuchElementException;

public class ArrayObject
extends AbstractDataStructure {
    protected transient Object[] elementData;
    protected int capacityIncrement;

    public ArrayObject(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public ArrayObject(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ArrayObject() {
        this(10);
    }

    public ArrayObject(Object[] array, int offset, int length, int capacityIncrement) {
        this.elementData = new Object[length];
        System.arraycopy(array, offset, this.elementData, 0, length);
        this.capacityIncrement = capacityIncrement;
        this.count = length;
    }

    public ArrayObject(Object[] array) {
        this(array, 0, array.length, 0);
    }

    public ArrayObject(ArrayObject arrayObject, int offset, int length, int capacityIncrement) {
        this(length, capacityIncrement);
        arrayObject.copyInto(offset, this.elementData, 0, length);
        this.count = length;
    }

    public ArrayObject(ArrayObject arrayObject) {
        this.elementData = arrayObject.toArray();
        this.count = this.elementData.length;
    }

    public void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.count);
    }

    public void copyInto(int index, Object[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(this.elementData, index, array, offset, length);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.count < oldCapacity) {
            Object[] newData = new Object[this.count];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    protected void ensureCapacity(int minCapacity) {
        int capacity = this.elementData.length;
        if (minCapacity > capacity) {
            int n = capacity = this.capacityIncrement > 0 ? capacity + this.capacityIncrement : capacity << 1;
            if (capacity < minCapacity) {
                capacity = minCapacity;
            }
            Object[] newData = new Object[capacity];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Illegal newSize: " + newSize);
        }
        if (newSize > this.count) {
            this.ensureCapacity(newSize);
        } else {
            int i = newSize;
            while (i < this.count) {
                this.elementData[i] = null;
                ++i;
            }
        }
        this.count = newSize;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(Object elem, int index) {
        int i = index;
        while (i < this.count) {
            boolean bl = elem == null ? this.elementData[i] == null : elem.equals(this.elementData[i]);
            if (bl) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.count - 1);
    }

    public int lastIndexOf(Object elem, int index) {
        int i = index;
        while (i >= 0) {
            boolean bl = elem == null ? this.elementData[i] == null : elem.equals(this.elementData[i]);
            if (bl) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Object elementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public Object firstElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public Object lastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.count - 1];
    }

    public void setElementAt(Object value, int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        this.elementData[index] = value;
    }

    public void removeElementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        this.elementData[--this.count] = null;
    }

    public Object removeLastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        Object last = this.elementData[--this.count];
        this.elementData[this.count] = null;
        return last;
    }

    public void insertElementAt(Object value, int index) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.count);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.count - index);
        this.elementData[index] = value;
        ++this.count;
    }

    public void addElement(Object value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public boolean removeElement(Object value) {
        int i = this.indexOf(value);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.count) {
            this.elementData[i] = null;
            ++i;
        }
        this.count = 0;
    }

    public Object clone() {
        ArrayObject v = (ArrayObject)super.clone();
        v.elementData = new Object[this.count];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.count);
        return v;
    }

    public Object deepClone() {
        ArrayObject v = (ArrayObject)super.clone();
        v.elementData = new Object[this.count];
        int i = 0;
        while (i < this.count) {
            v.elementData[i] = ((DeepCloneable)this.elementData[i]).deepClone();
            ++i;
        }
        return v;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.count];
        System.arraycopy(this.elementData, 0, result, 0, this.count);
        return result;
    }

    public Object[] toArray(Object[] result) {
        if (result.length < this.count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.count);
        }
        System.arraycopy(this.elementData, 0, result, 0, this.count);
        return result;
    }

    public Object get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public Object set(int index, Object element) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        Object oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public void add(Object value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public Object remove(int index) {
        return this.removeAt(index);
    }

    public boolean remove(Object value) {
        return this.removeElement(value);
    }

    public void add(int index, Object element) {
        this.insertElementAt(element, index);
    }

    public Object removeAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        Object oldValue = this.elementData[index];
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        this.elementData[--this.count] = null;
        return oldValue;
    }

    public void clear() {
        this.removeAllElements();
    }

    public int hashCode() {
        int theCode = 0;
        int i = 0;
        while (i < this.count) {
            theCode += i;
            if (this.elementData[i] != null) {
                theCode ^= this.elementData[i].hashCode();
            }
            ++i;
        }
        return theCode;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append("\n[ size = " + this.count + "; capacityIncrement = " + this.capacityIncrement + "; capacity = " + this.elementData.length + " ]\n the elements are: [ ");
        int i = 0;
        while (i < this.count - 1) {
            s.append(this.elementData[i] + ", ");
            ++i;
        }
        if (this.count != 0) {
            s.append(this.elementData[this.count - 1]);
        }
        s.append(" ]");
        return s.toString();
    }

    public boolean equals(Object arrayObject) {
        if (!(arrayObject instanceof ArrayObject)) {
            return false;
        }
        return ((ArrayObject)arrayObject).equals_(this);
    }

    protected boolean equals_(ArrayObject arrayObject) {
        if (this.count != arrayObject.count) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            boolean bl = this.elementData[i] == null ? arrayObject.elementData[i] != null : !this.elementData[i].equals(arrayObject.elementData[i]);
            if (bl) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.toArray());
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " >= " + toIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex + " > " + this.count);
        }
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.count - toIndex);
        int countOfElemToRemove = toIndex - fromIndex;
        int i = this.count - countOfElemToRemove;
        while (i < this.count) {
            this.elementData[i] = null;
            ++i;
        }
        this.count -= countOfElemToRemove;
    }

    public void sort() {
        this.qsort(0, this.count);
    }

    public void sort(boolean descending) {
        if (descending) {
            this.qsortDesc(0, this.count);
            return;
        }
        this.qsort(0, this.count);
    }

    public void sort(int fromIndex, int toIndex) {
        this.rangeCheck(fromIndex, toIndex);
        this.qsort(fromIndex, toIndex - fromIndex);
    }

    public void sort(int fromIndex, int toIndex, boolean descending) {
        this.rangeCheck(fromIndex, toIndex);
        if (descending) {
            this.qsortDesc(fromIndex, toIndex - fromIndex);
        } else {
            this.qsort(fromIndex, toIndex - fromIndex);
        }
    }

    private void qsortDesc(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && ((Comparable)this.elementData[j - 1]).compareTo(this.elementData[j]) < 0) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        Object v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && ((Comparable)this.elementData[b]).compareTo(v) >= 0) {
                if (((Comparable)this.elementData[b]).compareTo(v) == 0) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && ((Comparable)this.elementData[c]).compareTo(v) <= 0) {
                if (((Comparable)this.elementData[c]).compareTo(v) == 0) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsortDesc(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsortDesc(n - s, s);
        }
    }

    private void qsort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && ((Comparable)this.elementData[j - 1]).compareTo(this.elementData[j]) > 0) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        Object v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && ((Comparable)this.elementData[b]).compareTo(v) <= 0) {
                if (((Comparable)this.elementData[b]).compareTo(v) == 0) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && ((Comparable)this.elementData[c]).compareTo(v) >= 0) {
                if (((Comparable)this.elementData[c]).compareTo(v) == 0) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsort(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsort(n - s, s);
        }
    }

    private void swap(int a, int b) {
        Object temp = this.elementData[a];
        this.elementData[a] = this.elementData[b];
        this.elementData[b] = temp;
    }

    private void vecSwap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        return ((Comparable)this.elementData[a]).compareTo(this.elementData[b]) < 0 ? (((Comparable)this.elementData[b]).compareTo(this.elementData[c]) < 0 ? b : (((Comparable)this.elementData[a]).compareTo(this.elementData[c]) < 0 ? c : a)) : (((Comparable)this.elementData[b]).compareTo(this.elementData[c]) > 0 ? b : (((Comparable)this.elementData[a]).compareTo(this.elementData[c]) > 0 ? c : a));
    }

    public int binarySearch(Object key) {
        int low = 0;
        int high = this.count - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = this.elementData[mid];
            if (((Comparable)midVal).compareTo(key) < 0) {
                low = mid + 1;
                continue;
            }
            if (((Comparable)midVal).compareTo(key) > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    /*
     * Unable to fully structure code
     */
    public int binarySearch(Object key, boolean descending) {
        block6: {
            low = 0;
            high = this.count - 1;
            if (!descending) ** GOTO lbl24
            while (low <= high) {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (((Comparable)midVal).compareTo(key) > 0) {
                    low = mid + 1;
                    continue;
                }
                if (((Comparable)midVal).compareTo(key) < 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (((Comparable)midVal).compareTo(key) < 0) {
                    low = mid + 1;
                    continue;
                }
                if (((Comparable)midVal).compareTo(key) > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
lbl24:
                // 3 sources

                ** while (low <= high)
            }
        }
        return -(low + 1);
    }

    public int binarySearch(Object key, int low, int high) {
        this.rangeCheck(low, high + 1);
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = this.elementData[mid];
            if (((Comparable)midVal).compareTo(key) < 0) {
                low = mid + 1;
                continue;
            }
            if (((Comparable)midVal).compareTo(key) > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    /*
     * Unable to fully structure code
     */
    public int binarySearch(Object key, int low, int high, boolean descending) {
        block6: {
            this.rangeCheck(low, high + 1);
            if (!descending) ** GOTO lbl23
            while (low <= high) {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (((Comparable)midVal).compareTo(key) > 0) {
                    low = mid + 1;
                    continue;
                }
                if (((Comparable)midVal).compareTo(key) < 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                mid = low + high >>> 1;
                midVal = this.elementData[mid];
                if (((Comparable)midVal).compareTo(key) < 0) {
                    low = mid + 1;
                    continue;
                }
                if (((Comparable)midVal).compareTo(key) > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
lbl23:
                // 3 sources

                ** while (low <= high)
            }
        }
        return -(low + 1);
    }

    private void rangeCheck(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public void setAll(int index, ArrayObject arrayObject) {
        this.setAll(index, arrayObject, 0, arrayObject.size());
    }

    public void setAll(int index, ArrayObject arrayObject, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        arrayObject.copyInto(offset, this.elementData, index, length);
    }

    public void setAll(int index, Object[] array) {
        this.setAll(index, array, 0, array.length);
    }

    public void setAll(int index, Object[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(array, offset, this.elementData, index, length);
    }

    public void addAll(ArrayObject arrayObject) {
        this.addAll(arrayObject, 0, arrayObject.size());
    }

    public void addAll(ArrayObject arrayObject, int offset, int length) {
        this.ensureCapacity(this.count + length);
        arrayObject.copyInto(offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(Object[] array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(Object[] array, int offset, int length) {
        this.ensureCapacity(this.count + length);
        System.arraycopy(array, offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(int index, ArrayObject arrayObject) {
        this.addAll(index, arrayObject, 0, arrayObject.size());
    }

    public void addAll(int index, ArrayObject arrayObject, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        arrayObject.copyInto(offset, this.elementData, index, length);
        this.count += length;
    }

    public void addAll(int index, Object[] array) {
        this.addAll(index, array, 0, array.length);
    }

    public void addAll(int index, Object[] array, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        System.arraycopy(array, offset, this.elementData, index, length);
        this.count += length;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elementData.length);
        int i = 0;
        while (i < this.count) {
            stream.writeObject(this.elementData[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.elementData = new Object[stream.readInt()];
        int i = 0;
        while (i < this.count) {
            this.elementData[i] = stream.readObject();
            ++i;
        }
    }

    public RootIterator elementsIterator() {
        return new ArrayObjectIterator();
    }

    public Pointer[] toPointerArray() {
        throw new NotSupportedException("Use toArray() method instead!");
    }

    protected Object iterGet(int counter) {
        return this.elementData[counter];
    }

    protected Object iterAdd(Object obj, int pos) {
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.elementData, pos, this.elementData, pos + 1, this.count - pos);
        this.elementData[pos] = obj;
        ++this.count;
        return this.elementData[pos];
    }

    protected Object iterChange(Object obj, int counter) {
        Object old = this.elementData[counter];
        this.elementData[counter] = obj;
        return old;
    }

    protected Object iterRemove(int counter) {
        Object old = this.elementData[counter];
        int j = this.count - counter - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, counter + 1, this.elementData, counter, j);
        }
        this.elementData[--this.count] = null;
        return old;
    }

    protected class ArrayObjectIterator
    implements RandomAccessIterator {
        private int start = 0;
        private int end;
        private int counter;

        protected ArrayObjectIterator() {
            this.end = ArrayObject.this.count;
            this.counter = this.start;
        }

        public Object get() {
            if (this.counter >= this.end) {
                throw new IteratorException("End of Iterator reached: " + this.counter + " >= " + this.end);
            }
            return ArrayObject.this.iterGet(this.counter);
        }

        public boolean isAtBegin() {
            return this.counter == this.start;
        }

        public boolean isAtEnd() {
            return this.counter == this.end;
        }

        public RootDataStructure getDataStructure() {
            return ArrayObject.this;
        }

        public Object next() {
            if (this.counter >= this.end) {
                throw new IteratorException("End of Iterator reached: " + this.counter + " >= " + this.end);
            }
            return ArrayObject.this.iterGet(this.counter++);
        }

        public Object next(int n) {
            int tmp = this.counter + n;
            if (tmp >= this.end) {
                throw new IteratorException("Specified position exceeds the end of Iterator: " + tmp + " >= " + this.end);
            }
            if (tmp < this.start) {
                throw new IteratorException("Specified position is underneath the start of Iterator: " + tmp + " < " + this.start);
            }
            this.counter = tmp;
            return ArrayObject.this.iterGet(this.counter++);
        }

        public void setStartFromIterator(RootIterator iterator) {
            ArrayObjectIterator aoi = (ArrayObjectIterator)iterator;
            if (ArrayObject.this != aoi.getDataStructure()) {
                throw new IteratorException("An attempt to set start from an Iterator over a different ArrayObject instance!");
            }
            int tmp = aoi.counter;
            if (tmp > this.end) {
                throw new IteratorException("An attempt to set the start behind the end of the Iterator: " + tmp + " > " + this.end);
            }
            this.counter = this.start = tmp;
        }

        public void setEndFromIterator(RootIterator iterator) {
            ArrayObjectIterator aoi = (ArrayObjectIterator)iterator;
            if (ArrayObject.this != aoi.getDataStructure()) {
                throw new IteratorException("An attempt to set end from an Iterator over a different ArrayObject instance!");
            }
            int tmp = aoi.counter;
            if (tmp < this.counter) {
                throw new IteratorException("An attempt to set the end ahead of the current position of the Iterator: " + tmp + " < " + this.counter);
            }
            this.end = tmp;
        }

        public Object add(Object obj) {
            return ArrayObject.this.iterAdd(obj, this.end++);
        }

        public Object change(Object obj) {
            if (this.counter >= this.end) {
                throw new IteratorException("End of Iterator reached!");
            }
            return ArrayObject.this.iterChange(obj, this.counter);
        }

        public Object remove() {
            if (this.counter >= this.end) {
                throw new IteratorException("End of Iterator reached!");
            }
            --this.end;
            return ArrayObject.this.iterRemove(this.counter);
        }

        public Object insert(Object obj) {
            ++this.end;
            return ArrayObject.this.iterAdd(obj, this.counter);
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isInsertable() {
            return true;
        }

        public boolean isRemoveable() {
            return true;
        }

        public boolean isChangeable() {
            return true;
        }

        public boolean isAddable() {
            return true;
        }

        public Object prev() {
            if (this.counter <= this.start) {
                throw new IteratorException("Beginning of Iterator reached: " + this.counter + " <= " + this.start);
            }
            return ArrayObject.this.iterGet(--this.counter);
        }

        public Object prev(int n) {
            int tmp = this.counter - n;
            if (tmp > this.end) {
                throw new IteratorException("Specified position exceeds the end of Iterator: " + tmp + " > " + this.end);
            }
            if (tmp <= this.start) {
                throw new IteratorException("Specified position is underneath the start of Iterator: " + tmp + " <= " + this.start);
            }
            this.counter = tmp;
            return ArrayObject.this.iterGet(--this.counter);
        }

        public int currentPosition() {
            return this.counter;
        }

        public Object jumpTo(int n) {
            if (n > this.end) {
                throw new IteratorException("Specified position exceeds the end of Iterator: " + n + " > " + this.end);
            }
            if (n < this.start) {
                throw new IteratorException("Specified position is underneath the start of Iterator: " + n + " < " + this.start);
            }
            this.counter = n;
            return ArrayObject.this.iterGet(this.counter);
        }
    }
}

