/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.EnumerationFloat;
import com.sap.engine.lib.util.PrimitiveTypeDataStructure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class ArrayFloat
extends PrimitiveTypeDataStructure {
    protected transient float[] elementData;
    protected int capacityIncrement;

    public ArrayFloat(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new float[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public ArrayFloat(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ArrayFloat() {
        this(10);
    }

    public ArrayFloat(float[] array, int offset, int length, int capacityIncrement) {
        this.elementData = new float[length];
        System.arraycopy(array, offset, this.elementData, 0, length);
        this.capacityIncrement = capacityIncrement;
        this.count = length;
    }

    public ArrayFloat(float[] array) {
        this(array, 0, array.length, 0);
    }

    public ArrayFloat(ArrayFloat arrayFloat, int offset, int length, int capacityIncrement) {
        this(length, capacityIncrement);
        arrayFloat.copyInto(offset, this.elementData, 0, length);
        this.count = length;
    }

    public ArrayFloat(ArrayFloat arrayFloat) {
        this.elementData = arrayFloat.toArray();
        this.count = this.elementData.length;
    }

    public void copyInto(float[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.count);
    }

    public void copyInto(int index, float[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(this.elementData, index, array, offset, length);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.count < oldCapacity) {
            float[] newData = new float[this.count];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    protected void ensureCapacity(int minCapacity) {
        int capacity = this.elementData.length;
        if (minCapacity > capacity) {
            int n = capacity = this.capacityIncrement > 0 ? capacity + this.capacityIncrement : capacity << 1;
            if (capacity < minCapacity) {
                capacity = minCapacity;
            }
            float[] newData = new float[capacity];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Illegal newSize: " + newSize);
        }
        if (newSize > this.count) {
            this.ensureCapacity(newSize);
        }
        this.count = newSize;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public boolean contains(float elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(float elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(float elem, int index) {
        int i = index;
        while (i < this.count) {
            if (Float.floatToIntBits(elem) == Float.floatToIntBits(this.elementData[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(float elem) {
        return this.lastIndexOf(elem, this.count - 1);
    }

    public int lastIndexOf(float elem, int index) {
        int i = index;
        while (i >= 0) {
            if (Float.floatToIntBits(elem) == Float.floatToIntBits(this.elementData[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public float elementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public float firstElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public float lastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.count - 1];
    }

    public void setElementAt(float value, int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        this.elementData[index] = value;
    }

    public void removeElementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
    }

    public float removeLastElement() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[--this.count];
    }

    public void insertElementAt(float value, int index) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.count);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.count - index);
        this.elementData[index] = value;
        ++this.count;
    }

    public void addElement(float value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public boolean removeElement(float value) {
        int i = 0;
        while (i < this.count) {
            if (this.elementData[i] == value) {
                int j = this.count - i - 1;
                if (j > 0) {
                    System.arraycopy(this.elementData, i + 1, this.elementData, i, j);
                }
                --this.count;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeAllElements() {
        this.count = 0;
    }

    public Object clone() {
        ArrayFloat v = (ArrayFloat)super.clone();
        v.elementData = new float[this.count];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.count);
        return v;
    }

    public float[] toArray() {
        float[] result = new float[this.count];
        System.arraycopy(this.elementData, 0, result, 0, this.count);
        return result;
    }

    public float get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        return this.elementData[index];
    }

    public float set(int index, float element) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        float oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public void add(float value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public float remove(int index) {
        return this.removeAt(index);
    }

    public boolean remove(float value) {
        return this.removeElement(value);
    }

    public void add(int index, float element) {
        this.insertElementAt(element, index);
    }

    public float removeAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + 0);
        }
        float oldValue = this.elementData[index];
        int j = this.count - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.count;
        return oldValue;
    }

    public void clear() {
        this.removeAllElements();
    }

    public int hashCode() {
        int theCode = 0;
        int i = 0;
        while (i < this.count) {
            theCode += i;
            theCode ^= Float.floatToIntBits(this.elementData[i]);
            ++i;
        }
        return theCode;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append("\n[ size = " + this.count + "; capacityIncrement = " + this.capacityIncrement + "; capacity = " + this.elementData.length + " ]\n the elements are: [ ");
        int i = 0;
        while (i < this.count - 1) {
            s.append(this.elementData[i] + ", ");
            ++i;
        }
        if (this.count != 0) {
            s.append(this.elementData[this.count - 1]);
        }
        s.append(" ]");
        return s.toString();
    }

    public boolean equals(Object arrayFloat) {
        if (!(arrayFloat instanceof ArrayFloat)) {
            return false;
        }
        return ((ArrayFloat)arrayFloat).equals_(this);
    }

    protected boolean equals_(ArrayFloat arrayFloat) {
        if (this.count != arrayFloat.count) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            if (Float.floatToIntBits(this.elementData[i]) != Float.floatToIntBits(arrayFloat.elementData[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public EnumerationFloat elements() {
        return new EnumerationFloat(){
            private int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < ArrayFloat.this.count;
            }

            public float nextElement() {
                return ArrayFloat.this.elementData[this.counter++];
            }
        };
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " >= " + toIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex + " > " + this.count);
        }
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.count - toIndex);
        this.count -= toIndex - fromIndex;
    }

    public void sort() {
        int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
        int numNegZeros = 0;
        int i = 0;
        int n = this.count;
        while (i < n) {
            if (this.elementData[i] != this.elementData[i]) {
                this.elementData[i] = this.elementData[--n];
                this.elementData[n] = Float.NaN;
                continue;
            }
            if (this.elementData[i] == 0.0f && Float.floatToIntBits(this.elementData[i]) == NEG_ZERO_BITS) {
                this.elementData[i] = 0.0f;
                ++numNegZeros;
            }
            ++i;
        }
        this.qsort(0, n);
        if (numNegZeros != 0) {
            int j = this.binarySearch_(0.0f, 0, n - 1);
            while (--j > -1 && this.elementData[j] == 0.0f) {
            }
            int k = 0;
            while (k < numNegZeros) {
                this.elementData[++j] = -0.0f;
                ++k;
            }
        }
    }

    public void sort(boolean descending) {
        if (!descending) {
            this.sort();
            return;
        }
        int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
        int numNegZeros = 0;
        int i = -1;
        int n = this.count - 1;
        while (i < n) {
            if (this.elementData[n] != this.elementData[n]) {
                this.elementData[n] = this.elementData[++i];
                this.elementData[i] = Float.NaN;
                continue;
            }
            if (this.elementData[n] == 0.0f && Float.floatToIntBits(this.elementData[n]) == NEG_ZERO_BITS) {
                this.elementData[n] = 0.0f;
                ++numNegZeros;
            }
            --n;
        }
        this.qsortDesc(i + 1, this.count - (i + 1));
        if (numNegZeros != 0) {
            int j = this.binarySearch_(0.0f, i + 1, this.count - 1);
            while (++j < this.count && this.elementData[j] == 0.0f) {
            }
            int k = 0;
            while (k < numNegZeros) {
                this.elementData[--j] = -0.0f;
                ++k;
            }
        }
    }

    public void sort(int fromIndex, int toIndex) {
        this.rangeCheck(fromIndex, toIndex);
        int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (this.elementData[i] != this.elementData[i]) {
                this.elementData[i] = this.elementData[--n];
                this.elementData[n] = Float.NaN;
                continue;
            }
            if (this.elementData[i] == 0.0f && Float.floatToIntBits(this.elementData[i]) == NEG_ZERO_BITS) {
                this.elementData[i] = 0.0f;
                ++numNegZeros;
            }
            ++i;
        }
        this.qsort(fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = this.binarySearch_(0.0f, fromIndex, n - 1);
            while (--j >= fromIndex && this.elementData[j] == 0.0f) {
            }
            int k = 0;
            while (k < numNegZeros) {
                this.elementData[++j] = -0.0f;
                ++k;
            }
        }
    }

    public void sort(int fromIndex, int toIndex, boolean descending) {
        if (!descending) {
            this.sort(fromIndex, toIndex);
            return;
        }
        this.rangeCheck(fromIndex, toIndex);
        int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
        int numNegZeros = 0;
        int i = fromIndex - 1;
        int n = toIndex - 1;
        while (i < n) {
            if (this.elementData[n] != this.elementData[n]) {
                this.elementData[n] = this.elementData[++i];
                this.elementData[i] = Float.NaN;
                continue;
            }
            if (this.elementData[n] == 0.0f && Float.floatToIntBits(this.elementData[n]) == NEG_ZERO_BITS) {
                this.elementData[n] = 0.0f;
                ++numNegZeros;
            }
            --n;
        }
        this.qsortDesc(i + 1, toIndex - (i + 1));
        if (numNegZeros != 0) {
            int j = this.binarySearch_(0.0f, i + 1, toIndex - 1);
            while (++j < toIndex && this.elementData[j] == 0.0f) {
            }
            int k = 0;
            while (k < numNegZeros) {
                this.elementData[--j] = -0.0f;
                ++k;
            }
        }
    }

    private void qsortDesc(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.elementData[j - 1] < this.elementData[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        float v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.elementData[b] >= v) {
                if (this.elementData[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.elementData[c] <= v) {
                if (this.elementData[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsortDesc(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsortDesc(n - s, s);
        }
    }

    private void qsort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && this.elementData[j - 1] > this.elementData[j]) {
                    this.swap(j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >>> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len >>> 3;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        float v = this.elementData[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.elementData[b] <= v) {
                if (this.elementData[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.elementData[c] >= v) {
                if (this.elementData[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.qsort(off, s);
        }
        if ((s = d - c) > 1) {
            this.qsort(n - s, s);
        }
    }

    private void swap(int a, int b) {
        float temp = this.elementData[a];
        this.elementData[a] = this.elementData[b];
        this.elementData[b] = temp;
    }

    private void vecSwap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        return this.elementData[a] < this.elementData[b] ? (this.elementData[b] < this.elementData[c] ? b : (this.elementData[a] < this.elementData[c] ? c : a)) : (this.elementData[b] > this.elementData[c] ? b : (this.elementData[a] > this.elementData[c] ? c : a));
    }

    public int binarySearch(float key) {
        return this.binarySearch_(key);
    }

    private int binarySearch_(float key) {
        int low = 0;
        int high = this.count - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            float midVal = this.elementData[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                int keyBits;
                int midBits = Float.floatToIntBits(midVal);
                int n = midBits == (keyBits = Float.floatToIntBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearch(float key, boolean descending) {
        if (!descending) {
            return this.binarySearch(key);
        }
        int low = 0;
        int high = this.count - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            float midVal = this.elementData[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                int keyBits;
                int midBits = Float.floatToIntBits(midVal);
                int n = midBits == (keyBits = Float.floatToIntBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearch(float key, int low, int high) {
        return this.binarySearch_(key, low, high);
    }

    private int binarySearch_(float key, int low, int high) {
        this.rangeCheck(low, high + 1);
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            float midVal = this.elementData[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                int keyBits;
                int midBits = Float.floatToIntBits(midVal);
                int n = midBits == (keyBits = Float.floatToIntBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearch(float key, int low, int high, boolean descending) {
        if (!descending) {
            return this.binarySearch(key, low, high);
        }
        this.rangeCheck(low, high + 1);
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            float midVal = this.elementData[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                int keyBits;
                int midBits = Float.floatToIntBits(midVal);
                int n = midBits == (keyBits = Float.floatToIntBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void rangeCheck(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.count) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public void setAll(int index, ArrayFloat arrayFloat) {
        this.setAll(index, arrayFloat, 0, arrayFloat.size());
    }

    public void setAll(int index, ArrayFloat arrayFloat, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        arrayFloat.copyInto(offset, this.elementData, index, length);
    }

    public void setAll(int index, float[] array) {
        this.setAll(index, array, 0, array.length);
    }

    public void setAll(int index, float[] array, int offset, int length) {
        if (index + length > this.count) {
            throw new ArrayIndexOutOfBoundsException("(index + length)=" + (index + length) + " > size=" + this.count);
        }
        System.arraycopy(array, offset, this.elementData, index, length);
    }

    public void addAll(ArrayFloat arrayFloat) {
        this.addAll(arrayFloat, 0, arrayFloat.size());
    }

    public void addAll(ArrayFloat arrayFloat, int offset, int length) {
        this.ensureCapacity(this.count + length);
        arrayFloat.copyInto(offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(float[] array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(float[] array, int offset, int length) {
        this.ensureCapacity(this.count + length);
        System.arraycopy(array, offset, this.elementData, this.count, length);
        this.count += length;
    }

    public void addAll(int index, ArrayFloat arrayFloat) {
        this.addAll(index, arrayFloat, 0, arrayFloat.size());
    }

    public void addAll(int index, ArrayFloat arrayFloat, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        arrayFloat.copyInto(offset, this.elementData, index, length);
        this.count += length;
    }

    public void addAll(int index, float[] array) {
        this.addAll(index, array, 0, array.length);
    }

    public void addAll(int index, float[] array, int offset, int length) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + " > size=" + this.count);
        }
        this.ensureCapacity(this.count + length);
        System.arraycopy(this.elementData, index, this.elementData, index + length, this.count - index);
        System.arraycopy(array, offset, this.elementData, index, length);
        this.count += length;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elementData.length);
        int i = 0;
        while (i < this.count) {
            stream.writeFloat(this.elementData[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.elementData = new float[stream.readInt()];
        int i = 0;
        while (i < this.count) {
            this.elementData[i] = stream.readFloat();
            ++i;
        }
    }
}

